#ifndef __PLAYER_H
#define __PLAYER_H

#include "map.h"

extern BITMAP* buffer; // defined in main.c

typedef struct
{
  int x, y; // Position
  int dead;
  int lives;
  long score;
  int jumpstate; // 1:ground,2:jumping,3:falling; 1->2, 1->3, 3->1, NOT 2->3, NOT 3->2 is possible
  int jump_step; // How high the jump went so far
  int animation_frame; //0-2:walking, 0-5:jumping, 6-7:carrot kamikaze
  int animation_step; //0:next frame, PLAYER_ANIMATION_SPEED:reset to 0
  int direction; // 1:forwards, 2:backwards
} Player;

// Inits everything (including lives, score) of the player
void player_init( Player* p, Map* m );
// Sets the player to the start coordinates of the given map
void player_reset( Player* p, Map* m );

// Controls, logic
int player_advance( Player* p, Map* m );

// Drawing
void player_display( Player* p, Map* m );

#endif

