#include "music.h"

#ifdef GP2X
#include "ext/mikmod.h"
#else
#include <aldumb.h>
#endif

#include <allegro.h>
#include <string.h>
#include <malloc.h>

int playing = 0;
int do_repeat = 0;
const char* filename;
#ifdef GP2X
const int MUSIC_BUFFER_SIZE = 1024;

AUDIOSTREAM* stream;
MODULE* mod = NULL;

int music_init( void )
{
  md_mixfreq = 44100;
  //md_mode = DMODE_16BITS; //16bit doesn't work!!
  md_mode = DMODE_STEREO;
  md_device = 0;
  md_volume = 128;
  md_musicvolume = 128;
  md_sndfxvolume = 128;
  md_pansep = 128;
  md_reverb = 0;
  //#ifndef GP2X
  //md_mode |= DMODE_HQMIXER;
  //#endif
  md_mode |= DMODE_SOFT_MUSIC|DMODE_SURROUND;

  CHAR *list;

  list = MikMod_InfoDriver();
  if ( list )
    free(list);
  else
    MikMod_RegisterDriver(&drv_nos);
  list = MikMod_InfoLoader();
  if ( list )
    free(list);
  else
  {
    MikMod_RegisterLoader(&load_it);
    MikMod_RegisterLoader(&load_xm);
    MikMod_RegisterLoader(&load_s3m);
    MikMod_RegisterLoader(&load_mod);
    MikMod_RegisterLoader(&load_m15);
  }

  int result = MikMod_Init(NULL);
  if (result)
  {
    fprintf(stderr,"MikMod Init failed: %s",MikMod_strerror(MikMod_errno));
    return -1;
  }
  return 0;
}

void music_buffer_refill( void )
{
  if (!playing) return;
  if (!Player_Active())
  {
    if (do_repeat)
    {
      Player_SetPosition(0);
    }
    else
    {
      playing = 0;
      return;
    }
  }
  static int written = 0;
  unsigned char* p;
  p = get_audio_stream_buffer(stream);
  if (p != NULL)
  {
    written += VC_WriteBytes((void*)(p+written),MUSIC_BUFFER_SIZE*2-written);
    if (written>=MUSIC_BUFFER_SIZE)
    {
      free_audio_stream_buffer(stream);
      written = 0;
    }
  }
}

int music_play( const char* file, int repeat )
{
  if (mod != NULL || playing)
  {
    music_stop();
  }
  mod = Player_Load((CHAR*)file,64,0);
  Player_Start(mod);
  stream = play_audio_stream(MUSIC_BUFFER_SIZE, 8, TRUE, 44100, 255, 128);
  do_repeat = repeat;
  playing = 1;
  return 0;
}

int music_stop( void )
{
  if (playing)
  {
    Player_Stop();
    stop_audio_stream(stream);
    Player_Free(mod);
    mod = NULL;
    playing = 0;
  }
  return 0;
}

int music_quit( void )
{
  MikMod_Exit();
  return 0;
}
#else
DUH* mod = NULL;
AL_DUH_PLAYER *dp;

int music_init( void )
{
  dumb_register_stdfiles();
  dumb_resampling_quality = 4;
  dumb_it_max_to_mix = 128;
  return 0;
}

void music_buffer_refill( void )
{
  if (!playing) return;
  al_poll_duh(dp);
}

int music_play( const char* file, int repeat )
{
  if (mod != NULL || playing)
  {
    music_stop();
  }
  mod = dumb_load_it(file);
  if (!mod) {
    mod = dumb_load_xm(file);
    if (!mod) {
      mod = dumb_load_s3m(file);
      if (!mod) {
	mod = dumb_load_mod(file);
	if (!mod) {
	  fprintf(stderr,"Failed to load %s!\n", file);
	  return -1;
	}
      }
    }
  }
  dp = al_start_duh(mod, 2, 0, 1.0f,4096,44100);
  do_repeat = repeat;
  playing = 1;
  return 0;
}

int music_stop( void )
{
  if (playing)
  {
    al_stop_duh(dp);
    dp = NULL;
    unload_duh(mod);
    mod = NULL;
    playing = 0;
  }
  return 0;
}

int music_quit( void )
{
  dumb_exit();
  return 0;
}
#endif

