#include "enemy.h"
#include <stdio.h>
#include "../explosion.h"

const int ENEMY_SPEED = 1;

Enemy enemies[20];
int enemy_index;

void _enemies_create_enemy( Map* m, int x, int direction )
{
  int i = enemy_index;
  if (i>=MAX_ENEMIES)
  {
    return;
  }
  enemies[i].direction = direction;
  enemies[i].dead = 0;
  enemies[i].x = x*TILESIZE;
  enemies[i].y = map_ground_number(m,x)*TILESIZE;
  enemies[i].roll_step = 0;
  enemy_index++;
}

void enemies_create( Map* m, int level )
{
  enemy_index = 0;
  switch(level)
  {
    case 2:
      _enemies_create_enemy(m,7,2);
      _enemies_create_enemy(m,9,2);
      _enemies_create_enemy(m,11,2);
      _enemies_create_enemy(m,16,2);
      _enemies_create_enemy(m,20,2);
      _enemies_create_enemy(m,28,2);
      _enemies_create_enemy(m,47,2);
      _enemies_create_enemy(m,55,2);
      _enemies_create_enemy(m,60,2);
      _enemies_create_enemy(m,93,2);
      break;
    case 4:
      _enemies_create_enemy(m,4,1);
      _enemies_create_enemy(m,9,2);
      _enemies_create_enemy(m,35,2);
      _enemies_create_enemy(m,57,2);
      _enemies_create_enemy(m,70,2);
      _enemies_create_enemy(m,79,2);
      _enemies_create_enemy(m,80,2);
      _enemies_create_enemy(m,81,2);
      _enemies_create_enemy(m,90,2);
      _enemies_create_enemy(m,113,2);
      _enemies_create_enemy(m,118,2);
      _enemies_create_enemy(m,125,2);
      _enemies_create_enemy(m,142,2);
      break;
    case 5:
      _enemies_create_enemy(m,3,2);
      break;
    default: return;
  }
}

void _enemies_delete_enemy( int index )
{
  int i;
  for (i=index; i<enemy_index; ++i)
  {
    enemies[i] = enemies[i+1];
  }
  enemy_index--;
}

void _enemies_advance_enemy( Map* m, Player* p, int index )
{
  Enemy* e = &enemies[index];
  int tx, ty;
  int rpx, rpy;

  // Death of the enemy
  while (e->dead)
  {
    e->dead++;
    if (e->dead>50)
    {
      _enemies_delete_enemy(index);
    }
    else
    {
      return;
    }
  }

  switch (e->direction)
  {
    case 1:
      e->x-=ENEMY_SPEED;
      break;
    case 2:
      e->x+=ENEMY_SPEED;
      break;
    default: break;
  }

  tx = e->x/TILESIZE;
  if (e->direction==2) tx++;
  ty = e->y/TILESIZE;

  if (map_tile_solid(m,tx,ty) || !map_tile_solid(m,tx,ty+1)) //Before he bumps/falls left/right he turns around
  {
    switch (e->direction)
    {
      case 1:
	e->direction = 0;
	e->roll_step = 0;
	break;
      case 2:
	e->direction = 3;
	e->roll_step = 0;
	break;
      default: break;
    }
  }

  e->roll_step += ENEMY_SPEED;
  if (e->roll_step>TILESIZE)
  {
    e->roll_step = 0;
    switch (e->direction)
    {
      case 0:
	e->direction = 2;
	break;
      case 3:
	e->direction = 1;
	break;
      default: break;
    }
  }

  // Collision with player
  rpx = p->x + m->offset*TILESIZE + m->fine_offset;
  rpy = p->y;
  if ((e->x >= rpx-TILESIZE+5) && (e->x <= rpx+TILESIZE-5)
   && (e->y >= rpy) && (e->y <= rpy+TILESIZE-15))
  {
    if (p->jumpstate == 3)
    {
      e->dead = 1;
      p->jumpstate = 2;
      p->jump_step = 0;
      p->y-=5;
      p->score+=100;
      explosions_create(m,e->x-m->offset*TILESIZE-m->fine_offset+TILESIZE/2,e->y+TILESIZE/2,makecol16(200,0,0),100);
      play_sample(data[SND_ENEMY].dat,150,127,1000,0);
    }
    else
    {
      if (!p->dead)
      {
	p->dead++;
	play_sample(data[SND_DEAD].dat,255,127,1000,0);
      }
    }
  }
}

void enemies_advance( Map* m, Player* p )
{
  int i;
  for (i=0; i<enemy_index; ++i)
  {
    _enemies_advance_enemy(m,p,i);
  }
}


void enemies_display( Map* m )
{
  int i;
  int d_offset;
  fixed angle;
  int x, y;
  BITMAP *enemy_bmp;

  for (i=0; i<enemy_index; ++i)
  {
    x = enemies[i].x-m->offset*TILESIZE-m->fine_offset;
    y = enemies[i].y+2;
    if (x>=0 && x<320)
    {
      if (enemies[i].dead)
      {
	masked_blit(data[ENEMY04].dat,buffer,0,0,x,y+1,TILESIZE,TILESIZE);
      }
      else
      {
	d_offset = enemies[i].direction;
	if (d_offset > 2 || d_offset < 1) // right and left turnaround look the same
	{
	  d_offset = 0;
	  angle = itofix( 0 );
	}
	else
	{
	  switch (d_offset)
	  {
	    case 1:
	      angle = itofix( 256-enemies[i].roll_step*256/TILESIZE );
	      break;
	    case 2:
	      angle = itofix( enemies[i].roll_step*256/TILESIZE );
	      break;
	  }
	}
	switch (d_offset)
	{
	  case 0:
	    enemy_bmp = data[ENEMY01].dat;
	    break;
	  case 1:
	    enemy_bmp = data[ENEMY02].dat;
	    break;
	  case 2:
	    enemy_bmp = data[ENEMY03].dat;
	    break;
	  case 3:
	    enemy_bmp = data[ENEMY04].dat;
	    break;
	  default: return;
	}
	rotate_sprite(buffer, enemy_bmp, x, y, angle);
      }
    }
  }
}

