#ifndef __MAP_H
#define __MAP_H

#define MAX_POWERUPS 50

#include <allegro.h>
#include "data.h"

extern const int TILESIZE;

extern BITMAP* buffer; //defined in main.c
extern DATAFILE* data;

typedef struct
{
  int x,y;
  short type; //1=Star,2=Heart,3=Ice,4=Emerald
  int gone;
} Powerup;

typedef struct
{
  // Size of the map (how many columns)
  long length;
  // Landscape array in bit-format.
  // One number represents one column of 8 tiles, which is the screen height.
  unsigned char* landscape;

  long offset; // current offset (beginning = 0)
  int fine_offset; // fine offset (<TILESIZE)

  Powerup powerups[MAX_POWERUPS];
} Map;

// Creating and destroying
Map* map_create( long length );
void map_destroy( Map** map );

// Loading and saving
Map* map_load( const char* filename );
void map_save( Map* m, const char* filename );

// Removes a powerup from the map
void map_eat_powerup( Map* m, int index );

// Returns the powerup INDEX, not the type. Use map->powerups[x].type to get it!
int map_powerup( Map* m, int x, int y );
// Collision checking - TILE coordinates
int map_tile_solid( Map* m, int x, int y );
// Ground number - the first tile from the bottom that is not solid
int map_ground_number( Map* m, int x );

// Drawing
void map_display( Map* m );

#endif

