#ifndef __EXPLOSION_H
#define __EXPLOSION_H

#include <allegro.h>
#include "map.h"

#define EXPL_PARTICLE_NUMBER 30
#define MAX_EXPLOSIONS 10

extern BITMAP* buffer; //defined in main.c

typedef struct
{
  int x, y;
  float v_x, v_y;
  int travel; // distance travelled so far
} Particle;

typedef struct
{
  Particle particles[EXPL_PARTICLE_NUMBER];
  int x, y; // explosion center 
  int color;
  int step;
  int animation_step;
  int score;
} Explosion;

void explosions_create( Map* m, int x, int y, int color, int score );
void explosions_advance( void );
void explosions_display( Map* m );

#endif
