#include "explosion.h"
#include <stdlib.h>
#include <stdio.h>

Explosion explosions[MAX_EXPLOSIONS];
int explosion_index = 0;

const int EXPL_MAX_STEP = 10;
const int EXPL_MAX_SIZE = 20;
const int EXPL_ANIM_SPEED = 3;

void explosions_create( Map* m, int pos_x, int pos_y, int color, int score )
{
  int i;
  const int pn = EXPL_PARTICLE_NUMBER;

  int speed;
  int x, y;

  if (explosion_index >= MAX_EXPLOSIONS)
  {
    return;
  }

  explosions[explosion_index].step = 0;
  explosions[explosion_index].animation_step = 0;
  explosions[explosion_index].color = color;
  explosions[explosion_index].score = score;

  for (i=0; i<pn; ++i)
  {
    if (i<pn*100/8/100)
    {
      x=1;
      y=-1;
    }
    else if (i<pn*100/4/100)
    {
      x=1;
      y=0;
    }
    else if (i<pn*100/8*3/100)
    {
      x=1;
      y=1;
    }
    else if (i<pn*100/2/100)
    {
      x=0;
      y=1;
    }
    else if (i<pn*100/8*5/100)
    {
      x=-1;
      y=1;
    }
    else if (i<pn*100/4*3/100)
    {
      x=-1;
      y=0;
    }
    else if (i<pn*100/8*7/100)
    {
      x=-1;
      y=-1;
    }
    else
    {
      x=0;
      y=-1;
    }
    speed = rand()%4 + 1;
    explosions[explosion_index].particles[i].x = pos_x + m->offset*TILESIZE + m->fine_offset;
    explosions[explosion_index].particles[i].y = pos_y;
    explosions[explosion_index].particles[i].v_x = speed*x;
    explosions[explosion_index].particles[i].v_y = speed*y;
    explosions[explosion_index].particles[i].travel = 0;
  }
  explosions[explosion_index].x = pos_x + m->offset*TILESIZE + m->fine_offset;
  explosions[explosion_index].y = pos_y;
  explosion_index++;
}

void explosions_advance( void )
{
  int i,j;
  for (i=0; i<explosion_index; ++i)
  {
    explosions[i].animation_step++;
    if (explosions[i].animation_step>=EXPL_ANIM_SPEED)
    {
      explosions[i].animation_step = 0;
      explosions[i].step++;
      if (explosions[i].step > EXPL_MAX_STEP)
      {
	for (j=i; j<MAX_EXPLOSIONS-1; ++j)
	{
	  explosions[j] = explosions[j+1];
	}
	explosion_index--;
	return;
      }
      for (j=0; j<EXPL_PARTICLE_NUMBER; ++j)
      {
	if (explosions[i].particles[j].travel < EXPL_MAX_SIZE)
	{
	  explosions[i].particles[j].x += explosions[i].particles[j].v_x;
	  explosions[i].particles[j].y += explosions[i].particles[j].v_y;
	  explosions[i].particles[j].travel += abs(explosions[i].particles[j].v_x);
	  explosions[i].particles[j].travel += abs(explosions[i].particles[j].v_y);
	}
      }
    }
  }
}

void explosions_display( Map* m )
{
  int i,j;
  int x,y;
  for (i=0; i<explosion_index; ++i)
  {
    for (j=0; j<EXPL_PARTICLE_NUMBER; ++j)
    {
      x = explosions[i].particles[j].x - m->offset*TILESIZE - m->fine_offset;
      y = explosions[i].particles[j].y;
      circle(buffer,x,y,2,explosions[i].color);
    }
    x = explosions[i].x - m->offset*TILESIZE - m->fine_offset;
    y = explosions[i].y;
    textprintf_ex(buffer,font,x-12,y-4,makecol16(100,100,100),-1,"+%d",explosions[i].score);
  }
}
