#include <stdio.h>
#include <string.h>
#include "../map.h"

#define FRAME_RATE 60

FILE* f_log;
BITMAP* buffer;
DATAFILE* data;
volatile int timer_ticks = 0;

void timer_callback( void )
{
  ++timer_ticks;
}

void flip_screen( void )
{
  stretch_blit(buffer,screen,0,0,SCREEN_W/2,SCREEN_H/2,0,0,SCREEN_W,SCREEN_H);
}

// Indicates the next free powerup index
int powerup_index;
void _toggle_powerup( Map* map, int x, int y, short type )
{
  int delete;
  int del_index;
  int i;

  delete = 0;
  for (i=0; i<MAX_POWERUPS; ++i)
  {
    if (map->powerups[i].x == x && map->powerups[i].y == y && !map->powerups[i].gone)
    {
      delete = 1;
      del_index = i;
    }
  }

  if (delete)
  {
    for (i=del_index; i<MAX_POWERUPS-1; ++i)
    {
      map->powerups[i] = map->powerups[i+1];
    }
    map->powerups[MAX_POWERUPS-1].gone = -1;
    powerup_index--;
    return;
  }
  else
  {
    if (powerup_index >= MAX_POWERUPS) return;
    map->powerups[powerup_index].gone = 0;
    map->powerups[powerup_index].x = x;
    map->powerups[powerup_index].y = y;
    map->powerups[powerup_index].type = type;
    powerup_index++;
  }
}

int main(int argc, char** argv)
{
  Map* map;
  char filename[80];
  long length;

  int mt_x, mt_y,
      mt_x_new, mt_y_new;
  int mcorner_x, mcorner_y;
  int l_clicked, r_clicked;

  short selected_powerup = 0;

  f_log = fopen("editor_log.txt","w");

  if (argc == 2)
  {
    strcpy(filename,argv[1]);
    map = map_load(filename);
    powerup_index = 0;
    while (!map->powerups[powerup_index].gone && powerup_index<MAX_POWERUPS)
    {
      powerup_index++;
    }
  }
  else if (argc == 3)
  {
    strcpy(filename,argv[1]);
    length = atoi(argv[2]);
    map = map_create(length);
    powerup_index = 0;
  }
  else
  {
    printf("*** Map Editor ***\n\n");
    printf("Usage:\n");
    printf("%s <filename> <size> for creating a new map\n",argv[0]);
    printf("%s <filename> for editing an existing map\n",argv[0]);
    return -1;
  }

  allegro_init();
  install_keyboard();
  install_mouse();

  set_color_depth(16);
  set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
  buffer = create_bitmap(320,240);
  data = load_datafile("data.dat");
  install_int_ex(timer_callback,BPS_TO_TIMER(FRAME_RATE));

  l_clicked = 0;
  r_clicked = 0;
  while (!key[KEY_ESC])
  {
    while (timer_ticks>0)
    {
      if (key[KEY_LEFT])
      {
	map->offset-=3;
	if (map->offset<0)
	{
	  map->offset = 0;
	}
	key[KEY_LEFT] = 0;
      }
      if (key[KEY_RIGHT])
      {
	map->offset+=3;
	if (map->offset>=(map->length-320/30))
	{
	  map->offset = map->length-320/30-1;
	}
	key[KEY_RIGHT] = 0;
      }
      if (key[KEY_TAB])
      {
	selected_powerup++;
	if (selected_powerup>3)
	{
	  selected_powerup = 0;
	}
	key[KEY_TAB] = 0;
      }
      if (mouse_b & 1)
      {
	if (!l_clicked)
	{
	  l_clicked = 1;
	  map->landscape[mt_x] ^= 1<<mt_y;
	}
      }
      else
      {
	l_clicked = 0;
      }

      if (mouse_b & 2)
      {
	if (!r_clicked)
	{
	  r_clicked = 1;
	  _toggle_powerup(map,mt_x,mt_y,selected_powerup);
	}
      }
      else
      {
	r_clicked = 0;
      }

      mt_x_new = mouse_x / TILESIZE + map->offset;
      mt_y_new = mouse_y / TILESIZE;
      if (mt_x_new != mt_x)
      {
	mt_x = mt_x_new;
	l_clicked = 0;
      }
      if (mt_y_new != mt_y)
      {
	mt_y = mt_y_new;
	l_clicked = 0;
      }
      mcorner_x = mouse_x - mouse_x%TILESIZE;
      mcorner_y = mouse_y - mouse_y%TILESIZE;

      timer_ticks--;
    }
    clear_to_color(buffer,makecol16(0,100,0));
    map_display(map);
    rect(buffer,mcorner_x,mcorner_y,mcorner_x+TILESIZE,mcorner_y+TILESIZE,makecol16(255,0,0));
    draw_sprite(buffer,mouse_sprite,mouse_x,mouse_y);

    textprintf_ex(buffer,font,5,5,makecol16(0,0,0),-1,"%d,%d",mt_x,mt_y);
    flip_screen();
  }
  map_save(map,filename);
  map_destroy(&map);

  remove_int(timer_callback);
  unload_datafile(data);
  destroy_bitmap(buffer);
  allegro_exit();
  fclose(f_log);
  return 0;
}

