#include <allegro.h>
#include "controls.h"
#include "music.h"

// Joystick functions for the GP2X
#ifdef GP2X
void wait_joy_button(int num, int state)
{
  int pressed = 0;
  int c;
  do {
    pressed = 0;
    poll_joystick();
    for (c=0; c<joy[num].num_buttons; c++)
    {
      if (joy[num].button[c].b)
      {
	pressed = 1;
      }
    }
    music_buffer_refill();
    rest(1);
  } while (pressed != state);
}

void readjoy()
{
  wait_joy_button(0,0);
  wait_joy_button(0,1);
}

int joypressed()
{
  static int pressed = 0;
  int ret;
  int stick,button;
  int pressed_now = 0;
  
  poll_joystick();

  for (stick = 0; stick < num_joysticks; ++stick)
  {
    for (button = 0; button < joy[stick].num_buttons; ++button)
    {
      if (joy[stick].button[button].b)
      {
	pressed_now = 1;
	break;
      }
    }
    if (pressed_now) break;
  }

  ret = (pressed_now && !pressed);
  pressed = pressed_now;
  return ret;
}

void wait_joy_axis_released()
{
  do
  {
    poll_joystick();
    rest(5);
  } while (joy[0].stick[0].axis[0].d1 || joy[0].stick[0].axis[0].d2 || joy[0].stick[0].axis[1].d1 || joy[0].stick[0].axis[1].d2);
}
#endif

void clear_buttons( void )
{
#ifdef GP2X
  /*
  int stick, button;
  poll_joystick();

  for (stick = 0; stick < num_joysticks; ++stick)
  {
    for (button = 0; button < joy[stick].num_buttons; ++button)
    {
      joy[stick].button[button].b = 0;
    }
  }
  */
  wait_joy_button(0,0);
#else
  key[KEY_A]=0;
  key[KEY_S]=0;
  key[KEY_Z]=0;
  key[KEY_X]=0;
  key[KEY_Q]=0;
  key[KEY_W]=0;
  key[KEY_ESC]=0;
#endif
}

void readkey2( void )
{
#ifdef GP2X
  readjoy();
#else
  clear_keybuf();
  readkey();
#endif
}

int keypressed2( void )
{
#ifdef GP2X
  return joypressed();
#else
  return keypressed();
#endif
}

int button_A( void )
{
#ifdef GP2X
  return joy[0].button[3].b;
#else
  return key[KEY_Z];
#endif
}

int button_B( void )
{
#ifdef GP2X
  return joy[0].button[0].b;
#else
  return key[KEY_S];
#endif
}

int button_X( void )
{
#ifdef GP2X
  return joy[0].button[1].b;
#else
  return key[KEY_X];
#endif
}

int button_Y( void )
{
#ifdef GP2X
  return joy[0].button[2].b;
#else
  return key[KEY_A];
#endif
}

int button_L( void )
{
#ifdef GP2X
  return joy[0].button[5].b;
#else
  return key[KEY_Q];
#endif
}

int button_R( void )
{
#ifdef GP2X
  return joy[0].button[4].b;
#else
  return key[KEY_W];
#endif
}

int button_Exit( void )
{
#ifdef GP2X
  return (button_L() && button_R());
#else
  return key[KEY_ESC];
#endif
}

int d_left( void )
{
#ifdef GP2X
  return joy[0].stick[0].axis[0].d1;
#else
  return key[KEY_LEFT];
#endif
}

int d_right( void )
{
#ifdef GP2X
  return joy[0].stick[0].axis[0].d2;
#else
  return key[KEY_RIGHT];
#endif
}

int d_up( void )
{
#ifdef GP2X
  return joy[0].stick[0].axis[1].d1;
#else
  return key[KEY_UP];
#endif
}

int d_down( void )
{
#ifdef GP2X
  return joy[0].stick[0].axis[1].d2;
#else
  return key[KEY_DOWN];
#endif
}

