/* This is player.c with the old
 * collision detection code.
 * Not many differences...
 */

#include "player.h"
#include "controls.h"
#include "explosion.h"
#include "level/collapse.h"
#include <stdio.h>
#include <stdlib.h>

// walk 3 pixels per cycle
const int WALK_SPEED = 3;
// jump max 50 pixels high
const int MAX_JUMP = 70;
// animation speed
const int PLAYER_ANIMATION_SPEED = 5;

void player_init( Player* p, Map* m )
{
  p->lives = 3;
  p->score = 0;
  player_reset(p,m);
}

void player_reset( Player* p, Map* m )
{
  int ground;
  p->x = 0;
  ground = map_ground_number(m,0);
  p->y = map_ground_number(m,0) * TILESIZE;
  if (!map_tile_solid(m,0,ground-1))
  {
    p->y -= TILESIZE;
  }
  p->dead = 0;
  p->jumpstate = 1;
  p->jump_step = 0;
  p->animation_frame = 0;
  p->direction = 1;
  m->offset = 0;
  m->fine_offset = 0;
  collapse_reset();
}

void _player_setanim( Player* p, int frame )
{
  if (p->animation_step == 0)
  {
    p->animation_frame = frame;
  }
}

void _player_do_scrolling( Player* p, Map* m )
{
  // Additional scrolling offset
  int new_offset;

  // Scrolling
  new_offset = p->x - 160;
  if (m->offset >= m->length - 320/TILESIZE-1 && new_offset>0)
  {
    return;
  }
  if (m->offset <= 0 && new_offset<0) 
  {
    new_offset = 0;
  }
  m->fine_offset += new_offset;
  p->x -= new_offset;
  m->offset += m->fine_offset/TILESIZE;
  m->fine_offset = m->fine_offset%TILESIZE;
}

void _player_check_powerups( Player* p, Map* m )
{
  int tile_x, tile_y;
  int fine_x, fine_y;
  int index;
  int color;
  int i,j;
  int score;

  tile_x = (p->x+m->fine_offset) / TILESIZE + m->offset;
  fine_x = (p->x+m->fine_offset) % TILESIZE;
  tile_y = p->y / TILESIZE;
  fine_y = p->y % TILESIZE;

  for (i=0; i<=(fine_x>0)?1:0; ++i)
  {
    for (j=0; j<=(fine_y>0)?1:0; ++j)
    {
      index = map_powerup(m,tile_x+i,tile_y+j);
      if (index != -1)
      {
	switch (m->powerups[index].type)
	{
	  case 0:
	    color = makecol16(255,255,0);
	    score = 10;
	    p->score+=score;
	    break;
	  case 1:
	    color = makecol16(255,0,0);
	    score = 1;
	    p->lives+=score;
	    break;
	  case 2:
	    color = makecol16(100,100,255);
	    score = 50;
	    p->score+=score;
	    break;
	  case 3:
	    color = makecol16(0,255,0);
	    score = 500;
	    p->score+=score;
	    break;
	  default: break;
	}
	explosions_create(m,m->powerups[index].x*TILESIZE-m->offset*TILESIZE-m->fine_offset+TILESIZE/2,
	    m->powerups[index].y*TILESIZE+TILESIZE/2,color,score);
	map_eat_powerup(m,index);
      }
    }
  }
}

// return value - 0:nothing,1:level end,-1:player dead
// DON'T ... EVER ... TOUCH THIS FUNCTION!!!
int player_advance( Player* p, Map* m )
{
  int retval = 0;
  // Tile position, always check for two tiles
  int tile_x, tile_y;
  int tile2_x, tile2_y;
  // Movement vector
  int v_x = 0, v_y = 0;
  // Movement failure value (collision)
  int failure;

  if (p->x>320)
  {
    return 1; //Level finished
  }

  if (p->y>240-TILESIZE)
  {
    p->dead++;
    if (p->dead == 1)
    {
      play_sample(data[SND_DEAD].dat,255,127,1000,0);
    }
  }

  // Direction keys
  if (!p->dead)
  {
    if (d_left())
    {
      p->direction = 2;
      v_x = -WALK_SPEED;
    }
    else if (d_right())
    {
      p->direction = 1;
      v_x = WALK_SPEED;
    }
    // Jumping
    if (button_B())
    {
      if (p->jumpstate == 1)
      {
	p->jumpstate = 2;
	p->jump_step = WALK_SPEED; // jump_accel is being resetted here!
	v_y = -WALK_SPEED;
	_player_setanim(p,3); // first jump frame
	play_sample(data[SND_JUMP].dat,200,127,1000,0);
      }
      else if (p->jumpstate == 2)
      {
	if (p->jump_step <= WALK_SPEED) // second frame
	{
	  _player_setanim(p,1);
	}
	else
	{
	  _player_setanim(p,4);
	}
	p->jump_step += WALK_SPEED;
	v_y = -WALK_SPEED;
	if (p->jump_step >= MAX_JUMP)
	{
	  p->jumpstate = 3;
	  v_y += p->jump_step - MAX_JUMP; // Can be +=0 in the worst case, but doesn't matter
	}
      }
    }
    else
    {
      if (p->jumpstate == 2)
      {
	p->jumpstate = 3;
      }
    }
  } //if(!p->dead)
  else
  {
    p->jumpstate = 3;
    v_x = 0;
  }

  if (p->jumpstate == 3)
  {
    v_y = WALK_SPEED;
  }

  // Virtual tile position, checking for collisions
  // -- X component
  tile_x = (p->x + v_x + m->fine_offset) / TILESIZE + m->offset;
  if (v_x>0) ++tile_x; // Forward: We need additional player width = TILESIZE
  tile_y = p->y / TILESIZE;
  tile2_y = tile_y;
  if ((p->y%TILESIZE)>0)
  {
    ++tile2_y;
  }

  if (map_tile_solid(m,tile_x,tile_y) || map_tile_solid(m,tile_x,tile2_y))
  {
    failure = (p->x + v_x + m->fine_offset) % TILESIZE;
    if (v_x < 0)
    {
      v_x += TILESIZE-failure;
      if (v_x>0) v_x = 0;
    }
    else
    {
      v_x -= failure;
      if (v_x<0) v_x = 0;
    }
  }
  // -- Y component
  tile_x = (p->x + v_x + m->fine_offset) / TILESIZE + m->offset;
  tile2_x = tile_x;
  if ((p->x + v_x + m->fine_offset)%TILESIZE > 0)
  {
    ++tile2_x;
  }
  tile_y = (p->y + v_y) / TILESIZE;
  // FALL
  if (p->jumpstate == 1 && v_y == 0 )
  { 
    if ((p->x + m->fine_offset)%TILESIZE < WALK_SPEED*2 && !map_tile_solid(m,tile_x,tile_y+1))
    {
      p->x -= (p->x + m->fine_offset)%TILESIZE;
      v_y = WALK_SPEED;
      p->jumpstate = 3;
    }
    else if ((p->x + m->fine_offset)%TILESIZE > (TILESIZE-WALK_SPEED*2) && !map_tile_solid(m,tile2_x,tile_y+1))
    {
      p->x += TILESIZE-(p->x + m->fine_offset)%TILESIZE;
      v_y = WALK_SPEED;
      p->jumpstate = 3;
    }
    // WARNING: This needs one cycle to take effect
  }
  if (v_y>0) ++tile_y; // Down: We need additional player height = TILESIZE

  if (map_tile_solid(m,tile_x,tile_y) || map_tile_solid(m,tile2_x,tile_y))
  {
    failure = (p->y + v_y) % TILESIZE;
    if (v_y < 0) // raising
    {
      if (p->jumpstate == 2)
      {
	if ((p->x + m->fine_offset)%TILESIZE < WALK_SPEED*2 && !map_tile_solid(m,tile_x,tile_y))
	{
	  p->x -= (p->x + m->fine_offset)%TILESIZE;
	}
	else if ((p->x + m->fine_offset)%TILESIZE > (TILESIZE-WALK_SPEED*2) && !map_tile_solid(m,tile2_x,tile_y))
	{
	  p->x += TILESIZE-(p->x + m->fine_offset)%TILESIZE;
	}
	else
	{
	  p->jumpstate = 3;
	}
      }
      v_y += TILESIZE-failure;
      if (v_y>0) v_y = 0;
    }
    else // falling
    {
      v_y -= failure;
      if (v_y<0) v_y = 0;
      if (p->jumpstate == 3)
      {
	p->jumpstate = 1;
      }
    }
  }

  // Player advance (position)
  p->x += v_x;
  p->y += v_y;
  if (p->y < 0)
  {
    p->y = 0;
  }

  _player_check_powerups(p,m);

  // Player advance (animation)
  if (p->jumpstate == 1)
  {
    if (v_x == 0)
    {
      _player_setanim(p,0);
    }
    else
    {
      _player_setanim(p,p->animation_frame+1);
      if (p->animation_frame > 2)
      {
	_player_setanim(p,0);
      }
    }
  }
  else
  {
    if (v_x == 0)
    {
      switch (p->animation_frame)
      {
	case 1:
	  _player_setanim(p,0);
	  break;
	case 2:
	  _player_setanim(p,0);
	  break;
	case 4:
	  _player_setanim(p,1);
	  break;
	case 5:
	  _player_setanim(p,2);
	  break;
      }
    }
    else
    {
      if (p->jumpstate == 3)
      {
	switch (p->animation_frame)
	{
	  case 0:
	    _player_setanim(p,2);
	    break;
	  case 1:
	    _player_setanim(p,0);
	    break;
	  case 2:
	    _player_setanim(p,5);
	    break;
	  case 4:
	    _player_setanim(p,1);
	    break;
	  default:
	    break;
	}
      }
    }
  }

  p->animation_step++;
  if (p->animation_step>PLAYER_ANIMATION_SPEED)
  {
    p->animation_step = 0;
    if (p->dead)
    {
      p->dead++;
      if (p->dead>20)
      {
	/*
	p->lives--;
	if (p->lives>=0)
	{
	  player_reset(p,m);
	}
	*/
	retval = -1;
      }
    }
  }

  _player_do_scrolling(p,m);

  return retval;
}

void player_display( Player* p, Map* m )
{
  if (p->dead)
  {
    p->animation_frame = p->dead;
    if (p->animation_frame > 7)
    {
      p->animation_frame = 7;
    }
    switch (p->direction)
    {
      case 1:
	masked_blit(data[SNOWMANDEAD].dat,buffer,p->animation_frame*TILESIZE,0,p->x,p->y+2,TILESIZE,TILESIZE);
	break;
      case 2:
	masked_blit(data[SNOWMANDEAD_F].dat,buffer,p->animation_frame*TILESIZE,0,p->x,p->y+2,TILESIZE,TILESIZE);
	break;
    }
  }
  else
  {
    switch (p->direction)
    {
      case 1:
	masked_blit(data[SNOWMAN].dat,buffer,p->animation_frame*TILESIZE,0,p->x,p->y+2,TILESIZE,TILESIZE);
	break;
      case 2:
	masked_blit(data[SNOWMAN_F].dat,buffer,p->animation_frame*TILESIZE,0,p->x,p->y+2,TILESIZE,TILESIZE);
	break;
    }
  }
}

