#include <allegro.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include "music.h"
#include "controls.h"
#include "player.h"
#include "map.h"
#include "data.h"
#include "explosion.h"
#include "level/background.h"
#include "level/enemy.h"
#include "level/collapse.h"
#include "level/boss.h"
#include "intro.h"
#include "hud.h"

#define FRAME_RATE 60 //Fixed frame rate
//#define GP2X //Compiling for gp2x?

FILE* f_log;
BITMAP* buffer;
DATAFILE* data;
volatile int timer_ticks = 0;

int screen_shake = 0;

void timer_callback( void )
{
  ++timer_ticks;
}

void flip_screen( void )
{
#ifdef GP2X
  blit(buffer,screen,0,0,0,screen_shake,SCREEN_W,SCREEN_H);
#else
  stretch_blit(buffer,screen,0,0,SCREEN_W/2,SCREEN_H/2,0,screen_shake,SCREEN_W,SCREEN_H);
#endif
}

int level_screen( int level )
{
  int y1 = 100, y2 = 120;
  int color2 = makecol16(150,150,150);
  const char* descriptions[] = {"The Beginning", "Enemy Territory", "Run!", "Jump'n'Run!", "The End"};

  music_stop();
  clear_buttons();
  while (!button_Exit() && !button_B())
  {
#ifdef GP2X
    poll_joystick();
#endif
    clear(buffer);
    textprintf_centre_ex(buffer,data[VERASERIF].dat,160,y1,makecol16(255,255,255),-1,
	"Level %d",level);
    textprintf_centre_ex(buffer,data[VERASERIF].dat,160,y2,color2,-1,descriptions[level-1]);
    music_buffer_refill();
    flip_screen();
    rest(1);
  }
  if (button_Exit())
  {
    return -1;
  }
  else
  {
    return 0;
  }
}


// Return values: -1:ESC, 0:next level, 1:dead
int game( Player* player, Map* map, int level )
{
  int retval;
  int gameover_played = 0;;

  timer_ticks = 0;
  boss_reset();
  enemies_create(map,level);
  collapse_start(level,10,1);
  clear_buttons();
  while (!button_Exit())
  {
#ifdef GP2X
    poll_joystick();
#endif
    while (timer_ticks>0)
    {
      boss_try_battle(player,map,level);
      if (!boss_battle_running())
      {
	retval = player_advance(player,map);
	if (retval == -1)
	{
	  player->lives--;
	  if (player->lives>=0)
	  {
	    return 1;
	  }
	  else
	  {
	    // nooo!
	    if (!gameover_played)
	    {
	      play_sample(data[SND_GAMEOVER].dat,255,127,1000,0);
	      gameover_played = 1;
	    }
	  }
	}
	else if (retval == 1)
	{
	  play_sample(data[SND_FINISHED].dat,255,127,1000,0);
	  return 0; //Yehaa!
	}
	enemies_advance(map,player);
	collapse_advance(player,map);
      }
      else
      {
	if (boss_battle_advance(player,map) == -1)
	{
	  return -1;
	}
      }
      explosions_advance();
      music_buffer_refill();

      --timer_ticks;
    }
    background_display(map,level);
    map_display(map);
    if (!boss_battle_running())
    {
      enemies_display(map);
      player_display(player,map);
    }
    else
    {
    	boss_display(player,map);
    }
    explosions_display(map);
    if (boss_battle_running()<2)
    {
      hud_display(player);
    }
    else
    {
      boss_cinema_display();
    }

    if (player->lives<0)
    {
      textout_centre_ex(buffer,data[VERASERIF].dat,"Game Over",160,(240-text_height(data[VERASERIF].dat))/2,0,-1);
    }
    flip_screen();
    while (timer_ticks<=0)
    {
      // ultra-stable music playback -- even play in the idle loop >;D
      music_buffer_refill();
      rest(1); // sleepy waiting
    }
  }

  return -1;

  //free(map);
  //free(player);
}

Map* get_map( int level )
{
  static Map* current = NULL;

  if (current != NULL)
  {
    free(current);
    current = NULL;
  }

  switch (level)
  {
    case 1:
      music_play("music/breeze.xm",1);
      current = map_load("maps/level1.map");
      break;
    case 2:
      music_play("music/breeze.xm",1);
      current = map_load("maps/level2.map");
      break;
    case 3:
      music_play("music/terror.xm",1);
      current = map_load("maps/level3.map");
      break;
    case 4:
      music_play("music/terror.xm",1);
      current = map_load("maps/level4.map");
      break;
    case 5:
      music_stop();
      current = map_load("maps/level5.map");
      break;
    case 6:
      break;
    default:break;
  }
  if (current == NULL)
  {
    fprintf(stderr,"ERROR! No map for level %d!\n",level);
  }
  return current;
}

void title( void )
{
  int level;
  int ret;
  Player *player;
  Map *map = NULL;

  player = (Player*)malloc(sizeof(Player));

  if (!title1())
  {
    intro();
    while (!title2())
    {
      level = 1;
      map = get_map(level);
      player_init(player,map);
      ret = 0;
      while (ret != -1)
      {
	if (level_screen(level) != -1)
	{
	  map = get_map(level);
	  player_reset(player,map);
	  ret = game(player,map,level);
	  if (ret == 0)
	  {
	    level++;
	  }
	  screen_shake = 0;
	}
	else
	{
	  ret = -1;
	}
      }
    }
  }

  if (map) free(map);
  free(player);
}

int main(int argc, char** argv)
{
  f_log = fopen("log.txt","w");

  fprintf(f_log,"## XmasHack 2006 - Entry by Simon Parzer\n");
#ifdef GP2X
  fprintf(f_log,"# This is the GP2X version!\n");
#else
  fprintf(f_log,"# This is the PC version!\n");
#endif

  fprintf(f_log,"Init RNG...\n");
  srand(time(0));
  fprintf(f_log,"Opening Allegro...\n");
  allegro_init();
  install_timer();
#ifdef GP2X
  install_joystick(JOY_TYPE_AUTODETECT);
#else
  install_keyboard();
#endif
  fprintf(f_log,"Installing Sound...\n");
  if (install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL) != 0)
  {
    fprintf(f_log,"Unable to init sound driver!");
    fclose(f_log);
    return -1;
  }
  fprintf(f_log,"Music (MikMod) init...\n");
  music_init();

  //TODO remove this line
  //set_volume(0,0);


  fprintf(f_log,"Setting up screen...\n");
  set_color_depth(16);
#ifdef GP2X
  if (set_gfx_mode(GFX_AUTODETECT,320,240,0,0) != 0)
#else
  if (set_gfx_mode(GFX_AUTODETECT,640,480,0,0) != 0)
#endif
  {
    fprintf(f_log,"Error while trying to set up screen!");
    fclose(f_log);
    return -1;
  }
  clear(screen);
#ifdef GP2X
  buffer = create_bitmap(SCREEN_W,SCREEN_H);
#else
  buffer = create_bitmap(SCREEN_W/2,SCREEN_H/2);
#endif
  clear_to_color(buffer,0);

  fprintf(f_log,"Loading data...\n");
  data = load_datafile("data.dat");
  if (!data)
  {
    fprintf(f_log,"Unable to load Datafile: data.dat");
    fclose(f_log);
    return -1;
  }

  install_int_ex(timer_callback,BPS_TO_TIMER(FRAME_RATE));

  fprintf(f_log,"Running title screen...\n");
  title();
  //fprintf(f_log,"Running menu...\n");
  //menu();

  fprintf(f_log,"Cleaning up...\n");
  music_quit();
  remove_int(timer_callback);
  destroy_bitmap(buffer);
  unload_datafile(data);

  allegro_exit();
  fclose(f_log);
#ifdef GP2X
  chdir("/usr/gp2x");
  execl("/usr/gp2x/gp2xmenu", "/usr/gp2x/gp2xmenu", NULL);
#endif

  return 0;
}
END_OF_MAIN()

