#include "collapse.h"

int col_init_delay, col_delay;
int col_step = 0;
int col_progress = 0;
int col_position = 0;
int col_running = 0;
Hurdle col_hurdles[5];
const int COL_OVERALL_DELAY = 12;
const int HURDLE_DELAY = 2;
extern int screen_shake;

// 012345601234560123456..
//11111001
//11110011
//11100111
//11001111
//10001111
//11100111
//11110011
const unsigned char hurdle_progression[] = {0xf9,0xf3,0xe7,0xcf,0xe7,0xf3};

void collapse_start( int level, int initial_delay, int delay )
{
  switch (level)
  {
    case 3:
      col_hurdles[0].x_pos=21;
      col_hurdles[0].step=0;
      col_hurdles[1].x_pos=33;
      col_hurdles[1].step=1;
      col_hurdles[2].x_pos=48;
      col_hurdles[2].step=2;
      col_hurdles[3].x_pos=70;
      col_hurdles[3].step=3;
      col_hurdles[4].x_pos=84;
      col_hurdles[4].step=4;
      col_running = 1;
      break;
    case 4:
      col_hurdles[0].x_pos=45;
      col_hurdles[0].step=0;
      col_hurdles[1].x_pos=88;
      col_hurdles[1].step=1;
      col_hurdles[2].x_pos=92;
      col_hurdles[2].step=3;
      col_hurdles[3].x_pos=0;
      col_hurdles[3].step=4;
      col_hurdles[4].x_pos=0;
      col_hurdles[4].step=4;
      col_running = 1;
      break;
    default:
      col_running = 0;
      break;
  }
  col_init_delay = initial_delay;
  col_delay = delay;
  col_position = 0;
  col_progress = 0;
  col_step = 0;
}

void collapse_reset( void )
{
  col_position = 0;
  col_progress = 0;
  col_step = 0;
  screen_shake = 0;
}

void collapse_advance( Player* p, Map* m )
{
  int px;
  int px_off;
  int i;
  int delay;

  if (!col_running) return;

  px = (p->x+m->fine_offset)/TILESIZE + m->offset;
  px_off = (p->x+m->fine_offset)%TILESIZE;

  col_step++;
  if (col_step > COL_OVERALL_DELAY)
  {
    col_step = 0;
    col_progress++;

    if (col_progress == 1)
    {
      screen_shake = 2;
    }
    else if (col_progress == 2)
    {
      screen_shake = -2;
    }
    else if (col_progress == 3)
    {
      screen_shake = 0;
    }
    
    delay = (col_position==0)?col_init_delay:col_delay;
    if (col_progress > delay && col_position < m->length)
    {
      col_progress = 0;
      m->landscape[col_position]=0xff;
      col_position++;

      if (col_position%HURDLE_DELAY == 0)
      {
	for (i=0; i<5; ++i)
	{
	  col_hurdles[i].step++;
	  if (col_hurdles[i].step>5)
	  {
	    col_hurdles[i].step = 0;
	  }
	  if (col_hurdles[i].x_pos > col_position)
	  {
	    col_hurdles[i].collision = hurdle_progression[col_hurdles[i].step];
	    m->landscape[col_hurdles[i].x_pos] = col_hurdles[i].collision;
	    /* Old code -- not working correctly
	    if (px == col_hurdles[i].x_pos)
	    {
	      p->y = map_ground_number(m,col_hurdles[i].x_pos)*TILESIZE;
	    }
	    */
	    if (px+1 == col_hurdles[i].x_pos)
	    {
	      if (px_off > TILESIZE/2)
	      {
		p->x += TILESIZE-px_off;
		p->y = map_ground_number(m,col_hurdles[i].x_pos)*TILESIZE;
	      }
	      else
	      {
		p->x -= px_off;
	      }
	    }
	    else if (px == col_hurdles[i].x_pos)
	    {
	      if (px_off < TILESIZE/2)
	      {
		p->x -= px_off;
		p->y = map_ground_number(m,col_hurdles[i].x_pos)*TILESIZE;
	      }
	      else
	      {
		p->x += TILESIZE-px_off;
	      }
	    }
	  }
	}
      }
    }

  }

  if (col_position > px)
  {
    if (!p->dead)
    {
      p->dead++;
      play_sample(data[SND_DEAD].dat,255,127,1000,0);
    }
  }
}

