#include "boss.h"
#include "../music.h"
#include "../intro.h"

int step;
int progress;

int cinema_width;
int boss_x, boss_y; //Tile coordinates
int conny_x, conny_y;
int boss_frame;
int running;
BITMAP *close1=0, *close2=0;

void boss_reset( void )
{
  if (close1)
  {
    destroy_bitmap(close1);
    close1 = NULL;
  }
  if (close2)
  {
    destroy_bitmap(close2);
    close2 = NULL;
  }
  progress = 0;
  step = 0;
  conny_x = -1;
  conny_y = -1;
  boss_frame = 0;
  running = 0;
}

void boss_try_battle( Player* p, Map* m, int level )
{
  if (!boss_battle_running() && level==5 && (p->x+m->fine_offset)/TILESIZE+m->offset > 30)
  {
    p->direction=1;
    step = 0;
    progress = 0;
    cinema_width = 0;

    close1 = create_bitmap(320,240);
    clear_to_color(close1,makecol16(255,0,255));
    close2 = create_bitmap(320,240);
    clear_to_color(close2,makecol16(255,0,255));

    boss_x = (p->x+m->fine_offset)/TILESIZE + m->offset + 5;
    boss_y = map_ground_number(m,boss_x);

    boss_frame = 0;

    conny_x = -1;
    conny_y = -1;

    running = 1;
    boss_battle_advance(p,m);
    music_play("music/battle.xm",1);
  }
}

void _draw_player( Player* p )
{
  masked_blit(data[SNOWMAN].dat,buffer,p->animation_frame*TILESIZE,0,p->x,p->y+2,TILESIZE,TILESIZE);
}

void _draw_boss( Map* m )
{
  int x,y;
  x = (boss_x-m->offset)*TILESIZE - m->fine_offset;
  y = boss_y*TILESIZE+2;
  masked_blit(data[BOSSDEAD].dat,buffer,boss_frame*TILESIZE,0,x,y,TILESIZE,TILESIZE);
}

int _starting_sequence( Player* p, Map* m, int progress )
{
  int length = 30;
  if (progress<=20)
  {
    m->fine_offset += 5;
    p->x -=5;
    if (m->fine_offset > TILESIZE)
    {
      m->offset++;
      m->fine_offset %= TILESIZE;
    }
    cinema_width = progress;
  }
  return length;
}

int _closeup( int progress )
{
  int rprgr;
  int length = 70;
  if (progress<0) return length;

  if (progress<10)
  {
    clear_to_color(close1,makecol16(255,0,255));
    blit(data[BOSSCLOSEUP1].dat,close1,0,0,progress*32-320,0,320,240);
  }
  else if (progress<30)
  {
    clear_to_color(close1,makecol16(255,0,255));
    blit(data[BOSSCLOSEUP1].dat,close1,0,0,0,0,320,240);
  }
  else if (progress<40)
  {
    rprgr = progress - 30;
    blit(data[BOSSCLOSEUP1].dat,close1,0,0,0,0,320,240);
    clear_to_color(close2,makecol16(255,0,255));
    blit(data[BOSSCLOSEUP2].dat,close2,0,0,320-rprgr*32,0,320,240);
  }
  else if (progress<60)
  {
    blit(data[BOSSCLOSEUP2].dat,close2,0,0,0,0,320,240);
  }
  else if (progress<70)
  {
    if (close1)
    {
      destroy_bitmap(close1);
      close1 = NULL;
    }
    clear_to_color(close2,makecol16(255,0,255));
    blit(data[BOSSCLOSEUP2].dat,close2,0,0,-progress*32,0,320,240);
  }
  else
  {
    if (close2)
    {
      destroy_bitmap(close2);
      close2 = NULL;
    }
  }
  return length;
}

int _lean_back( Player* p, int progress )
{
  int length = 8;
  if (progress<0) return length;
  if (progress<2)
  {
    p->animation_frame = 2;
  }
  else if (progress<4)
  {
    p->animation_frame = 5;
    p->x-=1;
  }
  else if (progress<6)
  {
    p->animation_frame = 2;
    p->x+=1;
  }
  else if (progress<7)
  {
    p->animation_frame = 0;
  }
  else if (progress<8)
  {
    p->animation_frame = 6;
  }
  return length;
}

int _throw( Player* p, Map* m, int progress )
{
  int start_x,start_y,distance;
  int length = 5;
  if (progress<0) return length;
  if (progress<5)
  {
    if (progress<1)
    {
      p->animation_frame = 7;
    }
    start_x = p->x-m->fine_offset+47;
    start_y = p->y+8;
    distance = (boss_x-m->offset)*TILESIZE - p->x - TILESIZE;
    conny_x = start_x+(distance*progress)/7;
    conny_y = start_y;
  }
  return length;
}

int _die( Map* m, int progress )
{
  int length = 8;
  if (progress<0) return length;
  if (progress<8)
  {
    if (progress<1)
    {
      conny_x = -1;
      conny_y = -1;
    }
    boss_frame = progress;
  }
  return length;
}

int _battle_end( int progress )
{
  if (progress<0) return 0;
  if (progress>50)
  {
    outro();
    return -1;
  }
  return 0;
}

int boss_battle_advance( Player* p, Map* m )
{
  int prg_offset;
  step++;
  if (step>5)
  {
    if (p->jumpstate != 1 || (p->animation_frame != 0 && running!=2))
    {
      player_advance(p,m);
      player_advance(p,m);
      step = 0;
    }
    else
    {
      running = 2;
      step = 0;
      progress++;

      prg_offset = _starting_sequence(p,m,progress);
      prg_offset += _closeup(progress-prg_offset);
      prg_offset += _lean_back(p,progress-prg_offset);
      prg_offset += _throw(p,m,progress-prg_offset);
      prg_offset += _die(m,progress-prg_offset);
      if (_battle_end(progress-prg_offset) == -1)
      {
	return -1;
      }
    }
  }
  return 0;
}

int boss_battle_running( void )
{
  return running;
}

void boss_display( Player* p, Map* m)
{
  _draw_player(p);
  _draw_boss(m);
  if (close1)
  {
    masked_blit(close1,buffer,0,0,0,0,320,240);
  }
  if (close2)
  {
    masked_blit(close2,buffer,0,0,0,0,320,240);
  }
  if (conny_x >=0 && conny_y >=0)
  {
    draw_sprite(buffer,data[CONNY].dat,conny_x,conny_y);
  }
}

void boss_cinema_display( void )
{
  rectfill(buffer,0,0,320,cinema_width,makecol16(0,0,0));
  rectfill(buffer,0,240-cinema_width,320,240,makecol16(0,0,0));
}

