#include "controls.h"
#include "intro.h"
#include "music.h"
#include "data.h"
#include <string.h>

int title1( void )
{
  music_play("music/dolocron.xm",1);
  fprintf(f_log,"Displaying first title screen...\n");
  clear_buttons();
  while (/*!button_Exit() && !button_B()*/ !keypressed2())
  {
#ifdef GP2X
    poll_joystick();
#endif
    blit(data[TITLE_1].dat,buffer,0,0,0,0,SCREEN_W,SCREEN_H);
    music_buffer_refill();
    flip_screen();
    rest(1);
  } 
  if (button_Exit())
  {
    return -1;
  }
  else
  {
    return 0;
  }
}

// this function is not very accurate...
void _busy_wait(int delay)
{
  int d = 0;
  while (d<delay)
  {
    rest(10);
    d+=10;
    music_buffer_refill();
  }
}

int _intro_do_line(const char* line1, const char* line2)
{
  int i;
  int x1,y1 = 190;
  int x2,y2 = 210;
  char *l1, *l2;
  char temp;

  x1 = (320-text_length(data[VERASERIF].dat,line1))/2;
  x2 = (320-text_length(data[VERASERIF].dat,line2))/2;

  l1 = strdup(line1);
  for (i=1; i<strlen(line1); ++i)
  {
#ifdef GP2X
    poll_joystick();
#endif
    if (button_Exit()) return -1;
    if (i+1 < strlen(line1))
    {
      temp = l1[i+1];
      l1[i+1] = 0;
    }
    textout_ex(buffer,data[VERASERIF].dat,l1,x1,y1,makecol16(255,255,255),-1);
    if (i+1 < strlen(line1))
    {
      l1[i+1] = temp;
    }
    flip_screen();
    _busy_wait(50);
  }
  free(l1);
  _busy_wait(100);
  l2 = strdup(line2);
  for (i=0; i<strlen(line2); ++i)
  {
#ifdef GP2X
    poll_joystick();
#endif
    if (button_Exit()) return -1;
    if (i+1 < strlen(line2))
    {
      temp = l2[i+1];
      l2[i+1] = 0;
    }
    textout_ex(buffer,data[VERASERIF].dat,l2,x2,y2,makecol16(255,255,255),-1);
    if (i+1 < strlen(line2))
    {
      l2[i+1] = temp;
    }
    flip_screen();
    _busy_wait(50);
  }
  free(l2);
#ifndef GP2X
  clear_keybuf();
#endif
  while (!keypressed2())
  {
    music_buffer_refill();
    rest(10);
  }
  return 0;
}

int _do_the_end( void )
{
  int x, y,
      i;
  char line[] = "The End?";
  char temp;
  x = (320-text_length(data[VERASERIF].dat,line))/2;
  y = 200;
  for (i = 0; i<strlen(line)-1; ++i)
  {
#ifdef GP2X
    poll_joystick();
#endif
    if (button_Exit()) return -1;
    temp = line[i+1];
    line[i+1] = 0;
    textout_ex(buffer,data[VERASERIF].dat,line,x,y,makecol16(255,255,100),-1);
    line[i+1] = temp;
    flip_screen();
    _busy_wait(50);
  }
  _busy_wait(500);
  textout_ex(buffer,data[VERASERIF].dat,line,x,y,makecol16(255,255,100),-1);
  flip_screen();
  _busy_wait(1000);
  line[strlen(line)-1] = 0x20;
  rectfill(buffer,x,y,320,240,makecol16(0,0,0));
  textout_ex(buffer,data[VERASERIF].dat,line,x,y,makecol16(255,255,100),-1);
  flip_screen();
  _busy_wait(500);
  line[strlen(line)-1] = '!';
  textout_ex(buffer,data[VERASERIF].dat,line,x,y,makecol16(255,200,100),-1);
  flip_screen();
  _busy_wait(2000);
  return 0;
}

#define D_LINE(x,y) music_buffer_refill();if(_intro_do_line(x,y)) return -1;

int intro( void )
{
  music_play("music/intro.xm",1);
  blit(data[INTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Hello! My name is Conny Carrot.","I'm a vegetable.");
  blit(data[INTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Normally I live in","a small cave under the earth.");
  blit(data[INTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Life there is great,","drinking water, growing up,");
  blit(data[INTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("and showing your hair","to the outside world.");
  blit(data[INTRO2].dat,buffer,0,0,0,0,320,240);
  D_LINE("But yesterday","something awful happened.");
  blit(data[INTRO2].dat,buffer,0,0,0,0,320,240);
  D_LINE("Some kid dug me up,","and stuck me into...");
  blit(data[INTRO3].dat,buffer,0,0,0,0,320,240);
  D_LINE("... a snowman's face!","");
  blit(data[INTRO3].dat,buffer,0,0,0,0,320,240);
  D_LINE("Bad time for me...","..but I have a plan!");
  blit(data[INTRO3].dat,buffer,0,0,0,0,320,240);
  D_LINE("All carrots possess","telepathic powers.");
  blit(data[INTRO3].dat,buffer,0,0,0,0,320,240);
  D_LINE("I think I can use them to","control this snowman!");
  blit(data[INTRO3].dat,buffer,0,0,0,0,320,240);
  D_LINE("Now it's time for revenge!","This stupid kid is going to pay!");

  return 0;
}

int outro( void )
{
  music_stop();
  clear(buffer);
  flip_screen();
  _busy_wait(1000);
  music_play("music/intro.xm",1);
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Hey, you!","Thanks for playing.");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("My quest for revenge","is finally over!");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Now that I'm free","I want to give you...");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("... a nice advice!","");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Never use a carrot","when building a snowman.");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Or you will die","a horrible death!");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Thank you again","for playing this game.");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Design, Code, GFX and Music","Simon Parzer");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  D_LINE("Contact","simon.parzer@gmail.com");
  blit(data[OUTRO].dat,buffer,0,0,0,0,320,240);
  _do_the_end();

  return 0;
}
#undef D_LINE
int title2( void )
{
  music_play("music/monster.it",1);
  fprintf(f_log,"Displaying second title screen...\n");
  clear_buttons();
  while (!button_Exit() && !button_B())
  {
#ifdef GP2X
    poll_joystick();
#endif
    blit(data[TITLE_2].dat,buffer,0,0,0,0,SCREEN_W,SCREEN_H);
    music_buffer_refill();
    flip_screen();
    rest(1);
  }
  if (button_Exit())
  {
    return -1;
  }
  else
  {
    return 0;
  }
  return 0;
}

