#include "Sprite.h"

unsigned int Sprite::get_spriteNumber()
{
	return spriteNumber;
}
unsigned short Sprite::get_numOfParts()
{
	return numOfParts;
}
unsigned short Sprite::get_h()
{
	return h;
}
unsigned short Sprite::get_w()
{
	return w;
}
unsigned short Sprite::get_X()
{
	return x;
}
unsigned short Sprite::get_Y()
{
	return y;
}
unsigned short Sprite::get_gender()
{
	return gender;
}

	
SpritePart* Sprite::get_spriteParts(int i)
{
	return &spriteParts[i];
}
unsigned int * Sprite::get_spritePartIds()
{
	return spritePartIds;
}
 int * Sprite::get_spriteXOffsets()
{
	return spriteXOffsets;
}
int * Sprite::get_spriteYOffsets()
{
	return spriteYOffsets;
}

void  Sprite::set_spriteXOffsets( int i , int d)
{
	 spriteXOffsets[i]=d;
}
void  Sprite::set_spriteYOffsets( int i , int d)
{
	 spriteYOffsets[i]=d;
}
void  Sprite::set_spritePartIds( int i ,unsigned int d)
{
	 spritePartIds[i]=d;
}
void Sprite::set_spriteNumber(unsigned int nnum)
{
	spriteNumber = nnum;
}
void Sprite::set_numOfParts(unsigned short nnump)
{
	numOfParts = nnump;
}

void Sprite::set_h(unsigned short nh)
{
	h = nh;
}
void Sprite::set_w(unsigned short nw)
{
	w = nw; 
}
void Sprite::set_X(unsigned short nx)
{
	x = nx;
}
void Sprite::set_Y(unsigned short ny)
{
	y = ny;
}
void Sprite::set_gender(unsigned short ngender)
{
	gender = ngender;
}
void Sprite::loadSpriteParts(SpritePartconfigList *plist)
{
	for(int i = 0; i< numOfParts; i++)
	{
		
			spriteParts[i] = plist->Find_Part_id(spritePartIds[i]);
			spriteParts[i].set_offSet_X(get_spriteXOffsets()[i]);
			spriteParts[i].set_offSet_Y(get_spriteYOffsets()[i]);
			if(i > 0)
			{
				spriteParts[i].set_parent(&spriteParts[i-1]);
			}
	
	}


}

void Sprite::draw( BITMAP* bmp,DATAFILE *dat )
{

for(int i = 0; i< numOfParts; i++)
	{
		
		textout(bmp,font,"drawing sprites",100,400,makecol(255,255,255));	
		masked_stretch_blit((BITMAP*)dat[spriteParts[i].get_charSetNumber()].dat,bmp, spriteParts[i].get_source_X()*spriteParts[i].get_w(),spriteParts[i].get_source_Y()*spriteParts[i].get_h(), spriteParts[i].get_w(),spriteParts[i].get_h(),spriteParts[i].get_dest_X(),spriteParts[i].get_dest_Y(), spriteParts[i].get_w()*2,spriteParts[i].get_h()*2);
	}
}

int Sprite::switchPart(unsigned int pId ,unsigned int newPid)
{
	for(int i = 0; i< numOfParts; i++)
	{
	if (spritePartIds[i]==pId)
		spritePartIds[i] = newPid;
	return pId;
	}
	return-1;
}

Sprite::Sprite()
{
	spriteNumber = 1;
	gender = 0;
	x = 100;
	y = 100;
	w = 32;
	h = 32;
	numOfParts = 1;
}