/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------\
|                                     intro.cpp                                |
|       Ce module contient les fonctions de l'introduction de TA3D             |
|                                                                              |
\-----------------------------------------------------------------------------*/

#ifdef CWDEBUG
#include <libcwd/sys.h>
#include <libcwd/debug.h>
#endif
#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "intro.h"

void play_intro()
{
	FONT *allegro_font=load_font("gfx/title_font.tga",NULL,NULL);

	FONT *fnt=allegro_gl_convert_allegro_font_ex(allegro_font,AGL_FONT_TYPE_TEXTURED,-1.0f,GL_RGBA8);

	set_color_depth(32);
	allegro_gl_use_alpha_channel(false);
	BITMAP *bmp=load_bitmap("gfx/intro.tga",NULL);
	GLuint glfond=allegro_gl_make_texture(bmp);
	glBindTexture(GL_TEXTURE_2D, glfond);
	allegro_gl_set_texture_format(GL_RGB8);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
	destroy_bitmap(bmp);

	bool done=false;

	allegro_gl_set_allegro_mode();
	glScalef(SCREEN_W/640.0f,SCREEN_H/480.0f,1.0f);

	FILE *gpl=fopen("intro.txt","rb");

	char *text_line[10];
	int i;
	for(i=0;i<10;i++) {
		text_line[i]=new char[100];
		text_line[i][0]=0;
		}

	float dec=0.0f;
	float dt=0.0f;
	int time=Atimer;
	float Conv=1.0f/SECS_TO_TIMER(1);
	bool read=true;

	float h=text_height(allegro_font);

	do
	{
		do
		{
			dt=(Atimer-time)*Conv;
			rest(1);
		}while(dt<0.02f);
		time=Atimer;

		dec-=dt*h;
		if(dec<=-h) {		// Décale tout et lit une autre ligne
			dec=0.0f;
			for(i=0;i<9;i++) {
				text_line[i][0]=0;
				strcat(text_line[i],text_line[i+1]);
				}
			text_line[9][0]=0;
			if(read) {
				if(fgets(text_line[9],100,gpl)==NULL)
					read=false;
				if(read)
					for(i=0;i<strlen(text_line[9]);i++) {
						if(text_line[9][i]==10 || text_line[9][i]==13)
							text_line[9][i]=0;
						if(text_line[9][i]==9) {
							for(int e=strlen(text_line[9])+4;e>i+4;e--)
								text_line[9][e]=text_line[9][e-4];
							text_line[9][i]=32;
							text_line[9][i+1]=32;
							text_line[9][i+2]=32;
							text_line[9][i+3]=32;
							}
						}
				}
			else {
				bool vide=true;
				for(i=0;i<10;i++)
					if(text_line[i][0]!=0) {
						vide=false;
						break;
						}
				done|=vide;
				}
			}

		if(mouse_b || keypressed())	done=true;

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Efface l'écran

		PutTex(glfond,0.0f,0.0f,640.0f,480.0);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		allegro_gl_printf(fnt,236.0f,80.0f,0.0f,0xFFFFFF,"Total Annihilation 3D");

		for(i=0;i<10;i++)
			allegro_gl_printf(fnt,32.0f,80.0f+(i+2)*h+dec,0.0f,0xFFFFFF,text_line[i]);

		glBlendFunc(GL_ONE_MINUS_SRC_ALPHA,GL_SRC_ALPHA);
		glBindTexture(GL_TEXTURE_2D,glfond);
		glBegin(GL_QUADS);
			glColor4f(1.0f,1.0f,1.0f,0.0f);
			glTexCoord2f(0.0f,(80.0f+h)/480.0f);		glVertex2f(0.0f,80.0f+h);
			glTexCoord2f(1.0f,(80.0f+h)/480.0f);		glVertex2f(640.0f,80.0f+h);
			glTexCoord2f(1.0f,(80.0f+2*h)/480.0f);		glVertex2f(640.0f,80.0f+2*h);
			glTexCoord2f(0.0f,(80.0f+2*h)/480.0f);		glVertex2f(0.0f,80.0f+2*h);

			glTexCoord2f(0.0f,(80.0f+2*h)/480.0f);		glVertex2f(0.0f,80.0f+2*h);
			glTexCoord2f(1.0f,(80.0f+2*h)/480.0f);		glVertex2f(640.0f,80.0f+2*h);
			glColor4f(1.0f,1.0f,1.0f,1.0f);
			glTexCoord2f(1.0f,(80.0f+4*h)/480.0f);		glVertex2f(640.0f,80.0f+4*h);
			glTexCoord2f(0.0f,(80.0f+4*h)/480.0f);		glVertex2f(0.0f,80.0f+4*h);

			glTexCoord2f(0.0f,(80.0f+9*h)/480.0f);		glVertex2f(0.0f,80.0f+9*h);
			glTexCoord2f(1.0f,(80.0f+9*h)/480.0f);		glVertex2f(640.0f,80.0f+9*h);
			glColor4f(1.0f,1.0f,1.0f,0.0f);
			glTexCoord2f(1.0f,(80.0f+11*h)/480.0f);		glVertex2f(640.0f,80.0f+11*h);
			glTexCoord2f(0.0f,(80.0f+11*h)/480.0f);		glVertex2f(0.0f,80.0f+11*h);

			glTexCoord2f(0.0f,(80.0f+11*h)/480.0f);		glVertex2f(0.0f,80.0f+11*h);
			glTexCoord2f(1.0f,(80.0f+11*h)/480.0f);		glVertex2f(640.0f,80.0f+11*h);
			glTexCoord2f(1.0f,(80.0f+12*h)/480.0f);		glVertex2f(640.0f,80.0f+12*h);
			glTexCoord2f(0.0f,(80.0f+12*h)/480.0f);		glVertex2f(0.0f,80.0f+12*h);
		glEnd();
		glDisable(GL_BLEND);

		allegro_gl_flip();
	}while(!done);

	for(i=0;i<10;i++)
		if(text_line[i])
			delete[] text_line[i];

	fclose(gpl);

	allegro_gl_unset_allegro_mode();

	glDeleteTextures(1,&glfond);

	allegro_gl_destroy_font(fnt);

	destroy_font(allegro_font);
}

GLuint Glfond;
FONT *Allegro_font=NULL;
FONT *Fnt=NULL;

void loading(float percent,char *msg)
{
	bool init=(Fnt==NULL);
	if(init) {
		Allegro_font=load_font("gfx/title_font.tga",NULL,NULL);

		Fnt=allegro_gl_convert_allegro_font_ex(Allegro_font,AGL_FONT_TYPE_TEXTURED,-1.0f,GL_RGBA8);

		set_color_depth(32);
		allegro_gl_use_alpha_channel(false);
		BITMAP *bmp=load_bitmap("gfx/intro.tga",NULL);
		Glfond=allegro_gl_make_texture(bmp);
		glBindTexture(GL_TEXTURE_2D, Glfond);
		allegro_gl_set_texture_format(GL_RGB8);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
		destroy_bitmap(bmp);
		}

	allegro_gl_set_allegro_mode();
	glScalef(SCREEN_W/640.0f,SCREEN_H/480.0f,1.0f);

	float h=text_height(Allegro_font);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Efface l'écran

	PutTex(Glfond,0.0f,0.0f,640.0f,480.0);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	allegro_gl_printf(Fnt,236.0f,80.0f,0.0f,0xFFFFFF,"Total Annihilation 3D");

	glDisable(GL_BLEND);

	glDisable(GL_TEXTURE_2D);
	glColor3f(0.5f,0.0f,0.0f);
	glBegin(GL_QUADS);
		glVertex2f(20.0f,220.0f);
		glVertex2f(20.0f+6.0f*percent,220.0f);
		glColor3f(1.0f,0.0f,0.0f);
		glVertex2f(20.0f+6.0f*percent,240.0f);
		glVertex2f(20.0f,240.0f);

		glVertex2f(20.0f,240.0f);
		glVertex2f(20.0f+6.0f*percent,240.0f);
		glColor3f(0.5f,0.0f,0.0f);
		glVertex2f(20.0f+6.0f*percent,260.0f);
		glVertex2f(20.0f,260.0f);
	glEnd();
	glColor3f(1.0f,1.0f,1.0f);
	glBegin(GL_LINE_LOOP);
		glVertex2f(20.0f,220.0f);
		glVertex2f(620.0f,220.0f);
		glVertex2f(620.0f,260.0f);
		glVertex2f(20.0f,260.0f);
	glEnd();
	glEnable(GL_TEXTURE_2D);

	glEnable(GL_BLEND);
	allegro_gl_printf(Fnt,320.0f-0.5f*text_length(Allegro_font,msg),240-h*0.5f,0.0f,0xFFFFFF,msg);
	glDisable(GL_BLEND);

	allegro_gl_flip();

	allegro_gl_unset_allegro_mode();

	if(percent>=100.0f) {
		glDeleteTextures(1,&Glfond);

		allegro_gl_destroy_font(Fnt);

		destroy_font(Allegro_font);

		Allegro_font=NULL;
		Fnt=NULL;
		}
}
