/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*--------------------------------------------------------------\
|                          glfunc.h                             |
|      contient les fonctions et les variables permettant d'    |
|  utiliser des extensions d'OpenGl. utilise AllegroGl          |
\--------------------------------------------------------------*/

#ifdef CWDEBUG
#include <libcwd/sys.h>
#include <libcwd/debug.h>
#endif
#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include <stdio.h>
#include <string.h>
#include "glfunc.h"
#include "console.h"

bool	MultiTexturing;
bool	g_useTextureCompression = false;
bool	g_useStencilTwoSide = false;
bool	g_useCopyDepthToColor = false;
bool	g_useProgram = false;
bool	g_useFBO = false;

void install_ext()
{
	MultiTexturing=false;
			// Extension pour le multitexturing
	if(glActiveTextureARB!=NULL && glMultiTexCoord2fARB!=NULL && glClientActiveTextureARB!=NULL) MultiTexturing=true;

	g_useTextureCompression = allegro_gl_is_extension_supported("GL_ARB_texture_compression");
	g_useStencilTwoSide = allegro_gl_is_extension_supported("GL_EXT_stencil_two_side");
	g_useCopyDepthToColor = allegro_gl_is_extension_supported("GL_NV_copy_depth_to_color");
	g_useProgram = allegro_gl_is_extension_supported("GL_ARB_shader_objects") && allegro_gl_is_extension_supported("GL_ARB_shading_language_100") && allegro_gl_is_extension_supported("GL_ARB_vertex_shader") && allegro_gl_is_extension_supported("GL_ARB_fragment_shader");
	g_useFBO = allegro_gl_is_extension_supported("GL_EXT_framebuffer_object");
}

GLhandleARB load_fragment_shader(char *filename)
{
	FILE *file=fopen(filename,"rt");
	GLhandleARB	shader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);
	if(file==NULL)	{
		Console->AddEntry("fichier inexistant");
		return shader;
		}
	int filesize=file_size(filename);

	char *buf=(char*) malloc(filesize+1);
	fread(buf,filesize,1,file);
	buf[filesize]=0;
	fclose(file);

	GLint length = (GLint) strlen(buf);
	int compiled = 0;

	glShaderSourceARB(shader, 1, (const GLcharARB **)&buf, &filesize);
	glCompileShaderARB(shader); 
	glGetObjectParameterivARB(shader, GL_OBJECT_COMPILE_STATUS_ARB, &compiled);

	if (compiled) 
	{ // compilation successful!
		Console->AddEntry("%s correctement chargé",filename);
	}
	else 
	{ // compilation error! Check compiler log! 
		Console->AddEntry("%s : la compilation a échoué",filename);
		char log[10000];
		GLsizei len=0;
		glGetInfoLogARB(shader, 10000, &len, log);
		Console->AddEntry("%s",log);
	}

	free(buf);
	return shader;
}

GLhandleARB load_vertex_shader(char *filename)
{
	FILE *file=fopen(filename,"rt");
	GLhandleARB	shader = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);
	if(file==NULL)	{
		Console->AddEntry("fichier inexistant");
		return shader;
		}
	int filesize=file_size(filename);

	char *buf=(char*) malloc(filesize+1);
	fread(buf,filesize,1,file);
	buf[filesize]=0;
	fclose(file);

	GLint length = (GLint) strlen(buf);
	int compiled = 0;

	glShaderSourceARB(shader, 1, (const GLcharARB **)&buf, &filesize);
	glCompileShaderARB(shader);
	glGetObjectParameterivARB(shader, GL_OBJECT_COMPILE_STATUS_ARB, &compiled);

	if (compiled) 
	{ // compilation successful!
		Console->AddEntry("%s correctement chargé",filename);
	}
	else 
	{ // compilation error! Check compiler log! 
		Console->AddEntry("%s : la compilation a échoué",filename);
		char log[10000];
		GLsizei len=0;
		glGetInfoLogARB(shader, 10000, &len, log);
		Console->AddEntry("%s",log);
	}

	free(buf);
	return shader;
}

void SHADER::load(char *fragment_file,char *vertex_file)
{
	if(!g_useProgram)	return;

	program=glCreateProgramObjectARB();
	vertex=load_vertex_shader(vertex_file);
	fragment=load_fragment_shader(fragment_file);
	glAttachObjectARB(program,vertex);
	glAttachObjectARB(program,fragment);
	glLinkProgramARB(program);
	GLint link=0;
	glGetObjectParameterivARB(program, GL_OBJECT_LINK_STATUS_ARB, &link);
	if(link) {
		Console->AddEntry("succès");
		succes=true;
		}
	else {
		Console->AddEntry("échec");
		char log[10000];
		GLsizei len=0;
		glGetInfoLogARB(program, 10000, &len, log);
		Console->AddEntry("%s",log);
		succes=false;
		}
}
