/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*----------------------------------------------------------------------\
|                               console.h                               |
|      contient les classes ncessaires  la gestion d'une console dans |
| programme utilisant Allegro avec ou sans AllegroGL. La console        |
| dispose de sa propre procdure d'entre et d'affichage mais celle-ci  |
| ncessite d'tre appelle manuellement pour viter les problmes      |
| dcoulant d'un appel automatique par un timer.                        |
\----------------------------------------------------------------------*/

#ifndef __CLASSE_CONSOLE
#define __CLASSE_CONSOLE

#include <stdio.h>				// Pour l'affichage dans une console(Linux,DOS)
#include <string.h>				// Pour la gestion des chaînes et de la mmoire

#ifdef ALLEGRO_VERSION			// Vrifie que la librairie Allegro est disponible

#ifndef CONSOLE_NB_ENTRES
#define CONSOLE_NB_ENTRES	15		// Par défaut 15 entrées dans la console	
#endif

class CONSOLE			// Classe pour la console
{
private:
	char		*text[CONSOLE_NB_ENTRES];			// contenu de la console
	bool		recording;							// Indique si la console doit être enregistrée sur le disque
	FILE		*log;								// Fichier log de la console
	float		visible;
	char		*tmptxt;
	char		*filename;							// Name of the file where we record
public:
	bool		show;

public:

	CONSOLE()			// Initialise la console
	{
		for(int i=0;i<CONSOLE_NB_ENTRES;i++)
			text[i]=NULL;
		recording=false;		// N'enregistre rien
		show=false;
		visible=0.0f;
		tmptxt=new char[200];
		tmptxt[0]=0;
		filename=NULL;
	}

	void StopRecording()		// Arrte l'enregistrement de la console
	{
		if(filename)	free(filename);
		filename=NULL;
		recording=false;
	}

	void StartRecording(char *file)		// Lance l'enregistrement de la console
	{
		StopRecording();
		recording=true;
		log=fopen(file,"wb");		// Create the file
		if(log)
			fclose(log);
		filename=strdup(file);
	}

	void destroy()		// Dtruit l'objet console
	{
		StopRecording();
		for(int i=0;i<CONSOLE_NB_ENTRES;i++)
			if(text[i]) {
				delete text[i];
				text[i]=NULL;
				}
		if(filename)	free(filename);
		filename=NULL;
		if(tmptxt) delete tmptxt;
		tmptxt=NULL;
	}

	~CONSOLE()		// Destructeur
	{
		destroy();
	}

	void AddEntry(char *txt, ...);		// Ajoute une nouvelle entre

#ifdef AGL_VERSION
	char *draw(FONT *fnt,float dt,int fsize=8)
	{
		set_uformat(U_UTF8);
		char keyb=0;
		if(keypressed())
			keyb=readkey();
		fsize++;
		if(show)	visible+=dt;
		else	visible-=dt;

		if(visible<0.0f) visible=0.0f;
		if(visible>1.0f) visible=1.0f;

		if(!show && visible==0.0f) return false;
		float maxh=fsize*(CONSOLE_NB_ENTRES+1)*visible+5.0f;

		char *newline=NULL;

		glEnable(GL_BLEND);		// Dessine le cadre de la console
		glDisable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.1f,0.1f,0.9f,0.5f);
		glBegin(GL_QUADS);
			glVertex2f(0.0f,0.0f);
			glVertex2f(SCREEN_W,0.0f);
			glVertex2f(SCREEN_W,maxh);
			glVertex2f(0.0f,maxh);
		glEnd();
		glColor4f(0.1f,0.1f,0.9f,0.75f);
		glBegin(GL_LINES);
			glVertex2f(SCREEN_W,maxh);
			glVertex2f(0.0f,maxh);
		glEnd();
		glColor4f(1.0f,1.0f,1.0f,1.0f);
		glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);
		glEnable(GL_TEXTURE_2D);
		for(int i=0;i<CONSOLE_NB_ENTRES;i++)
			if(text[i])
				allegro_gl_printf(fnt,0.0f,maxh-fsize*(CONSOLE_NB_ENTRES+1-i)-5.0f,0.0f,0x7F7F7F,">%s",text[i]);
		allegro_gl_printf(fnt,0.0f,maxh-fsize-5.0f,0.0f,0xFFFFFF,">%s_",tmptxt);
		if(keyb==13) {
			AddEntry(tmptxt);
			tmptxt[0]=0;
			newline=text[CONSOLE_NB_ENTRES-1];
			}
		if(keyb==8 && strlen(tmptxt)>0)
			tmptxt[strlen(tmptxt)-1]=0;
		if((keyb>='0' && keyb<='9') || (keyb>='a' && keyb<='z') || (keyb>='A' && keyb<='Z') || keyb==32 || keyb=='_' || keyb=='+'
			|| keyb=='-' || keyb=='.') {
			if(strlen(tmptxt)<199) {
				tmptxt[strlen(tmptxt)+1]=0;
				tmptxt[strlen(tmptxt)]=keyb;
				}
			}
		glDisable(GL_BLEND);

		set_uformat(U_ASCII);

		return newline;
	}
#else
	char *draw(FONT *fnt,float dt,int fsize=8)
	{
		return NULL;
	}
#endif
};

		// Fonctions relatives à la console

		// Affiche les données système dans une console
void print_system_data(CONSOLE *console);

extern CONSOLE *Console;		// Console par dfaut

#else				// Si la librairie Allegro n'est pas disponible

#error "La librairie Allegro est ncessaire pour utiliser console.h"

#endif
#endif
