/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                      weapons.cpp                                   |
|   Ce module contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers tdf du jeu totalannihilation concernant les armes utilisées par les   |
| unités du jeu.                                                                     |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#ifdef CWDEBUG
#include <libcwd/sys.h>
#include <libcwd/debug.h>
#endif
#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "EngineClass.h"
#include "3do.h"
#include "weapons.h"
#include "tdf.h"

WEAPON_MANAGER		weapon_manager;
INGAME_WEAPONS		weapons;
FX_MANAGER			fx_manager;

void WEAPON_MANAGER::load_tdf(char *data,int size)
{
	set_uformat(U_ASCII);
	char *pos=data;
	char *ligne=NULL;
	int nb=0;
	int index=0;
	int	first=nb_weapons;
	char *limit=data+size;
	char *f;
	int n_pos=0;
	do {
		do
		{
			nb++;
			if(ligne)
				delete[] ligne;
			ligne=get_line(pos);
			strlwr(ligne);
			while(pos[0]!=0 && pos[0]!=13 && pos[0]!=10)	{	pos++;	n_pos++;	}
			while(pos[0]==13 || pos[0]==10)	{	pos++;	n_pos++;	}

			if(strstr(ligne,"//") || strstr(ligne,"/*") || strstr(ligne,"{")) { }		// Saute les commentaires
			else if(ligne[0]=='[') {
				if(strstr(ligne,"]"))
					*(strstr(ligne,"]"))=0;
				index=add_weapon(ligne+1);
				}
			else if(f=strstr(ligne,"[damage]")) {		// Si on a trouvé un paragraphe référant aux dégats
				do {				// Parcour le paragraphe
					nb++;
					if(ligne)
						delete[] ligne;
					ligne=get_line(pos);
					strlwr(ligne);
					while(pos[0]!=0 && pos[0]!=13 && pos[0]!=10)	pos++;
					while(pos[0]==13 || pos[0]==10)	pos++;

					if(f=strstr(ligne,"default=")) {
						if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
						weapon[index].damage=atoi(f+8);
						}
				} while(strstr(ligne,"}")==NULL && nb<1000 && pos<limit);
				}
			else if(f=strstr(ligne,"name=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].name=strdup(f+5);
				}
			else if(f=strstr(ligne,"id=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].weapon_id=atoi(f+3);
				}
			else if(f=strstr(ligne,"rendertype=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].rendertype=atoi(f+11);
				}
			else if(f=strstr(ligne,"ballistic=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].ballistic=(f[10]=='1');
				}
			else if(f=strstr(ligne,"turret=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].turret=(f[7]=='1');
				}
			else if(f=strstr(ligne,"noautorange=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].noautorange=(f[12]=='1');
				}
			else if(f=strstr(ligne,"range=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].range=atoi(f+6);
				}
			else if(f=strstr(ligne,"reloadtime=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].reloadtime=atof(f+11);
				if(weapon[index].duration==-1.0f)
					weapon[index].duration=weapon[index].reloadtime;
				}
			else if(f=strstr(ligne,"weaponvelocity=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].weaponvelocity=atoi(f+15)*0.5f;
				}
			else if(f=strstr(ligne,"burst=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].burst=atoi(f+6);
				}
			else if(f=strstr(ligne,"areaofeffect=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].areaofeffect=atoi(f+13);
				}
			else if(f=strstr(ligne,"startsmoke=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].startsmoke=(f[11]=='1');
				}
			else if(f=strstr(ligne,"endsmoke=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].endsmoke=(f[9]=='1');
				}
			else if(f=strstr(ligne,"firestarter=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].firestarter=(f[12]=='1');
				}
			else if(f=strstr(ligne,"accuracy=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].accuracy=atoi(f+9);
				}
			else if(f=strstr(ligne,"aimrate=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].aimrate=atoi(f+8);
				}
			else if(f=strstr(ligne,"tolerance=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].tolerance=atoi(f+9);
				}
			else if(f=strstr(ligne,"holdtime=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].holdtime=atoi(f+8);
				}
			else if(f=strstr(ligne,"energypershot=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].energypershot=atoi(f+14);
				}
			else if(f=strstr(ligne,"metalpershot=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].metalpershot=atoi(f+13);
				}
			else if(f=strstr(ligne,"minbarrelangle=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].minbarrelangle=atoi(f+15);
				}
			else if(f=strstr(ligne,"unitsonly=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].unitsonly=(f[10]=='1');
				}
			else if(f=strstr(ligne,"edgeeffectiveness=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].edgeeffectiveness=atof(f+18);
				}
			else if(f=strstr(ligne,"lineofsight=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].lineofsight=(f[12]=='1');
				}
			else if(f=strstr(ligne,"soundtrigger=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].soundtrigger=strdup(f+13);
				}
			else if(f=strstr(ligne,"color=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				int c=atoi(f+6);
				weapon[index].color[0]=makecol(pal[c].r<<2,pal[c].g<<2,pal[c].b<<2);
				}
			else if(f=strstr(ligne,"color2=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				int c=atoi(f+7);
				weapon[index].color[1]=makecol(pal[c].r<<2,pal[c].g<<2,pal[c].b<<2);
				}
			else if(f=strstr(ligne,"burstrate=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].edgeeffectiveness=atof(f+10);
				}
			else if(f=strstr(ligne,"duration=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].duration=atof(f+9);
				}
			else if(f=strstr(ligne,"beamweapon=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].beamweapon=(f[11]=='1');
				}
			else if(f=strstr(ligne,"startvelocity=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].startvelocity=atoi(f+14)*0.5f;
				}
			else if(f=strstr(ligne,"weapontimer=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].weapontimer=atof(f+12);
				}
			else if(f=strstr(ligne,"weaponacceleration=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].weaponacceleration=atoi(f+19)*0.5f;
				}
			else if(f=strstr(ligne,"turnrate=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].turnrate=atoi(f+9);
				}
			else if(f=strstr(ligne,"model=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].model=model_manager.get_model(f+6);
				}
			else if(f=strstr(ligne,"smokedelay=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].smokedelay=atof(f+11);
				}
			else if(f=strstr(ligne,"guidance=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].guidance=(f[9]=='1');
				}
			else if(f=strstr(ligne,"tracks=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].tracks=(f[7]=='1');
				}
			else if(f=strstr(ligne,"selfprop=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].selfprop=(f[9]=='1');
				}
			else if(f=strstr(ligne,"waterweapon=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].waterweapon=(f[12]=='1');
				}
			else if(f=strstr(ligne,"smoketrail=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].smoketrail=(f[11]=='1');
				}
			else if(f=strstr(ligne,"flighttime=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].flighttime=atoi(f+11);
				}
			else if(f=strstr(ligne,"coverage=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].coverage=atoi(f+9)*0.5f;
				}
			else if(f=strstr(ligne,"vlaunch=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].vlaunch=(f[8]=='1');
				}
			else if(f=strstr(ligne,"stockpile=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].stockpile=(f[10]=='1');
				}
			else if(f=strstr(ligne,"targetable=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].targetable=(f[11]=='1');
				}
			else if(f=strstr(ligne,"interceptor=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].interceptor=(f[12]=='1');
				}
			else if(f=strstr(ligne,"commandfire=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].commandfire=(f[12]=='1');
				}
			else if(f=strstr(ligne,"cruise=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].cruise=(f[7]=='1');
				}
			else if(f=strstr(ligne,"propeller=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].propeller=(f[10]=='1');
				}
			else if(f=strstr(ligne,"twophase=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].twophase=(f[9]=='1');
				}
			else if(f=strstr(ligne,"dropped=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].dropped=(f[8]=='1');
				}
			else if(f=strstr(ligne,"burnblow=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].burnblow=(f[9]=='1');
				}
			else if(f=strstr(ligne,"shakemagnitude=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].shakemagnitude=atoi(f+15);
				}
			else if(f=strstr(ligne,"metal=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].metal=atoi(f+6);
				}
			else if(f=strstr(ligne,"energy=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].energy=atoi(f+7);
				}
			else if(f=strstr(ligne,"shakeduration=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].shakeduration=atof(f+14);
				}
			else if(f=strstr(ligne,"waterexplosiongaf=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].waterexplosiongaf=strdup(f+18);
				}
			else if(f=strstr(ligne,"waterexplosionart=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].waterexplosionart=strdup(f+18);
				}
			else if(f=strstr(ligne,"lavaexplosiongaf=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].lavaexplosiongaf=strdup(f+17);
				}
			else if(f=strstr(ligne,"lavaexplosionart=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].lavaexplosionart=strdup(f+17);
				}
			else if(f=strstr(ligne,"explosiongaf=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].explosiongaf=strdup(f+13);
				}
			else if(f=strstr(ligne,"explosionart=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].explosionart=strdup(f+13);
				}
			else if(f=strstr(ligne,"soundhit=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].soundhit=strdup(f+9);
				}
			else if(f=strstr(ligne,"soundstart=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].soundstart=strdup(f+11);
				}
			else if(f=strstr(ligne,"soundwater=")) {
				if((strstr(ligne,";")))	*(strstr(ligne,";"))=0;
				weapon[index].soundwater=strdup(f+11);
				}
			else {
				if(strlen(ligne)>1 && strstr(ligne,"{")==NULL && strstr(ligne,"}")==NULL)
					Console->AddEntry("(arme) inconnu: %s",ligne);
				}

		} while(strstr(ligne,"}")==NULL && nb<1000 && pos<limit);
		delete[] ligne;
		ligne=NULL;
	} while(nb<1000 && pos<limit);
}

void load_all_weapons_in_hpi(char *filename)
{
	HPI_FILE hpi;
	hpi.load(filename);
	char *file;
	int n[10];
	int d_index=0;
	char *dir[10];
	int size;
	dir[0]=strdup("/Weapons");
	n[0]=0;
	while(d_index>-1) {
		while(file=hpi.find(dir[d_index],n[d_index]++)) {
			if(hpi.is_dir(file)) {
				dir[++d_index]=strdup(file);
				n[d_index]=0;
				}
			if(strstr(strlwr(file),".tdf")!=NULL) {			// Si le fichier est au bon format
				char *data=(char*)hpi.extract_memory_file(file,&size);
				if(data) {
					weapon_manager.load_tdf(data,size);
					free(data);
					}
				}
			delete[] file;
			}
		free(dir[d_index--]);
		}

	hpi.destroy();
}

void WEAPON::move(float dt,MAP *map)				// Anime les armes
{
	smoke_time+=dt;
	f_time-=dt;
	a_time+=dt;
	VECTOR A;
	A.x=A.y=A.z=0.0f;
	if(!dying && weapon_manager.weapon[weapon_id].twophase && a_time>=weapon_manager.weapon[weapon_id].weapontimer && phase==1) {		// Entre dans la seconde phase
		phase=2;
		f_time=weapon_manager.weapon[weapon_id].flighttime;
		stime=0.0f;
		}
	if(weapon_manager.weapon[weapon_id].twophase && phase==1 && weapon_manager.weapon[weapon_id].vlaunch) {
		V.x=0.0f;
		V.z=0.0f;
		if(V.y<weapon_manager.weapon[weapon_id].weaponvelocity)
			A.y=weapon_manager.weapon[weapon_id].weaponacceleration;
		else
			V.y=weapon_manager.weapon[weapon_id].weaponvelocity;
		}
	if(!dying && weapon_manager.weapon[weapon_id].selfprop && f_time<=0.0f && ((weapon_manager.weapon[weapon_id].twophase && phase==2) || !weapon_manager.weapon[weapon_id].twophase))	dying=true;
	if(weapon_manager.weapon[weapon_id].smoketrail && weapon_manager.weapon[weapon_id].smokedelay<smoke_time) {		// Trainée de fumée des missiles
		POINTF O;
		O.x=O.y=O.z=0.0f;
		smoke_time=0.0f;
		if(visible)
			particle_engine.make_smoke(O+Pos,0,1,0.0f,-1.0f);
		}

	VECTOR hit_vec;
	if(!dying)
		hit_vec=map->hit(Pos,V,!weapon_manager.weapon[weapon_id].waterweapon);
	VECTOR OPos=Pos;

	float h=map->get_unit_h(Pos.x,Pos.z);
	if(!dying && weapon_manager.weapon[weapon_id].waterweapon && ((Pos.y>map->sealvl && V.y>0.0f) || h==map->sealvl))		// Une arme aquatique ne sort pas de l'eau
		hit_vec=Pos;
	else if(!dying && !weapon_manager.weapon[weapon_id].waterweapon && hit_vec.y<=map->sealvl && h<map->sealvl) {
		hit_vec=hit_vec-(map->sealvl-hit_vec.y)/V.y*V;
		hit_vec.y=map->sealvl;
		}

	if(dying)
		killtime-=dt;
	else {
		if(weapon_manager.weapon[weapon_id].lineofsight) {}
		else if(weapon_manager.weapon[weapon_id].ballistic || weapon_manager.weapon[weapon_id].dropped)		// Arme soumise à la gravité
			A.y-=map->ota_data.gravity;
		if(weapon_manager.weapon[weapon_id].guidance && ((weapon_manager.weapon[weapon_id].twophase && phase==2) || !weapon_manager.weapon[weapon_id].twophase)
		&& ((weapon_manager.weapon[weapon_id].waterweapon && Pos.y<map->sealvl) || !weapon_manager.weapon[weapon_id].waterweapon)) {	// Traque sa cible
			float speed=V.Norm();
			if(weapon_manager.weapon[weapon_id].tracks && target>=0) {
				if(weapon_manager.weapon[weapon_id].interceptor && target<=weapons.nb_weapon && weapons.weapon[target].weapon_id!=-1)
					target_pos=weapons.weapon[target].Pos;
				else if(!weapon_manager.weapon[weapon_id].interceptor && target<=units.last_index && units.unit[target].flags!=0)		// Met à jour les coordonnées de la cible
					target_pos=units.unit[target].Pos;
				}
			if(target_pos.y<map->sealvl && !weapon_manager.weapon[weapon_id].waterweapon)
				target_pos.y=map->sealvl;
			VECTOR Dir=target_pos-Pos;
			Dir.Unit();
			VECTOR I,J,K;			// Crée un trièdre
			I=V;
			I.Unit();
			J=I*Dir;
			K=J*I;
			if(speed<weapon_manager.weapon[weapon_id].weaponvelocity) {
				if(speed>0.0f)
					A=A+weapon_manager.weapon[weapon_id].weaponacceleration/speed*V;
				else
					A=A+weapon_manager.weapon[weapon_id].weaponacceleration*Dir;
				}
			float rotate=dt*weapon_manager.weapon[weapon_id].turnrate*TA2RAD;
			V=speed*(cos(rotate)*I+sin(rotate)*K);
			}
		Pos=Pos+dt*(V+dt*(0.33333333f*A+0.16666666667f*Ac));
		V=V+dt*0.5f*(A+Ac);
		Ac=A;
//		V=V+dt*A;
//		Pos=Pos+dt*V;
		stime+=dt;
		}

	if(!dying && weapon_manager.weapon[weapon_id].cruise && ((weapon_manager.weapon[weapon_id].twophase && phase==2) || phase==1))
		if((target_pos-Pos).Norm()>2.0f*fabs(Pos.y-h) && V.y<0.0f)
			V.y=0.0f;

	bool hit=false;
	if(!dying)
		hit=((hit_vec-Pos)%V)<=0.0f && ((hit_vec-OPos)%V>=0.0f);
	bool u_hit=false;

	if(weapon_manager.weapon[weapon_id].interceptor && (Pos-target_pos).Sq()<1024.0f) {
		hit=true;
		hit_vec=Pos;
		if(target<=weapons.nb_weapon && weapons.weapon[target].weapon_id!=-1) {
			weapons.weapon[target].dying=true;
			weapons.weapon[target].killtime=0.0f;
			}
		}

	int hit_idx=-1;
	if(!dying) {
		int t_idx=-1;
		int py=((int)(OPos.z)+map->map_h_d)>>3;
		int px=((int)(OPos.x)+map->map_w_d)>>3;
		int oidx=-1;
		for(int y=-5;y<=5;y++)
			for(int x=-5;x<=5;x++) {
				if(px+x<0 || px+x>=(map->bloc_w<<1))	continue;
				if(py+y<0 || py+y>=(map->bloc_h<<1))	continue;
				t_idx=map->map_data[py+y][px+x].unit_idx;
				if(t_idx>=0 && t_idx!=shooter_idx && t_idx!=hit_idx && t_idx!=oidx) {
					VECTOR Dir=V;
					Dir.Unit();
					VECTOR t_vec;
					t_vec.x=t_vec.y=t_vec.z=0.0f;
					u_hit=units.unit[t_idx].hit(OPos,Dir,&t_vec);
					if(u_hit) {
						if((t_vec-Pos)%V<=0.0f) {			// Touché
							if(!hit) {
								hit_vec=t_vec;
								hit_idx=t_idx;
								}
							else if((hit_vec-OPos)%Dir>=(t_vec-OPos)%Dir) {
								hit_vec=t_vec;
								hit_idx=t_idx;
								}
							else
								u_hit=false;
							}
						else
							u_hit=false;
						}
					hit|=u_hit;
					}
				else if(y==0 && x==0 && t_idx<=-2 && t_idx!=hit_idx && t_idx!=oidx)
					if(!hit && -t_idx-2<features.max_features && features.feature[-t_idx-2].Pos.y+feature_manager.feature[features.feature[-t_idx-2].type].height*0.5f>OPos.y) {
						hit=true;
						hit_vec=OPos;
						hit_idx=t_idx;
						}
				if(t_idx!=-1)
					oidx=t_idx;
				}
			if(hit_idx>=0) {
				bool ok=units.unit[hit_idx].hp>0.0f;		// Juste pour identifier l'assassin...
				units.unit[hit_idx].hp-=weapon_manager.weapon[weapon_id].damage;		// L'unité touchée encaisse les dégats
				units.unit[hit_idx].flags&=0xEF;		// This unit must explode if it has been damaged by a weapon even if it is being reclaimed
				if(ok && units.unit[hit_idx].hp<=0.0f && units.unit[hit_idx].owner_id!=units.unit[shooter_idx].owner_id)		// Non,non les unités que l'on se détruit ne comptent pas dans le nombre de tués mais dans les pertes
					players.kills[units.unit[shooter_idx].owner_id]++;
				units.unit[hit_idx].launch_script(units.unit[hit_idx].get_script_index("hitbyweapon"));
				units.unit[hit_idx].attacked=true;
				}
			if(hit_idx<=-2) {
				features.feature[-hit_idx-2].hp-=weapon_manager.weapon[weapon_id].damage;		// The feature hit is taking damage
				if(features.feature[-hit_idx-2].hp<=0.0f) {
					int sx=((int)(features.feature[-hit_idx-2].Pos.x)+map->map_w_d-4)>>3;		// Delete the feature
					int sy=((int)(features.feature[-hit_idx-2].Pos.z)+map->map_h_d-4)>>3;
					map->rect(sx-(feature_manager.feature[features.feature[-hit_idx-2].type].footprintx>>1),sy-(feature_manager.feature[features.feature[-hit_idx-2].type].footprintz>>1),feature_manager.feature[features.feature[-hit_idx-2].type].footprintx,feature_manager.feature[features.feature[-hit_idx-2].type].footprintz,-1);
					features.delete_feature(-hit_idx-2);			// Supprime l'objet
					}
				}
		}

	if(hit && weapon_manager.weapon[weapon_id].areaofeffect>0) {			// Domages colatéraux
		int t_idx=-1;
		int py=((int)(OPos.z+map->map_h*0.5f))>>3;
		int px=((int)(OPos.x+map->map_w*0.5f))>>3;
		int s=weapon_manager.weapon[weapon_id].areaofeffect>>5;
		int d=weapon_manager.weapon[weapon_id].areaofeffect*weapon_manager.weapon[weapon_id].areaofeffect>>4;
		int oidx[s*s+2*s+1];
		int nb=0;
		for(int y=-s;y<=s;y++)
			for(int x=-s;x<=s;x++) {
				if(px+x<0 || px+x>=(map->bloc_w<<1))	continue;
				if(py+y<0 || py+y>=(map->bloc_h<<1))	continue;
				t_idx=map->map_data[py+y][px+x].unit_idx;
				bool already=(t_idx==hit_idx || t_idx==-1);
				if(!already)
					for(int i=0;i<nb;i++)
						if(t_idx==oidx[i]) {
							already=true;
							break;
							}
				if(!already) {
					if(t_idx>=0 && (units.unit[t_idx].Pos-Pos).Sq()<=d) {
						oidx[nb++]=t_idx;
						bool ok=units.unit[t_idx].hp>0.0f;
						float damage=weapon_manager.weapon[weapon_id].damage*weapon_manager.weapon[weapon_id].edgeeffectiveness;
						units.unit[t_idx].hp-=damage;		// L'unité touchée encaisse les dégats
						units.unit[t_idx].flags&=0xEF;		// This unit must explode if it has been damaged by a weapon even if it is being reclaimed
						if(ok && units.unit[t_idx].hp<=0.0f && units.unit[t_idx].owner_id!=units.unit[shooter_idx].owner_id)		// Non,non les unités que l'on se détruit ne comptent pas dans le nombre de tués mais dans les pertes
							players.kills[units.unit[shooter_idx].owner_id]++;
						units.unit[t_idx].launch_script(units.unit[t_idx].get_script_index("hitbyweapon"));
						units.unit[t_idx].attacked=true;
						}
					else if(t_idx<-1 && (features.feature[-t_idx-2].Pos-Pos).Sq()<=d) {
						oidx[nb++]=t_idx;
						if(features.feature[-t_idx-2].type>=0 && !feature_manager.feature[features.feature[-t_idx-2].type].indestructible) {
							float damage=weapon_manager.weapon[weapon_id].damage*weapon_manager.weapon[weapon_id].edgeeffectiveness;
							features.feature[-t_idx-2].hp-=damage;		// L'objet touché encaisse les dégats
							if(features.feature[-t_idx-2].hp<=0.0f) {
								int sx=((int)(features.feature[-t_idx-2].Pos.x)+map->map_w_d-4)>>3;		// Efface l'objet
								int sy=((int)(features.feature[-t_idx-2].Pos.z)+map->map_h_d-4)>>3;
								map->rect(sx-(feature_manager.feature[features.feature[-t_idx-2].type].footprintx>>1),sy-(feature_manager.feature[features.feature[-t_idx-2].type].footprintz>>1),feature_manager.feature[features.feature[-t_idx-2].type].footprintx,feature_manager.feature[features.feature[-t_idx-2].type].footprintz,-1);
								features.delete_feature(-t_idx-2);			// Supprime l'objet
								}
							}
						}
					}
				}
		}

	if(hit && visible && weapon_manager.weapon[weapon_id].areaofeffect>=256) {			// Effet de souffle / Shock wave
		POINTF O;
		O.x=O.y=O.z=0.0f;
		particle_engine.make_shockwave(O+Pos,1,weapon_manager.weapon[weapon_id].areaofeffect,weapon_manager.weapon[weapon_id].areaofeffect*0.5f);
		particle_engine.make_shockwave(O+Pos,0,weapon_manager.weapon[weapon_id].areaofeffect<<2,weapon_manager.weapon[weapon_id].areaofeffect*0.5f);
		particle_engine.make_nuke(O+Pos,1,weapon_manager.weapon[weapon_id].areaofeffect,weapon_manager.weapon[weapon_id].areaofeffect*0.25f);
		}

	if(hit && weapon_manager.weapon[weapon_id].interceptor)
		if(units.unit[shooter_idx].flags) {
			int e=0;
			for(int i=0;i+e<units.unit[shooter_idx].mem_size;i++) {
				if(units.unit[shooter_idx].memory[i+e]==target) {
					e++;
					i--;
					continue;
					}
				units.unit[shooter_idx].memory[i]=units.unit[shooter_idx].memory[i+e];
				}
			units.unit[shooter_idx].mem_size-=e;
			}

	if(((stime>2.0f*weapon_manager.weapon[weapon_id].range/weapon_manager.weapon[weapon_id].weaponvelocity && (!weapon_manager.weapon[weapon_id].noautorange || weapon_manager.weapon[weapon_id].burnblow))
	 || hit) && !dying) {
		if(hit)
			Pos=hit_vec;
		if(Pos.y==map->sealvl)
			sound_manager.play(weapon_manager.weapon[weapon_id].soundwater,Pos);
		else
			sound_manager.play(weapon_manager.weapon[weapon_id].soundhit,Pos);
		if(hit && weapon_manager.weapon[weapon_id].explosiongaf!=NULL && weapon_manager.weapon[weapon_id].explosionart!=NULL && Pos.y!=map->sealvl) {
			if(visible)
				fx_manager.add(weapon_manager.weapon[weapon_id].explosiongaf,weapon_manager.weapon[weapon_id].explosionart,Pos,1.0f);
			}
		else if(hit && Pos.y==map->sealvl) {
			int px=(int)(Pos.x+0.5f)+map->map_w_d>>4;
			int py=(int)(Pos.z+0.5f)+map->map_h_d>>4;
			if(px>=0 && px<map->bloc_w && py>=0 && py<map->bloc_h) {
				if(map->bloc[map->bmap[py][px]].lava && weapon_manager.weapon[weapon_id].lavaexplosiongaf!=NULL && weapon_manager.weapon[weapon_id].lavaexplosionart!=NULL) {
					if(visible)
						fx_manager.add(weapon_manager.weapon[weapon_id].lavaexplosiongaf,weapon_manager.weapon[weapon_id].lavaexplosionart,Pos,1.0f);
					}
				else if(!map->bloc[map->bmap[py][px]].lava && weapon_manager.weapon[weapon_id].waterexplosiongaf!=NULL && weapon_manager.weapon[weapon_id].waterexplosionart!=NULL)
					if(visible)
						fx_manager.add(weapon_manager.weapon[weapon_id].waterexplosiongaf,weapon_manager.weapon[weapon_id].waterexplosionart,Pos,1.0f);
				}
			else if(weapon_manager.weapon[weapon_id].explosiongaf!=NULL && weapon_manager.weapon[weapon_id].explosionart!=NULL)
				if(visible)
					fx_manager.add(weapon_manager.weapon[weapon_id].explosiongaf,weapon_manager.weapon[weapon_id].explosionart,Pos,1.0f);
			}
		if(weapon_manager.weapon[weapon_id].endsmoke) {
			POINTF O;
			O.x=O.y=O.z=0.0f;
			if(visible)
				particle_engine.make_smoke(O+Pos,0,1,0.0f,-1.0f);
			}
		if(weapon_manager.weapon[weapon_id].rendertype==RENDER_TYPE_LASER) {
			dying=true;
			killtime=weapon_manager.weapon[weapon_id].duration;
			}
		else
			weapon_id=-1;
		}
	else if(dying && killtime<=0.0f)
		weapon_id=-1;
}

void WEAPON::draw(CAMERA *cam,MAP *map)				// Dessine les objets produits par les armes
{
	visible=false;
	if(map) {
		int px=(int)(Pos.x+0.5f)+map->map_w_d>>4;
		int py=(int)(Pos.z+0.5f)+map->map_h_d>>4;
		if(px<0 || py<0 || px>=map->bloc_w || py>=map->bloc_h)	return;
		if(map->view[py][px]!=1
		|| (!map->map_data[py<<1][px<<1].timer && !map->map_data[py<<1][(px<<1)+1].timer && !map->map_data[(py<<1)+1][px<<1].timer && !map->map_data[(py<<1)+1][(px<<1)+1].timer))	return;
		}
	if(cam)
		cam->SetView();
	visible=true;
	switch(weapon_manager.weapon[weapon_id].rendertype)
	{
	case RENDER_TYPE_LASER:						// Dessine le laser
		{
		VECTOR P=Pos;
		float length=weapon_manager.weapon[weapon_id].duration;
		if(weapon_manager.weapon[weapon_id].duration>stime)
			length=stime;
		if(dying && length>killtime)
			length=killtime;
		P=P-length*V;
		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		int color0=weapon_manager.weapon[weapon_id].color[0];
		int color1=weapon_manager.weapon[weapon_id].color[1];
		float coef=(cos(stime)+1.0f)*0.5f;
		float r=(coef*((color0>>16)&0xFF)+coef*((color1>>16)&0xFF))/255.0f;
		float g=(coef*((color0>>8)&0xFF)+coef*((color1>>8)&0xFF))/255.0f;
		float b=(coef*(color0&0xFF)+coef*(color1&0xFF))/255.0f;
		glColor4f(r,g,b,1.0f);
		glBegin(GL_LINES);
			glVertex3f(Pos.x,Pos.y,Pos.z);
			glVertex3f(P.x,P.y,P.z);
		glEnd();
		}
		break;
	case RENDER_TYPE_MISSILE:					// Dessine le missile
		glTranslatef(Pos.x,Pos.y,Pos.z);
		{
			VECTOR I,J,K,Dir,Dir2;
			I.x=I.y=I.z=0.0f;
			J=K=I;
			I.x=1.0f;
			J.z=-1.0f;
			K.y=1.0f;
			Dir=-V;
			Dir.Unit();
			Dir2=Dir;
			Dir2.y=0.0f;
			Dir2.Unit();
			float theta=acos(Dir%Dir2)*RAD2DEG;
			float phi=acos(Dir2%J)*RAD2DEG;
			if(Dir%I<0.0f)	phi=-phi;
			if(Dir2%K<0.0f)	theta=-theta;
			if(Dir.x==0.0f && Dir.y<0.0f && Dir.z==0.0f && theta>0.0f) {
				theta=-theta;
				phi=-phi;
				}
			glRotatef(-phi,0.0f,1.0f,0.0f);
			glRotatef(theta,1.0f,0.0f,0.0f);
		}
		glEnable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		if(weapon_manager.weapon[weapon_id].model)
			weapon_manager.weapon[weapon_id].model->draw();
		break;
	case RENDER_TYPE_BITMAP:
		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		glColor4f(1.0f,1.0f,1.0f,1.0f);
		if(weapon_manager.cannonshell.nb_bmp>0) {
			anim_sprite=((int)(stime*15.0f))%weapon_manager.cannonshell.nb_bmp;
			glEnable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D,weapon_manager.cannonshell.glbmp[anim_sprite]);
			VECTOR A,B,C,D;
			A=Pos+((-0.5f*weapon_manager.cannonshell.h[anim_sprite]-weapon_manager.cannonshell.ofs_y[anim_sprite])*cam->Up+(-0.5f*weapon_manager.cannonshell.w[anim_sprite]-weapon_manager.cannonshell.ofs_x[anim_sprite])*cam->Side);
			B=Pos+((-0.5f*weapon_manager.cannonshell.h[anim_sprite]-weapon_manager.cannonshell.ofs_y[anim_sprite])*cam->Up+(0.5f*weapon_manager.cannonshell.w[anim_sprite]-weapon_manager.cannonshell.ofs_x[anim_sprite])*cam->Side);
			C=Pos+((0.5f*weapon_manager.cannonshell.h[anim_sprite]-weapon_manager.cannonshell.ofs_y[anim_sprite])*cam->Up+(-0.5f*weapon_manager.cannonshell.w[anim_sprite]-weapon_manager.cannonshell.ofs_x[anim_sprite])*cam->Side);
			D=Pos+((0.5f*weapon_manager.cannonshell.h[anim_sprite]-weapon_manager.cannonshell.ofs_y[anim_sprite])*cam->Up+(0.5f*weapon_manager.cannonshell.w[anim_sprite]-weapon_manager.cannonshell.ofs_x[anim_sprite])*cam->Side);
			glBegin(GL_QUADS);
				glTexCoord2f(0.0f,0.0f);		glVertex3f(A.x,A.y,A.z);
				glTexCoord2f(1.0f,0.0f);		glVertex3f(B.x,B.y,B.z);
				glTexCoord2f(1.0f,1.0f);		glVertex3f(D.x,D.y,D.z);
				glTexCoord2f(0.0f,1.0f);		glVertex3f(C.x,C.y,C.z);
			glEnd();
			}
		else {
			glBegin(GL_QUADS);
				glVertex3f(Pos.x-2.5f,Pos.y-2.5f,Pos.z);
				glVertex3f(Pos.x+2.5f,Pos.y-2.5f,Pos.z);
				glVertex3f(Pos.x+2.5f,Pos.y+2.5f,Pos.z);
				glVertex3f(Pos.x-2.5f,Pos.y+2.5f,Pos.z);
			glEnd();
			}
		glEnable(GL_LIGHTING);
		break;
	case RENDER_TYPE_BOMB:
		glTranslatef(Pos.x,Pos.y,Pos.z);
		{
			VECTOR I,J,K,Dir,Dir2;
			I.x=I.y=I.z=0.0f;
			J=K=I;
			I.x=1.0f;
			J.z=-1.0f;
			K.y=1.0f;
			Dir=-V;
			Dir.Unit();
			Dir2=Dir;
			Dir2.y=0.0f;
			Dir2.Unit();
			float theta=acos(Dir%Dir2)*RAD2DEG;
			float phi=acos(Dir2%J)*RAD2DEG;
			if(Dir%I<0.0f)	phi=-phi;
			if(Dir2%K<0.0f)	theta=-theta;
			glRotatef(-phi,0.0f,1.0f,0.0f);
			glRotatef(theta,0.0f,0.0f,1.0f);
		}
		glEnable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		if(weapon_manager.weapon[weapon_id].model)
			weapon_manager.weapon[weapon_id].model->draw();
		break;
	case RENDER_TYPE_LIGHTNING:
		{
		VECTOR P=Pos;
		float length=weapon_manager.weapon[weapon_id].duration;
		if(weapon_manager.weapon[weapon_id].duration>stime)
			length=stime;
		if(dying && length>killtime)
			length=killtime;
		P=P-length*V;
		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		int color0=weapon_manager.weapon[weapon_id].color[0];
		int color1=weapon_manager.weapon[weapon_id].color[1];
		float coef=(cos(stime)+1.0f)*0.5f;
		float r=(coef*((color0>>16)&0xFF)+coef*((color1>>16)&0xFF))/255.0f;
		float g=(coef*((color0>>8)&0xFF)+coef*((color1>>8)&0xFF))/255.0f;
		float b=(coef*(color0&0xFF)+coef*(color1&0xFF))/255.0f;
		glColor4f(r,g,b,1.0f);
		glBegin(GL_LINE_STRIP);
			for(int i=0;i<10;i++) {
				float x,y,z;
				if(i>0 && i<9) {
					x=((rand_from_table()%2001)-1000)*0.005f;
					y=((rand_from_table()%2001)-1000)*0.005f;
					z=((rand_from_table()%2001)-1000)*0.005f;
					}
				else
					x=y=z=0.0f;
				glVertex3f(Pos.x+(P.x-Pos.x)*i/9+x,Pos.y+(P.y-Pos.y)*i/9+y,Pos.z+(P.z-Pos.z)*i/9+z);
				}
		glEnd();
		}
		break;
	case RENDER_TYPE_DGUN:			// Dessine le dgun
		glTranslatef(Pos.x,Pos.y,Pos.z);
		{
			VECTOR I,J,K,Dir,Dir2;
			I.x=I.y=I.z=0.0f;
			J=K=I;
			I.x=1.0f;
			J.z=-1.0f;
			K.y=1.0f;
			Dir=-V;
			Dir.Unit();
			Dir2=Dir;
			Dir2.y=0.0f;
			Dir2.Unit();
			float theta=acos(Dir%Dir2)*RAD2DEG;
			float phi=acos(Dir2%J)*RAD2DEG;
			if(Dir%I<0.0f)	phi=-phi;
			if(Dir2%K<0.0f)	theta=-theta;
			glRotatef(-phi,0.0f,1.0f,0.0f);
			glRotatef(theta,1.0f,0.0f,0.0f);
		}
		glEnable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		if(weapon_manager.weapon[weapon_id].model)
			weapon_manager.weapon[weapon_id].model->draw();
		break;
	case RENDER_TYPE_GUN:			// Dessine une "balle"
		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		glBegin(GL_POINTS);
			glColor3f(0.75f,0.75f,0.75f);
			glVertex3f(Pos.x,Pos.y,Pos.z);
		glEnd();
		break;
	case RENDER_TYPE_PARTICLES:		// Dessine des particules
		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		glBegin(GL_POINTS);
			glColor3f(0.75f,0.75f,0.75f);
			for(int i=0;i<10;i++)
				glVertex3f(Pos.x+(rand_from_table()%201)*0.01f-1.0f,Pos.y+(rand_from_table()%201)*0.01f-1.0f,Pos.z+(rand_from_table()%201)*0.01f-1.0f);
		glEnd();
		break;
	};
}

int FX_MANAGER::add(char *filename,char *entry_name,VECTOR Pos,float size)
{
	if(game_cam!=NULL && (Pos-game_cam->Pos).Sq()>=game_cam->zfar2)	return -1;
	if(nb_fx+1>max_fx) {
		max_fx+=100;
		FX *n_fx=(FX*) malloc(sizeof(FX)*max_fx);
		memcpy(n_fx,fx,sizeof(FX)*(max_fx-100));
		for(int i=max_fx-100;i<max_fx;i++)
			n_fx[i].init();
		free(fx);
		fx=n_fx;
		}
	nb_fx++;
	int idx=-1;
	for(int i=0;i<max_fx;i++)
		if(!fx[i].playing) {
			idx=i;
			break;
			}
	char tmp[200];
	char fullname[200];
	tmp[0]=0;
	strcat(tmp,"/anims/");
	strcat(tmp,filename);
	strcat(tmp,".gaf");
	fullname[0]=0;
	strcat(fullname,tmp);
	strcat(fullname,"-");
	strcat(fullname,entry_name);
	int anm_idx=is_in_cache(fullname);
	if(anm_idx==-1) {
		byte *data=load_file(tmp);
		if(data) {
			ANIM *anm=new ANIM;
			anm->init();
			anm->load_gaf(data,get_gaf_entry_index(data,entry_name));
			anm->convert(false,true);

			anm_idx=put_in_cache(fullname,anm);

			free(data);
			}
		}
	else
		use[anm_idx]++;
	fx[idx].load(anm_idx,Pos,size);
	return idx;
}

void load_weapons()				// Charge toutes les armes
{
	al_ffblk search;

	if(al_findfirst("*.hpi",&search,FA_RDONLY | FA_ARCH)==0)
	do
	{
		load_all_weapons_in_hpi(search.name);
		allegro_gl_flip();
	}while(al_findnext(&search)==0);
	al_findclose(&search);
	if(al_findfirst("*.ufo",&search,FA_RDONLY | FA_ARCH)==0)
	do
	{
		load_all_weapons_in_hpi(search.name);
		allegro_gl_flip();
	}while(al_findnext(&search)==0);
	al_findclose(&search);
	if(al_findfirst("*.ccx",&search,FA_RDONLY | FA_ARCH)==0)
	do
	{
		load_all_weapons_in_hpi(search.name);
		allegro_gl_flip();
	}while(al_findnext(&search)==0);
	al_findclose(&search);

	load_all_weapons_in_hpi("rev31.gp3");
	allegro_gl_flip();

	byte *data=load_file("/anims/fx.gaf");			// Charge les animations des armes
	if(data) {
		weapon_manager.cannonshell.load_gaf(data,get_gaf_entry_index(data,"cannonshell"));
		weapon_manager.cannonshell.convert(false,true);
		weapon_manager.cannonshell.clean();
		free(data);
		}
}
