/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------\
|                           pathfinding.h                          |
|   contient toutes les fonctions et classes nécessaires à la mise |
| en place du pathfinding de TA3D                                  |
\-----------------------------------------------------------------*/

#define MAX_PATH_EXEC		1

struct PATH_NODE			// Noeud d'un chemin
{
	int			x,y;				// Position du noeud(sur la carte)
	VECTOR		Pos;				// Position du noeud sur le terrain
	PATH_NODE	*next;				// Noeud suivant
};

void destroy_path(PATH_NODE *path);		// Détruit un chemin
PATH_NODE *find_path(SECTOR **map_data,byte **map,float **h_map,int map_w,int map_h,float dh_max,float h_min,PATH_NODE Start,PATH_NODE End,int *h,int mw,int mh,int u_idx,int l=0);			// Trouve le meilleur chemin pour aller de Start à End
PATH_NODE *find_path_level(SECTOR **map_data,byte **map,float **h_map,int map_w,int map_h,float h_max,PATH_NODE Start,PATH_NODE End,int *h,int mw,int mh,int u_idx,int l=0);			// Trouve le meilleur chemin pour aller de Start à End
float path_length(PATH_NODE *path);
void simplify_path(PATH_NODE *path);
void short_path(PATH_NODE *path);
PATH_NODE *next_node(PATH_NODE *path);
void compute_coord(PATH_NODE *path,int map_w,int map_h,int bloc_w,int bloc_h);
PATH_NODE *compute_path(SECTOR **map_data,byte **map,float **h_map,int map_w,int map_h,int bloc_w,int bloc_h,float dh_max,float h_min,VECTOR Start,VECTOR End,bool level,int mw,int mh,int u_idx);
PATH_NODE *direct_path(VECTOR End);
bool is_direct(SECTOR **map_data,byte **map,float **h_map,float dh_max,float h_min,float h_max,PATH_NODE A,PATH_NODE B,int mw,int mh,int bw,int bh,int u_idx);
void make_path_direct(SECTOR **map_data,byte **map,float **h_map,float dh_max,float h_min,float h_max,PATH_NODE *path,int mw,int mh,int bw,int bh,int u_idx);
PATH_NODE *compute_path_min_dist(SECTOR **map_data,byte **map,float **h_map,int map_w,int map_h,int bloc_w,int bloc_h,float dh_max,float h_min,VECTOR Start,VECTOR End,bool level,int mw,int mh,int u_idx,int m_dist);
