/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*---------------------------------------------------------------------------------\
|                                        gui.cpp                                   |
|         Contient les fonctions nécessaires à la gestion de l'interface de ta3D   |
|  comme les boutons, les fenêtres,...                                             |
|                                                                                  |
\---------------------------------------------------------------------------------*/

#ifdef CWDEBUG
#include <libcwd/sys.h>
#include <libcwd/debug.h>
#endif
#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"

void glbutton(char *caption,float x1,float y1,float x2,float y2,bool etat)
{
	glDisable(GL_TEXTURE_2D);

	glBegin(GL_QUADS);
	if(!etat) {
		glColor3f(1.0f,1.0f,1.0f);	glVertex2f(x1,y1);			// Dessine les bords du bouton
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x2,y1);
		glColor3f(0.0f,0.0f,0.0f);	glVertex2f(x2,y2);
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x1,y2);
		}
	else {
		glColor3f(0.0f,0.0f,0.0f);	glVertex2f(x1,y1);			// Dessine les bords du bouton
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x2,y1);
		glColor3f(1.0f,1.0f,1.0f);	glVertex2f(x2,y2);
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x1,y2);
		}

		glVertex2f(x1+2,y1+2);			// Dessine le fond du bouton
		glVertex2f(x2-2,y1+2);
		glVertex2f(x2-2,y2-2);
		glVertex2f(x1+2,y2-2);
	glEnd();

	glEnable(GL_TEXTURE_2D);

	glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);
	glEnable(GL_BLEND);
	if(etat)
		allegro_gl_printf(aglfont,0.5f*(x1+x2-9*strlen(caption))+1.0f,0.5f*(y1+y2-9.0f)+1.0f,0.0f,0xFFFFFF,caption);
	else
		allegro_gl_printf(aglfont,0.5f*(x1+x2-9*strlen(caption)),0.5f*(y1+y2-9.0f),0.0f,0xFFFFFF,caption);
	glDisable(GL_BLEND);
}

char *msg_box(FONT *fnt,char *title,char *msg,bool ask)
{
	allegro_gl_set_allegro_mode();
	for(int i=0;i<2;i++) {
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	glColor4f(0.5f,0.5f,0.5f,1.0f);
	glBegin(GL_QUADS);
		glVertex2i(SCREEN_W>>2,SCREEN_H>>2);
		glVertex2i(SCREEN_W*3>>2,SCREEN_H>>2);
		glVertex2i(SCREEN_W*3>>2,SCREEN_H*3>>2);
		glVertex2i(SCREEN_W>>2,SCREEN_H*3>>2);
	glEnd();
	glBegin(GL_LINES);
		glColor4f(1.0f,1.0f,1.0f,1.0f);
		glVertex2i(SCREEN_W>>2,SCREEN_H>>2);		glVertex2i(SCREEN_W*3>>2,SCREEN_H>>2);
		glVertex2i(SCREEN_W>>2,SCREEN_H>>2);		glVertex2i(SCREEN_W>>2,SCREEN_H*3>>2);

		glColor4f(0.25f,0.25f,0.25f,1.0f);
		glVertex2i(SCREEN_W*3>>2,SCREEN_H*3>>2);	glVertex2i(SCREEN_W>>2,SCREEN_H*3>>2);
		glVertex2i(SCREEN_W*3>>2,SCREEN_H*3>>2);	glVertex2i(SCREEN_W*3>>2,SCREEN_H>>2);
	glEnd();
	glBegin(GL_QUADS);
		glColor4f(0.3f,0.3f,1.0f,1.0f);
		glVertex2i((SCREEN_W>>2)+3,(SCREEN_H>>2)+3);
		glColor4f(0.7f,0.7f,1.0f,1.0f);
		glVertex2i((SCREEN_W*3>>2)-3,(SCREEN_H>>2)+3);
		glVertex2i((SCREEN_W*3>>2)-3,(SCREEN_H>>2)+3+text_height(fnt));
		glColor4f(0.3f,0.3f,1.0f,1.0f);
		glVertex2i((SCREEN_W>>2)+3,(SCREEN_H>>2)+3+text_height(fnt));
	glEnd();
	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	allegro_gl_printf(fnt,SCREEN_W-text_length(fnt,title)>>1,(SCREEN_H>>2)+3+0.0f*text_height(fnt),0.0f,0xFFFFFF,title);		// Titre

	allegro_gl_printf(fnt,(SCREEN_W>>2)+5,(SCREEN_H>>2)+3+2*text_height(fnt),0.0f,0xFFFFFF,msg);		// Message
	allegro_gl_flip();
	}

	char *buf=NULL;

	if(ask) {
		buf=(char*) malloc(100);
		buf[0]=0;
		clear_keybuf();
		}

	bool done=false;

	do {
		if(key[KEY_ESC] || key[KEY_ENTER]) {
			while(key[KEY_ESC] || key[KEY_ENTER])
				rest(1);
			done=true;
			}
		else
			rest(1);

	if(ask) {
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
		glColor4f(0.15f,0.15f,0.15f,1.0);
		glBegin(GL_QUADS);
			glVertex2i((SCREEN_W>>1)-100,SCREEN_H-text_height(fnt)>>1);
			glVertex2i((SCREEN_W>>1)+100,SCREEN_H-text_height(fnt)>>1);
			glVertex2i((SCREEN_W>>1)+100,SCREEN_H+text_height(fnt)>>1);
			glVertex2i((SCREEN_W>>1)-100,SCREEN_H+text_height(fnt)>>1);
		glEnd();
		glBegin(GL_LINES);
			glColor4f(0.0f,0.0f,0.0f,1.0);
			glVertex2i((SCREEN_W>>1)-100,SCREEN_H-text_height(fnt)>>1);			glVertex2i((SCREEN_W>>1)+100,SCREEN_H-text_height(fnt)>>1);
			glVertex2i((SCREEN_W>>1)-100,SCREEN_H-text_height(fnt)>>1);			glVertex2i((SCREEN_W>>1)-100,SCREEN_H+text_height(fnt)>>1);

			glColor4f(1.0f,1.0f,1.0f,1.0);
			glVertex2i((SCREEN_W>>1)+100,SCREEN_H+text_height(fnt)>>1);			glVertex2i((SCREEN_W>>1)-100,SCREEN_H+text_height(fnt)>>1);
			glVertex2i((SCREEN_W>>1)+100,SCREEN_H+text_height(fnt)>>1);			glVertex2i((SCREEN_W>>1)+100,SCREEN_H-text_height(fnt)>>1);
		glEnd();
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);

		if(keypressed()) {
			char key_code=readkey();
			switch(key_code)
			{
			case 27:
			case 9:
			case 10:
			case 13:
				break;
			case 8:
				if(buf[0])
					buf[strlen(buf)-1]=0;
				break;
			default:
				if(strlen(buf)<99 && text_length(fnt,buf)<180) {
					buf[strlen(buf)+1]=0;
					buf[strlen(buf)]=key_code;
					}
			};
			}

		allegro_gl_printf(fnt,(SCREEN_W>>1)-100,SCREEN_H-text_height(fnt)>>1,0.0f,0xFFFFFF,"%s_",buf);
		}

		allegro_gl_flip();
	}while(!done);

	allegro_gl_unset_allegro_mode();

	return buf;
}
