#include <stdlib.h>
#include <stdio.h>
#include "math.h"
#include <time.h>
#include <string.h>
#include <iostream.h>
#include <dime.h>
#include "allegro.h"
#include "titans.h"
#include "CMap10.h"
#include "side_class.h"
#include "math.h"

#define 	tile_w  32
#define	    tile_h  32

class chara : public enemy
	{
     private:
     	//int lx,rx;
        int selected;
        //int mode;
     public:
     	void set_pos(float xx, float yy);
        void not_exist(void);
        void show_options(BITMAP *backgr, int menu_x, int menu_y);
        void draw_box(BITMAP *backgr, float s_x, float s_y, weapon guns[10]);
        void toggle_selected(void);
        void not_selected(void);
        int ret_selected(void);
        void delete_enim(void);
        void prev_wep(void);
        void next_wep(void);
        void life_up(void);
        void life_down(void);
        void set_life(int n);
        int ret_life(void);
        void set_weapon(int n);
        int ret_weapon(void);
    };

int chara::ret_weapon(void)
	{
     return weapon_no;
    }

void chara::set_weapon(int n)
	{
     weapon_no=n;
    }

int chara::ret_life(void)
	{
     return life;
    }

void chara::set_life(int n)
	{
     life=n;
    }

void chara::life_up(void)
	{
     life+=5;
    }
void chara::life_down(void)
	{
     if(life>6)
     	life-=5;
    }

void chara::prev_wep(void)
	{
     if(weapon_no>0)
       weapon_no--;
    }

void chara::next_wep(void)
	{
     weapon_no++;
    }

void chara::delete_enim(void)
	{
     rx=0;
     lx=0;
     x=0;
     y=0;
     exist=1;
    }

int chara::ret_selected(void)
	{
     return selected;
    }

void chara::not_selected(void)
	{
     selected=0;
    }

void chara::toggle_selected(void)
	{
     if(selected==0)
       {
		selected=1;
       }
     else if(selected==1)
       {
       selected=0;
       }
    }

void chara::draw_box(BITMAP *backgr, float s_x, float s_y, weapon guns[10])
     {
     if(selected==1)
       {
     	rect(backgr,(int)x-(int)s_x,(int)y-(int)s_y,(int)x-(int)s_x+pic->w,(int)y-(int)s_y+pic->h,133);
     	textprintf_centre(backgr,font,320,40,136,"Click and drag to move the enemy's range lines");
        line(backgr,(int)lx-(int)s_x , 0 , (int)lx-(int)s_x , 480 , 109);
        line(backgr,(int)rx-(int)s_x , 0 , (int)rx-(int)s_x , 480 , 109);
        guns[weapon_no].write_name(backgr,320,50,136,font);
        textprintf_centre(backgr,font,320,60,136,"Holding: %d",holding);
        draw_life(backgr,s_x,s_y);
        textprintf_centre(backgr,font,320,70,136,"Right click to edit enemy");
       }
     }

void chara::not_exist(void)
	{
     exist=0;
    }

void chara::set_pos(float xx, float yy)
	{
     x=xx;
     y=yy;
     selected=1;
     weapon_no=0;
     rx=xx+40;
     lx=xx;
    }

void chara::show_options(BITMAP *backgr, int menu_x, int menu_y)
	{
     rectfill(backgr,menu_x,menu_y,menu_x+100,menu_y+200,0);
     textprintf(backgr,font,menu_x+5,menu_y+5,136,"Define limits");
    }


BITMAP *backgr, *walk;
DATAFILE *data;

void startup(void);
void one_loop(void);
void get_keys(void);

void loader(void);

void draw_all(void);
void draw_enims(void);
void draw_tiles(void);
void define_weapons(void);
void define_powerups(void);

void set_range_change(void);

void edit_enim(void);

CLayer main_layer, layer2;
CTile tile1[100];


chara enim[100];
pickup_set powerups;
pickup_set powerups_defined;

int number_of_enemies=0;

int x=0,y=0;
int s_x=0,s_y=0;
int tile_selection=0;
int enim_selection=0;
int powerup_selection=1;
int powerup_number=1;

int layer=1;
int mode=0;
int save_x=100, save_y=100;

void go_sec(void);
volatile int sec=0;
int cycles=0;

int place_wait=0;
int t_x,t_y;
int selected=-1;  //keeps track of which enemy is selected
int set_range=0;	//flag 0=not setting range, 1=is setting range
int cc=133;
int moving=0,moving_powerup=0;

BITMAP *enim_pics[10];

part_att gun_part[10];
weapon gun[10];

void go_sec()
	{
    sec++;
	}
END_OF_FUNCTION(go_sec);

int main(void)
	{
	 startup();
     while(!key[KEY_ESC])
     	while(sec>cycles && !key[KEY_ESC]) // sec>cycles for timing
       	   {
       	   one_loop();
       	   }
    }
END_OF_MAIN();

void startup(void)
     {
     char * noise;
     int x,y;
     allegro_init();
     install_keyboard();
     install_timer();
     install_mouse();
     set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
     install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL);
     srand(time(0));
     set_color_depth(8);
     dime_init();

     data=load_datafile("titans.dat");
     //sets the palette
     set_palette((RGB*)data[pal].dat);

     //creates a bitmap that is 640 pixels by 480 pixels
     backgr=create_bitmap(640,480);
     walk=create_bitmap(640,480);
     rectfill(backgr,0,0,640,480,0);

     enim_pics[0]=(BITMAP*)data[enim_pic].dat;
     enim_pics[1]=(BITMAP*)data[probe1].dat;
     enim_pics[2]=(BITMAP*)data[enim2_pic].dat;

/*     enim_arm_pics[0]=(BITMAP*)data[arm_enim].dat;
     enim_arm_pics[1]=(BITMAP*)data[enim2_arm].dat;
     enim_arm_pics[2]=(BITMAP*)data[enim3_arm].dat;      */

     tile1[0].init();
     tile1[0].load_tile((BITMAP*)data[g1].dat, (BITMAP*)data[g1_walk].dat,1);

     tile1[1].init();
     tile1[1].load_tile((BITMAP*)data[g2].dat, (BITMAP*)data[g1_walk].dat,2);

     tile1[2].init();
     tile1[2].load_tile((BITMAP*)data[g3].dat, (BITMAP*)data[g1_walk].dat,3);

     tile1[3].init();
     tile1[3].load_tile((BITMAP*)data[g4].dat, (BITMAP*)data[g1_walk].dat,4);

     tile1[4].init();
     tile1[4].load_tile((BITMAP*)data[g5].dat, (BITMAP*)data[g1_walk].dat,5);

     tile1[5].init();
     tile1[5].load_tile((BITMAP*)data[g6].dat, (BITMAP*)data[g1_walk].dat,6);

     tile1[6].init();
     tile1[6].load_tile((BITMAP*)data[g7].dat, (BITMAP*)data[g1_walk].dat,7);

     tile1[7].init();
     tile1[7].load_tile((BITMAP*)data[g8].dat, (BITMAP*)data[g1_walk].dat,8);

     tile1[8].init();
     tile1[8].load_tile((BITMAP*)data[g9].dat, (BITMAP*)data[g1_walk].dat,9);


     main_layer.init(1,200,200,tile_w,tile_h,640,480);
     layer2.init(1,200,200,tile_w,tile_h,640,480);

     powerups.init();

     att_set temp_att; //creates a set of attributes for the player
     temp_att.max_speed=3.5;
     temp_att.accel=1;
     temp_att.term_vel=10;
     temp_att.j_speed=25;

     for(int n=0;n<100;n++)
        {
     	/*enim[n].init((BITMAP*)data[character].dat,
        (BITMAP*)data[character].dat,temp_att,320,240); */
               enim[n].init((BITMAP*)data[character].dat,
     (BITMAP*)data[character_jump].dat,
     (BITMAP*)data[arm].dat,
     (BITMAP*)data[crouch].dat,
     temp_att,320,240);
     	enim[n].init2(1);
        enim[n].not_exist();
        }

     if(( color_map = (COLOR_MAP*)malloc( sizeof( COLOR_MAP) )) == NULL)
        {
                printf("Unable to allocate colour map!\n");
                exit( 1);
        }
     create_trans_table(color_map,(RGB*)data[pal].dat, 70, 70, 70, NULL);//168

     define_weapons();
     define_powerups();

     LOCK_VARIABLE(sec);
     LOCK_FUNCTION(go_sec);
     install_int_ex(go_sec, BPS_TO_TIMER(40));

     }

void one_loop(void)
	{
     int num=0;
     cc=133;
     cycles++;
     rectfill(backgr,0,0,640,480,0);

     draw_all();
     get_keys();

     if(mode==2)
       {
     	x=mouse_x+s_x;
     	y=mouse_y+s_y;
       }

     t_x=x-(x%tile_w);
     t_y=y-(y%tile_h);

     if(key[KEY_ENTER] || (mouse_b==1 && mode==2))
       {
        if(layer==1)
        	main_layer.load_tile(tile1[tile_selection],t_x/tile_w,t_y/tile_h);
        else if(layer==2)
        	layer2.load_tile(tile1[tile_selection],t_x/tile_w,t_y/tile_h);
       }

     if(key[KEY_E])
       {
        if(layer==1)
        	main_layer.remove_tile(t_x/tile_w,t_y/tile_h);
        else if(layer==2)
        	layer2.remove_tile(t_x/tile_w,t_y/tile_h);
       }

     poll_mouse();

     /***NOTE ON THE MOUSE COORDINATES
     Note that the positions mouse_x and mouse_y are for the postion of the
     mouse pointer on the screen. To get the 'real world' position of the
     mouse I use mouse_x+s_x, and mouse_y+s_y.  This is the mouse's screen
     position plus the postion of the top left corner of the scree. ***/

     if(mouse_x > 640 - tile_w)
       {
        s_x+=tile_w;
        x+=tile_w;
       }
     else if(mouse_x <tile_w && s_x>tile_w)
       {
        s_x-=tile_w;
        x-=tile_w;
       }

     if(mouse_y > 480 - tile_h)
       {
        s_y+=tile_h;
        y+=tile_h;
       }
     else if(mouse_y <tile_h && s_y>tile_h)
       {
        s_y-=tile_h;
        y-=tile_h;
       }

      for(int n=0 ; n<number_of_enemies ; n++) //goes through all enemies
        	{
        	if(enim[n].exist==1)       //if it exists
          	    {
              	 if (enim[n].ret_selected()==1) //if it is selected
                   {
                   selected=n;//selected becomes equal to the enemy selected
                   break;
                   }
                 else
                   selected=-1; //otherwise selected says nothing is selected
                }
            }

     set_range_change();

     if(mouse_b==1 && mode==3)
       {
	    //creates a new powerup from the defined set of powerups at the
        //current selection.  It creates this powerup at the mouse position
        powerups.create_from(powerups_defined.ret_pickup(powerup_number),
                             mouse_x+s_x,mouse_y+s_y);
        rest(100);
       }

     if(moving_powerup==1)
       powerups.move(mouse_x+s_x,mouse_y+s_y,powerup_selection);

     if(mouse_b!=1)
       moving_powerup=0;

     if(mouse_b==1 && mode==0 && moving_powerup==0)
       {
        //num becomes equal to the number of the powerup selected
        num=powerups.collide_with_bmp((BITMAP*)data[pointer].dat,
           mouse_x+s_x,mouse_y+s_y);

        if(num!=-1)//if something is selected
          {
           powerup_selection=num;
           if(moving_powerup==0) //if it's not being moved
           	  powerups.toggle_selected(num); //toggle the selection of

           if(mouse_b==1 && mode==0)
     	    {
            moving_powerup=1;
            }
              //that powerup
           rest(100);
          }
        else
          {
           powerup_selection=-1;
           powerups.deselect_all();
          }
       }

     if(mouse_b==1 && mode==4)
       {
        save_x=mouse_x+(int)s_x;
        save_y=mouse_y+(int)s_y;
       }

      //if pressing d, and in selection mode and some powerup is selected
      if(key[KEY_D] && mode==0 && powerup_selection!=-1)
        {
         powerups.remove(powerup_selection);  //remove that powerup
         powerup_selection=-1;  //reset powerup selection to nothing
         rest(150);
        }

     //'moving==0' is to make sure that the enemy selection isn't toggled when
     //it is being moved
     if(mouse_b==1  &&  mode==0 && set_range==0 && moving==0) //select enemies
       {
        for(int n=0 ; n<number_of_enemies ; n++) //goes through all enemies
        	{
        	if(enim[n].exist==1)       //of it exists
          	    {
                 //and the mouse pointer is touching it
                 if(check_col((BITMAP*)data[pointer].dat,enim[n].ret_pic(),mouse_x+s_x,
                           mouse_y+s_y,enim[n].ret_x(),enim[n].ret_y())==1)
                   {
                    //sets flag to say that the character is being moved
                    moving=1;
                    enim[n].toggle_selected(); //toggle the selection

	                rest(100);
                   }
                 else   //if the mouse it not touching it
                   {
                    enim[n].not_selected(); //it's not selected (eg perosn clicked off)
                   }
                }
            }
        }

       else if(mouse_b!=1)//if the mouse is not being held down, it is not being moved
         //anymore
         moving=0;
       else if(moving==1) //the the enemy is being moved
         {
          //set it's postion to the mouse poition
          enim[selected].set_pos(mouse_x+s_x-15,mouse_y+s_y);
         }

     if(mouse_b==1 && place_wait==0 && mode==1 && set_range==0) //place enemies
       {
        enim[number_of_enemies].exist=1;
        enim[number_of_enemies].set_pos(mouse_x+s_x,mouse_y+s_y);
        enim[number_of_enemies].set_pic(enim_pics[enim_selection],enim_selection);
        enim[number_of_enemies].add_gun(gun[0]);
        number_of_enemies++;
        place_wait=40;	//counter so player doesn't place too many at once
   //     while(!key[KEY_ENTER]) {}
       }

     for(int n=0 ; n<number_of_enemies ; n++)
        {
        if(enim[n].exist==1)
          {
        	enim[n].move(&main_layer);
        	
        	if(key[KEY_SPACE])
                enim[n].patrol_norm(enim[n].ret_lx(),enim[n].ret_rx(),1);
            else
                {
                enim[n].stop();
                }
           }
        }

     if(key[KEY_P])
       {
        mode++;
        set_range=0;
        rest(100);
       }
     else if(key[KEY_O] && mode>0)
       {
        mode--;
        set_range=0;
        rest(100);
       }

     if(key[KEY_D] && selected!=-1 && number_of_enemies>0) //if something is selected
    	{
         for(int n=selected ; n<number_of_enemies-1 ; n++)
            {
             enim[n]=enim[n+1];
            }
         enim[number_of_enemies].delete_enim();
         number_of_enemies--;
         //enim[selected].delete_enim();
        }

     if(mouse_b==2 && selected!=-1)
       {
        edit_enim();
       }
    /* if(key[KEY_D] && selected!=-1)
       {  */
       
     if(key[KEY_R] /*&& selected!=-1*/)
       {
        if(selected!=-1 && mode==0)
        	enim[selected].life_down();
        else if(mode==3 && powerup_number>1)
            powerup_number--;
        rest(75);
       }
     if(key[KEY_T] /*&& selected!=-1*/)
       {
        if(selected!=-1 && mode==0)
        	enim[selected].life_up();
        else if(mode==3)
            powerup_number++;
        rest(75);
       }

     if( (set_range==1 || set_range==2) && selected!=-1)
       {
        cc=90;
        //set_range 1 is for the left range
        //set range 2 is for the right range
        //for moving the left range line, the mouse position must be smaller
        //than enemy's x postion
        //for moving the right line the mouse_x must be larger than the
        //enemy's x postion plus some
        if(set_range==1 && mouse_x+s_x < enim[selected].ret_x())
          //sets the new line postion to that of the mouse
          enim[selected].set_lx (mouse_x+s_x);
        else if(set_range==2 && mouse_x+s_x > enim[selected].ret_x()+30)
          enim[selected].set_rx (mouse_x+s_x);

        rectfill(backgr,40,40,600,48,0);
        textprintf_centre(backgr,font,320,40,136,"Release the mouse to set the position");
        }

       if(mode==2)
         {
          if(key[KEY_T] && tile_selection<8)
            tile_selection++;
          else if(key[KEY_R] && tile_selection>0)
            tile_selection--;
         }
       else if(mode==1)
         {
          if(key[KEY_T])
            enim_selection++;
          else if(key[KEY_R] && enim_selection>0)
            enim_selection--;
         }

     if(place_wait>0)
       place_wait--;

     draw_sprite(backgr,(BITMAP*)data[character].dat,save_x-(int)s_x,save_y-(int)s_y);

     textprintf(backgr,font,2,2,108,"Layer :%d",layer);

     if(mode==0)
       textprintf(backgr,font,2,12,108,"Select");
     else if(mode==1)
       textprintf(backgr,font,2,12,108,"Place Enemies");
     else if(mode==2)
       textprintf(backgr,font,2,12,108,"Place Tiles");
     else if(mode==3)
       textprintf(backgr,font,2,12,108,"Place Powerups");
     else if(mode==4)
       textprintf(backgr,font,2,12,108,"Place Start");


     textprintf(backgr,font,2,22,108,"Enemy: %d",enim_selection);
     textprintf(backgr,font,2,32,108,"# of Enemies: %d",number_of_enemies);
     textprintf(backgr,font,2,42,108,"Powerup #: %d",powerup_selection);

     textprintf_centre(backgr,font,320,2,137,"Use the number keys to change layers.");
     textprintf_centre(backgr,font,320,12,137,"Use the O and P keys to change mouse modes.");
     textprintf_centre(backgr,font,320,22,137,"Use the arrow keys and ENTER to place tiles.");
     
     rectfill(backgr,0,455,640,480,0);
     textprintf_centre(backgr,font,320,460,137,"Use the T and R keys to change the tile, powerup, or enemy type to be placed.");
     textprintf_centre(backgr,font,320,470,137,"Hold SPACE to test the enemy movement");

     tile1[tile_selection].draw_tile2(backgr,600,5);

     if(cc==90)
       draw_sprite(backgr,(BITMAP*)data[resize_hori].dat,mouse_x-9,mouse_y-3);
     else
       draw_sprite(backgr,(BITMAP*)data[pointer].dat,mouse_x,mouse_y);
   
       //circlefill(backgr,mouse_x,mouse_y,5,cc);

     blit(backgr,screen,0,0,0,0,640,480);
    }

void get_keys(void)
	{
     if(key[KEY_UP] && y>=tile_h)
       {
        y-=tile_h;
       }
     else if(key[KEY_DOWN] )
       {
        y+=tile_h;
       }
     if(key[KEY_LEFT] && x>=tile_w)
       {
        x-=tile_w;
       }
     else if(key[KEY_RIGHT] )
       {
        x+=tile_w;
       }

     if(key[KEY_1])
       layer=1;
     else if(key[KEY_2])
       layer=2;

     if(y-s_y<=tile_h && s_y>0)
       s_y-=tile_h;
     else if(y-s_y>=480-tile_h)
       s_y+=tile_h;

     if(x-s_x<=tile_w && s_x>0)
       s_x-=tile_w;
     else if(x-s_x>=640-tile_w)
       s_x+=tile_w;

     if(key[KEY_S])
       {
        clear_keybuf();
     	char file_name[100]="";
        //opens a dialog to load a save a filename
     	dialogf("Filename",ALIGN_CENTRE,ALIGN_CENTRE,200,
             "Please choose a file to save%line[]"
             "Map%filename[98,map,Save a map]",
             file_name);

        //checks to see if '.map' already exists in the filename
        if(strstr(file_name,".map")==NULL)
        	strcat(file_name,".map"); //if it doesn't, then it adds it

        FILE *fp;
        fp=fopen(file_name,"w");

        //number_of_enemies=1;
        fprintf(fp,"%d ",number_of_enemies);

        fprintf(fp,"%d ",save_x);
        fprintf(fp,"%d ",save_y);

       for(int n=0 ; n<number_of_enemies ; n++)
          enim[n].save_enim(fp);

       powerups.save_all(fp);

       main_layer.save_layer(fp);
       layer2.save_layer(fp);

       fclose(fp);
       }
     else if(key[KEY_L])
       loader();
     }

void loader(void)
	{
     layer=1;

     clear_keybuf();
     char file_name[100]="";
     dialogf("Filename",ALIGN_CENTRE,ALIGN_CENTRE,200,
             "Please choose a file to load%line[]"
             "Map%filename[98,map,Load a map]",
             file_name);

     //checks to see if '.map' already exists in the filename
     if(strstr(file_name,".map")==NULL)
      	strcat(file_name,".map"); //if it doesn't, then it adds it

     FILE *fp;
     fp=fopen(file_name,"r");

     fscanf(fp,"%d",&number_of_enemies);

     fscanf(fp,"%d",&save_x);
     fscanf(fp,"%d",&save_y);

     for(int n=0 ; n<number_of_enemies ; n++)
        {
          enim[n].load_emim(fp);
          
                    gun[enim[n].get_wep_no()].set_ammo(-1);
          enim[n].add_gun(gun[enim[n].get_wep_no()]);

          enim[n].set_pic(enim_pics[enim[n].pic_num],enim[n].pic_num);

          //enim[n].exist=1;
         }
     powerups.load_all(fp);

     main_layer.load_layer(fp); //loads map
     layer2.load_layer(fp); //loads map

     fclose(fp);

     for(int n=0 ; n<number_of_enemies ; n++)
        {
         enim[n].set_pic(enim_pics[enim[n].pic_num],enim[n].pic_num);
        }

     for(int n=0; n<200 ; n++)
        {
         if(powerups.get_exist(n)==1)
         powerups.create_from(powerups_defined.ret_pickup(powerups.get_type(n)),
                      powerups.get_x(n),powerups.get_y(n));
        }

     for(int x=0;x<200;x++)//goes through map
        for(int y=0 ; y<200 ; y++)
           {
            main_layer.load_tile(tile1[main_layer.get_tile_no(x,y)-1],x,y);//set it to the proper picture
            layer2.load_tile(tile1[layer2.get_tile_no(x,y)-1],x,y);//set it to the proper picture
           }
   }

void draw_all(void)
	{
     draw_tiles();
     draw_enims();
     powerups.draw_all(backgr,s_x,s_y);
   //  textprintf(backgr,font,300,300,100,"%d",number_of_enemies);

  //   textprintf(backgr,font,300,310,100,"%0.0f",enim[0].exist);
    }

void draw_enims(void)
	{
     for(int n=0 ; n < number_of_enemies ; n++)
        {
        if(enim[n].exist==1)
           {
     		enim[n].draw(backgr, s_x, s_y);
            enim[n].draw_box(backgr,s_x,s_y,gun);
        	}
     	}
	}

void draw_tiles(void)
	{
     main_layer.draw_layer(backgr,walk,0,0,s_x,s_y,0,0); //draw the map layer
     layer2.draw_layer(backgr,walk,0,0,s_x,s_y,0,0); //draw the map layer

     tile1[tile_selection].draw_trans(backgr,t_x-s_x,t_y-s_y);
     rect(backgr,t_x-s_x , t_y-s_y , t_x-s_x+tile_w , t_y-s_y+tile_h, 133);

     if(mode==3)
       {
        powerups_defined.draw_at(backgr,mouse_x,mouse_y,powerup_number);
        }

     rectfill(backgr,0,0,640,80,0);
     rect(backgr,0,0,639,80,136);

    }

void define_weapons(void)
	{
     //temp pictures before I can get some drawn/////////
     BITMAP *rect;
     rect=create_bitmap(5,20);
     rectfill(rect,0,0,5,20,20);

     //this set stores info for how a projectile will act
     gun_part[1].max_speed=12;
     gun_part[1].accel=1;
     gun_part[1].damage=7;
     gun_part[1].pic=(BITMAP*)data[bullet2].dat;
     gun_part[1].cool=3;
     gun_part[1].recoil=.25;
     gun_part[1].ammo_type=0;
     gun_part[1].shell_pic=(BITMAP*)data[shell].dat;
     gun_part[1].sound = (SAMPLE*)data[shot1].dat;

     //this creates a gun with rect as it's picture, and the above atts for it's
     //projectiles
     gun[1].init(rect,gun_part[1],15,15,"Machine Gun");

     //this set stores info for how a projectile will act
     gun_part[2].max_speed=12;
     gun_part[2].accel=1;
     gun_part[2].damage=35;
     gun_part[2].pic=(BITMAP*)data[bullet1].dat;
     gun_part[2].cool=30;
     gun_part[2].recoil=4;
     gun_part[2].ammo_type=0;
     gun_part[2].shell_pic=(BITMAP*)data[shell].dat;
     gun_part[2].sound = (SAMPLE*)data[shotgun_sound].dat;

     //this creates a gun with rect as it's picture, and the above atts for it's
     //projectiles
     gun[2].init(rect,gun_part[2],15,15,"Shot Gun");

     gun[3].init(rect,gun_part[2],15,15,"Grenades");

     gun_part[0].max_speed=12;
     gun_part[0].accel=1;
     gun_part[0].damage=15;
     gun_part[0].pic=(BITMAP*)data[bullet2].dat;
     gun_part[0].cool=15;
     gun_part[0].recoil=1;
     gun_part[0].ammo_type=0;
     gun_part[0].shell_pic=(BITMAP*)data[shell].dat;
     gun_part[0].sound = (SAMPLE*)data[shot1].dat;
     gun[0].init(rect,gun_part[0],15,15,"Standard Gun");
	}

void define_powerups(void)
	{
     powerups_defined.create_new(0,0,(BITMAP*)data[machine_pickup].dat,1,(SAMPLE*)data[reload].dat,1); //machine gun
     powerups_defined.create_new(0,0,(BITMAP*)data[shot_pickup].dat,2,(SAMPLE*)data[reload].dat,2); //shot gun
     powerups_defined.create_new(0,0,(BITMAP*)data[grenade_pickup].dat,3,(SAMPLE*)data[reload].dat,3); //grenade

     powerups_defined.create_new(0,0,(BITMAP*)data[medkit_pic].dat,10,(SAMPLE*)data[medkit_sound].dat,10);
     powerups_defined.create_new(0,0,(BITMAP*)data[disk1].dat,11,(SAMPLE*)data[medkit_sound].dat,11);
     powerups_defined.create_new(0,0,(BITMAP*)data[crystal1].dat,12,(SAMPLE*)data[medkit_sound].dat,12);
     powerups_defined.create_new(0,0,(BITMAP*)data[crystal_r1].dat,13,(SAMPLE*)data[medkit_sound].dat,13);
     powerups_defined.create_new(0,0,(BITMAP*)data[crystal_g1].dat,14,(SAMPLE*)data[medkit_sound].dat,14);

    }

void set_range_change(void)
	{
      if(selected!=-1)
       {
        if(mouse_x+s_x == enim[selected].ret_lx())
          {
          cc=90;
          if(mouse_b==1)
          	set_range=1;
          }
        else if(mouse_x+s_x == enim[selected].ret_rx())
          {
          cc=90;
          if(mouse_b==1)
          	set_range=2;
          }
       }

      if(mouse_b!=1)
        set_range=0;
    }

void edit_enim(void)
	{
     clear_keybuf();
     int list_index1=0;
     int list_index2=0;
     int life=enim[selected].ret_life();

     list_index1=enim[selected].ret_weapon();
     if(enim[selected].ret_holding()!=-1)
       list_index2=enim[selected].ret_holding();

     dialogf("Edit enim",ALIGN_CENTRE,ALIGN_CENTRE,130,
             "%dialogf[Set Health]"
             "%dialogf[Set Gun]"
             "%dialogf[Set Item]",

             	"Please set the enemy's life",ALIGN_CENTRE,ALIGN_CENTRE,100,
                "%int[0,300]",
                 &life,

                "Please select a weapon",ALIGN_CENTRE,ALIGN_CENTRE,200,
                "%list[,Standard Gun ;Machine Gun ;Shot Gun ;Grenades",
                 &list_index1,

                "Please select an item",ALIGN_CENTRE,ALIGN_CENTRE,200,
                "%list[,Nothing ;Machine Ammo ;Shot Ammo ;Grenade Ammo ;3 ;4 ;5 ;6 ;7 ;8 ;Health ;Key ;Blue Crystal ;Red Crystal ;Green Crystal]",
                 &list_index2
	         );

     enim[selected].set_life(life);
     enim[selected].set_weapon(list_index1);
     enim[selected].set_holding(list_index2);
    }


