class pickup
	{
     private:
     	float x,y;
     	int type;
        SAMPLE *pickup_sound;
        int animated;

	 public:

        BITMAP *pic;
        CAnim *anim;

        int exist;
        int selected;
     	void init(void);

        //two create functions, one for creating a pickup with a static bitmap
        //one for creating a pickup with an animation
        void create(float xx, float yy, BITMAP *ppic, int ttype, SAMPLE *ppickup);
        void create(float xx, float yy, CAnim *aanim, int ttype, SAMPLE *ppickup);
      

        void draw(BITMAP *backgr, float s_x, float s_y);
        void draw_at(BITMAP *backgr, float xx, float yy);

        int collide(person *p, wdisplay *display);
        int pick_it_up(person *p, wdisplay *display);
        void save_pickup(FILE *fp);
        void load_pickup(FILE *fp);
        int ret_type(void);
        float ret_x(void);
        float ret_y(void);

        void move(float xx, float yy);
	};

void pickup::move(float xx, float yy)
	{
     x=xx;
     y=yy;
    }

int pickup::ret_type(void)
	{
     return type;
    }

float pickup::ret_x(void)
	{
     return x;
    }

float pickup::ret_y(void)
	{
     return y;
    }

void pickup::save_pickup(FILE *fp)
	{
     fprintf(fp,"%d ",(int)x);
     fprintf(fp,"%d ",(int)y);
     fprintf(fp,"%d ",type);
     fprintf(fp,"%d ",exist);
    }

void pickup::load_pickup(FILE *fp)
	{
     int xx,yy;

     fscanf(fp,"%d",&xx);
     fscanf(fp,"%d",&yy);
     fscanf(fp,"%d",&type);
     fscanf(fp,"%d",&exist);

     x=(float)xx;
     y=(float)yy;
    }

int pickup::pick_it_up(person *p, wdisplay *display)
	{
     int ret=0;
     if (type==1)  //machine_gun
       {
        //increase ammo by 100
        p->gun[2].set_ammo(p->gun[2].send_ammo()+100);
        exist=0;
        ret=1;
        display->set_message("Machine Gun Ammo",320,490,0,-7);
       }
     else if(type==2) //shot gun
       {
        //increase ammo by 20
        p->gun[3].set_ammo(p->gun[3].send_ammo()+10);
        exist=0;
        ret=1;
        display->set_message("Shot Gun Ammo",320,490,0,-7);
       }
     else if(type==3) //grenade
       {
        p->gun[4].set_ammo(p->gun[4].send_ammo()+5);
        exist=0;
        ret=1;
        display->set_message("Grenade Ammo",320,490,0,-7);
       }

     else if(type==10) //life
       {
        //life goes up by 70;
        p->life_up(70);
        exist=0;
        ret=1;
        display->set_message("Medkit",320,490,0,-7);
       }
     else if(type==11) //key
       {
        p->up_keys();
        exist=0;
        ret=1;
        display->set_message("Crystal Key",320,490,0,-7);
       }

     else if(type==12 && p->ret_keys()>0 && exist==1)   //blue crystal
       //if player has enough keys
       {
        //loose a key
        p->down_keys();
        exist=0;
        //ret=2 is when a level beating crystal is picked up
        ret=2;
        display->set_message("Blue Crystal",320,490,0,-7);
        }
     else if(type==13 && p->ret_keys()>1 && exist==1)   //red crystal
       //if player has enough keys
       {
        //loose 2 keys
        p->down_keys();
        p->down_keys();
        exist=0;
        ret=2;
        display->set_message("Red Crystal",320,490,0,-7);
        }
     else if(type==14 && p->ret_keys()>2 && exist==1)   //green crystal
       //if player has enough keys
       {
        //loose 3 keys
        p->down_keys();
        p->down_keys();
        p->down_keys();
        exist=0;
        ret=2;
        display->set_message("Green Crystal",320,490,0,-7);
        }

     if(ret==1 || ret==2)
     	play_sample(pickup_sound,255,128,1000,FALSE);


     return ret;
     }


int pickup::collide(person *p, wdisplay *display)
	{
     int ret=0;
     //ret of 0 means nothing was picked up

     if(exist==1)  //if the pickup exists
       {
        //create a temp picture to use in the collision detection
        BITMAP *temp_pic;

     	if(animated==0)
           //if it is not animated, use the static picture
       	   temp_pic=pic;
     	else if(animated==1)
           //if it is animated, use the current frame from the anim
       	   temp_pic=anim->ret_frame();

        //check to see if the powerup is in contact with the person passed
        //to it
     	if(check_pp_collision(temp_pic, p->ret_pic() ,(int)x,(int)y,
        	(int)p->ret_x(), (int)p->ret_y()))
       	    {
             //run the function to pick it up
             ret=pick_it_up(p,display);
            }
        else
            ret=0;

       }
    else
       {
        ret=0;
       }
      return ret;
     }

void pickup::init(void)
	{
     exist=0;
     x=0;
     y=0;
     type=0;
     selected=0;
     animated=0;
    }

void pickup::create(float xx, float yy, BITMAP *ppic, int ttype, SAMPLE *ppickup)
	{
     x=xx;
     y=yy;
     pic=ppic;
     type=ttype;
     exist=1;
     pickup_sound=ppickup;
     animated=0;
    }

void pickup::create(float xx, float yy, CAnim *aanim, int ttype, SAMPLE *ppickup)
	{
     x=xx;
     y=yy;
     anim=aanim;
     type=ttype;
     exist=1;
     pickup_sound=ppickup;
     animated=1;
    }

void pickup::draw(BITMAP *backgr, float s_x, float s_y)
	{
     if(exist==1)
       {
        if(animated==0)
     	   draw_sprite(backgr,pic,(int)x-(int)s_x, (int)y-(int)s_y);
        else if(animated==1)
           anim->draw_anim(backgr,(int)x-(int)s_x, (int)y-(int)s_y,1,1,5);

        if(selected==1)
          rect(backgr,
               (int)x-(int)s_x,
               (int)y-(int)s_y,
               (int)x-(int)s_x+pic->w,
               (int)y-(int)s_y+pic->h,
               109);
        //textprintf(backgr,font,0,100,10,"%f %f %d %d",x,y,type,exist);
       }
     }

void pickup::draw_at(BITMAP *backgr, float xx, float yy)
	{
     if(exist==1)
       {
     	draw_sprite(backgr,pic,(int)xx, (int)yy);
        //textprintf(backgr,font,0,100,10,"%f %f %d %d",x,y,type,exist);
       }
     }

class pickup_set
	{
     private:
     	pickup pick[60];  //an array of 60 different pickups
     	int next;         //the number of the next unused pickup
     public:
     	void init(void);

        //creates a new pickup using a static pitcure
        //creates it at the end of the array
        void create_new(float x, float y, BITMAP *pic, int type, SAMPLE *pickup_sound);
        //creates it in the 'n'th spot in the array
        void create_new(float x, float y, BITMAP *pic, int type, SAMPLE *pickup_sound, int n);

        //creates a bew pickup using an animation for the picture
        void create_new(float x, float y, CAnim *anim, int type, SAMPLE *pickup_sound);
        void create_new(float x, float y, CAnim *anim, int type, SAMPLE *pickup_sound, int n);
     
        //draws all the pickups relative to s_x,s_y
        void draw_all(BITMAP *backgr, float s_x, float s_y);
        //draws pickup n at xx,yy on the screen
        void draw_at(BITMAP *backgr, float xx, float yy, int n);
        //removes the pickup at 'number'
        void remove(int number);
        //check for collision of all pickups with player 'p'
        //it passes it a pointer to the wdisplay 'display' so that
        //a message can be written to tell the player what was picked up
        void collide_all(person *p, wdisplay *display);
        //check for collision of all pickups with the bitmap 'pic'
        int collide_with_bmp(BITMAP *pic, float xx, float yy);
        void save_all(FILE *fp);
        void load_all(FILE *fp);

        //returns the pickup n's info
        int get_type(int n);
        float get_x(int n);
        float get_y(int n);
        pickup ret_pickup(int n);
        int get_exist(int n);

        void move(float xx, float yy, int n); //move pickup n to xx,yy

        void create_from(pickup p, float xx, float yy);


        void toggle_selected(int n);
        void deselect_all(void);
	};

void pickup_set::deselect_all(void)
	{
     for(int n=0 ; n<60 ; n++)
        {
         pick[n].selected=0;
        }
    }


void pickup_set::toggle_selected(int n)
	{
     deselect_all();
     if(pick[n].selected==1)
       pick[n].selected=0;
     else if(pick[n].selected==0)
       pick[n].selected=1;
    }

int pickup_set::collide_with_bmp(BITMAP *pic, float xx, float yy)
	{
     int ret=-1;
     for(int n=0 ; n<60 ; n++)
        {
         if(pick[n].exist==1)
           {
            if(check_col(pick[n].pic,pic,pick[n].ret_x(),pick[n].ret_y(),xx,yy)==1)
              {
               //they are touching
               ret=n;
               break;
              }
            }
         }
       return ret;
      }

//creates a new powerup from the powerup passed to it
void pickup_set::create_from(pickup p, float xx, float yy)
	{
     pick[next]=p; //the next powerup created from the one passed to it

     //it then moves it to the desired position
     pick[next].move(xx,yy);
     next++;
     if(next>68)
       next=0;
    }

int pickup_set::get_exist(int n)
	{
     return pick[n].exist;
    }

void pickup_set::move(float xx, float yy, int n)
	{
     pick[n].move(xx,yy);
    }

pickup pickup_set::ret_pickup(int n)
	{
     return pick[n];
    }

int pickup_set::get_type(int n)
	{
     return pick[n].ret_type();
    }

float pickup_set::get_x(int n)
	{
     return pick[n].ret_x();
    }

float pickup_set::get_y(int n)
	{
     return pick[n].ret_y();
    }

void pickup_set::save_all(FILE *fp)
	{
     //fprintf(fp,"%d ",next);
     for(int n=0 ; n<60 ; n++)
        {
         pick[n].save_pickup(fp);
        }
     }

void pickup_set::load_all(FILE *fp)
	{
     for(int n=0 ; n<60 ; n++)
        {
         pick[n].load_pickup(fp);
        }
     }

void pickup_set::collide_all(person *p, wdisplay *display)
	{
     int ret=0;
     for (int n=0; n<60 ; n++)
      	{
         ret=pick[n].collide(p,display);
         if(ret==1)
           {
            //picked it up
           }
         else if(ret==2)
           {
            //beat the level
            p->next_level();
           }
        }
    }

void pickup_set::init(void)
	{
     next=0;
     for (int n=0; n<60 ; n++)
        pick[n].init();
    }

void pickup_set::create_new(float x, float y, BITMAP*pic, int type, SAMPLE *pickup_sound)
	{
     pick[next].create(x,y,pic,type, pickup_sound);

     next++;
     if(next>58)
       next=0;
	}

void pickup_set::create_new(float x, float y, BITMAP*pic, int type, SAMPLE *pickup_sound, int n)
	{
     pick[n].create(x,y,pic,type, pickup_sound);
	}

void pickup_set::create_new(float x, float y, CAnim *anim, int type, SAMPLE *pickup_sound)
	{
     pick[next].create(x,y,anim,type, pickup_sound);

     next++;
     if(next>58)
       next=0;
	}

void pickup_set::create_new(float x, float y, CAnim *anim, int type, SAMPLE *pickup_sound, int n)
	{
     pick[n].create(x,y,anim,type, pickup_sound);
	}

void pickup_set::draw_all(BITMAP *backgr, float s_x, float s_y)
	{
     for (int n=0; n<60 ; n++)
      	{
         pick[n].draw(backgr,s_x,s_y);
        }
     }

void pickup_set::draw_at(BITMAP *backgr, float xx, float yy, int n)
	{
     pick[n].draw_at(backgr,xx,yy);
    }

void pickup_set::remove(int number)
	{
     for(int n=number ; n<59 ; n++)
        {
         pick[n]=pick[n+1];
        }
     next--;
     }




