#include "toggle.h"


TOGGLE::TOGGLE()
{
	init();
}

TOGGLE::~TOGGLE()
{

}

void TOGGLE::init()
{
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	bImage = NULL;
	up_or_down = false;  
	moving_up = false;
	water_float = 0;
	water_time = 0;
	toggle_timer = 0;
	visible = false;
	lock = false;
/*	bType[0] = NULL;
	bType[1] = NULL;
	bType[2] = NULL;*/
	bTransfer = NULL;
	rType = 0;
	rUpdate = 0;
	rCount = 0;

	iIntensity = 0;
	bFlash_Dir = false;
	flash_timer = 0;

	bToggle_Animate = false;
	bToggle_Animate_Direction = false;
    toggle_animate_timer = 0;
	iTransparency = 0;
}


void TOGGLE::setup(games gCurrent_Game, int X, int Y, int W, int H, bool bVisible, int iDifficulty)
{
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bTransfer != NULL) destroy_bitmap(bTransfer);

	bImage = create_bitmap_check(W, H);	
	bTransfer = create_bitmap_check(W + (WATER_SHIFT * 2), H  + (WATER_SHIFT * 2));

	x = X;
	y = Y;
	w = W;
	h = H;
	up_or_down = true;
	
	visible = true;
	bToggle_Animate = true;	
		
	if(bVisible)
	{
		bToggle_Animate_Direction = false;
		iTransparency = 0;
	}
	else
	{
		iTransparency = 255;
		bToggle_Animate_Direction = true;
	}
		

	bFlash_Dir = true;
	iIntensity = rand() % 250;
    
	water_float = (rand() % WATER_SHIFT + 1) - (rand() % WATER_SHIFT + 1);
	water_time = rand() % (TIMER_WATER_SHIFT + 35);
	if(rand() % 100 > 50)
		moving_up = true;
	else moving_up = false;
	difficulty = iDifficulty;

	choose_type(gCurrent_Game);
	
	update_image();
}




void TOGGLE::update_image()
{
	if(type == 1)
		rectfill(bImage, 0, 0, bImage->w, bImage->h, makecol(0, iIntensity, 0));
	if(type == 2)
		rectfill(bImage, 0, 0, bImage->w, bImage->h, makecol(iIntensity, 0, 0));
	if(bToggle_Animate_Direction == true)
		rectfill(bImage, 0, 0, bImage->w, bImage->h, BLACK);
	if(type < 4)
		GAME.bBoard->draw_type(bImage, type - 1);
		//stretch_sprite(bImage, bType[type - 1], 0, 0, bImage->w, bImage->h);
	else
		GAME.bBoard->draw_type(bImage, rType);
		//stretch_sprite(bImage, bType[rType], 0, 0, bImage->w, bImage->h);

	
}

void TOGGLE::choose_type(games gCurrent_Game)
{
	float fTemp;
	type = 1;

	gCurrent_Game.bBoard->generate_bonus(difficulty, x, y);

	if(difficulty < 6) 
		return;
		
	if(difficulty >= 6)
	{
		fTemp = ((float(difficulty) / 100.0) - 0.05) / 2.0;
		if(fTemp > 0.1) fTemp = 0.1;
		if(rand() % 100 < 100 * fTemp)
			type = 2;
	}
	if(difficulty >= 8)
	{
		fTemp = ((float(difficulty) / 100.0) - 0.07) / 2.0;
		if(fTemp > 0.15) fTemp = 0.15;
		if(rand() % 100 < 100 * fTemp)
			type = 4;
	}
	if(difficulty >= 10)
	{
		fTemp = ((float(difficulty) / 100.0) - 0.09) / 2.0;
		if(fTemp > 0.08) fTemp = 0.08;
		if(rand() % 100 < 100 * fTemp)
			type = 3;
	}
}

void TOGGLE::destroy()
{
	if(bImage != NULL) {destroy_bitmap(bImage); bImage = NULL;}
	if(bTransfer != NULL) {destroy_bitmap(bTransfer); bTransfer = NULL;}	
}

void TOGGLE::update(games gCurrent_Game, int mx, int my)
{	
	float_on_water(gCurrent_Game);
	random_type();
	toggle(gCurrent_Game, mx, my);	
	flash_animate();
	toggle_animate(gCurrent_Game);	
}

void TOGGLE::toggle_animate(games gCurrent_Game)
{
	float convert_x = float(GAME.wToggles_Water->iWidth) / 365.0;
	float convert_y = float(GAME.wToggles_Water->iHeight) / 365.0;

	if(bToggle_Animate)
	{
		if(abs(ticks - toggle_animate_timer) > 5)
		{
			if(!bToggle_Animate_Direction)
			{
				iTransparency += 51;
				water_float--;
				if(water_float <= (WATER_SHIFT * -1)) water_float++;
				if(iTransparency >= 255)
				{					
					iTransparency = 255;
					bToggle_Animate = false;
				}
			}
			else
			{
				iTransparency -= 51;
				water_float++;
				if(iTransparency <= 0)
				{
					iTransparency = 0;
					bToggle_Animate = false;
					visible = false;
					gCurrent_Game.wToggles_Water->submerge(bImage, int(x * convert_x), int((y + 5) * convert_y), int(bImage->w * convert_x), int(bImage->h * convert_y));
				}
			}
			toggle_animate_timer = ticks;
		}
	}

}

void TOGGLE::flash_animate()
{
	if(abs(ticks - flash_timer) > 2)
	{
		if(bFlash_Dir)
		{
			iIntensity += 10;
			if(iIntensity >= 255) 
			{
				iIntensity = 255;
				bFlash_Dir = false;
			}
		}
		else
		{
			iIntensity -= 10;
			if(iIntensity <= 85) 
			{
				iIntensity = 85;
				bFlash_Dir = true;
			}
		}
		flash_timer = ticks;
	}
}


void TOGGLE::random_type()
{
	if(type != 4) return;

	if(abs(ticks - rUpdate) > 5)
	{
		rType++;
		if(rType > 2) rType = 0;
		rUpdate = ticks;
		rCount++;
		if(rCount >= 50 + (rand() % 2) ) type = rType + 1;
	}
}


void TOGGLE::float_on_water(games gCurrent_Game)
{
	if(abs(ticks - water_time) > TIMER_WATER_SHIFT)
	{
		if(visible)
		{
			if(moving_up)
			{
				water_float--;
				if(water_float <= (WATER_SHIFT * -1)) moving_up = false;
			}
			else
			{
				water_float++;
				if(water_float >= WATER_SHIFT) 
				{
					moving_up = true;
					ripple_water(gCurrent_Game.wToggles_Water);
				}
			}
		}

		water_time = ticks;
	}

}

void TOGGLE::draw(BITMAP *bDisplay)
{
	if(visible == true)
	{
		update_image();
		rectfill(bTransfer, 0, 0, bTransfer->w, bTransfer->h, MASK);
		stretch_sprite(bTransfer, bImage, WATER_SHIFT + water_float, WATER_SHIFT + water_float, bImage->w - water_float * 2, bImage->h - water_float * 2);
		set_trans_blender(0,0,0, iTransparency);
		draw_trans_sprite(bDisplay, bTransfer, x, y);	
	}
}

bool TOGGLE::is_visible()
{
	return visible;
}

void TOGGLE::toggle(games gCurrent_Game, int mx, int my)
{
	//float convert_x = float(GAME.wToggles_Water->iWidth) / 365.0;
	//float convert_y = float(GAME.wToggles_Water->iHeight) / 365.0;
	//if(mx > WATER_SHIFT + x - water_float && mx < x + w + WATER_SHIFT - (water_float * 4)
	//	&& my > WATER_SHIFT + y + water_float && my < y + h + WATER_SHIFT - (water_float * 4))
	if(mouse_over(mx,my))
	{
		if(lock == false)
		{
			if(visible) 
			{
				if(type != 3)
				{
					gCurrent_Game.audio.play_sfx(7);					
					gCurrent_Game.bBoard->iConsecutive++;
					if(gCurrent_Game.bBoard->iConsecutive == 1)
						gCurrent_Game.bBoard->Combo_Timer = ticks;
					combos(gCurrent_Game, mx, my);
				}
				/* Type 1 is the only time you have a successful toggle when visible,
				or you can force toggle through toggle_down function */
				if(type == 1)
				{						
					//visible = false;										
					bToggle_Animate = true;
					bToggle_Animate_Direction = true;
				}
				else if(type == 2)				
					
					type = 1;				
				else if(type == 4)
					type = rType + 1;				
				
			}
			else 
			{				
				gCurrent_Game.gScore->subtract(1  + (gCurrent_Game.level / 5));
				gCurrent_Game.bBoard->iConsecutive = 0;
				visible = true;
				choose_type(gCurrent_Game);		
				bToggle_Animate = true;
				bToggle_Animate_Direction = false;
			}
			lock = true;
		}
	}
	else
		lock = false;
}

void TOGGLE::toggle_down(games gCurrent_Game)
{
	//float convert_x = float(GAME.wToggles_Water->iWidth) / 365.0;
	//float convert_y = float(GAME.wToggles_Water->iHeight) / 365.0;
	
	if(visible) 
	{
		//visible = false;
		//gCurrent_Game.wToggles_Water->submerge(bImage, x * convert_x, (y + 5) * convert_y, bImage->w * convert_x, bImage->h * convert_y);
		gCurrent_Game.gScore->add(1 + (gCurrent_Game.level / 5));
		bToggle_Animate = true;
		bToggle_Animate_Direction = true;		
	}
	
}

bool TOGGLE::mouse_over(int mx, int my)
{
	if(mx > WATER_SHIFT + x + water_float - 5 && mx < WATER_SHIFT + x + w + 5 - water_float
		&& my > WATER_SHIFT + y + water_float - 5 && my < WATER_SHIFT + y - water_float + h + 5)
	{
		return true;
	}
    
	return false;
}

void TOGGLE::create_message(char *s)
{
	int m = 0;
	while(m < MAX_MESSAGES && GAME.cMessages[m] != NULL)
		m++;
	if(m >= MAX_MESSAGES) return;

	GAME.cMessages[m] = new MESSAGE(s, 60, mouse_x, mouse_y);
}



void TOGGLE::combos(games gCurrent_Game, int mx, int my)
{
	gCurrent_Game.gScore->add(1 + (gCurrent_Game.level / 5));
	if(gCurrent_Game.bBoard->iConsecutive == FIRST_COMBO && gCurrent_Game.bBoard->bFirst_Combo != true)
	{						
		gCurrent_Game.bBoard->bFirst_Combo = true;		
		gCurrent_Game.gScore->add(10 * gCurrent_Game.level);
		gCurrent_Game.peCombo->explode(10, mx, my, 100, 100, 0.5, 0.28, 5.0, 0.05, 15);					
		GAME.audio.play_sfx(11);	
		create_message("Combo!!!");
	}

	if(gCurrent_Game.bBoard->iConsecutive == SECOND_COMBO && gCurrent_Game.bBoard->bSecond_Combo != true)
	{					
		gCurrent_Game.gScore->add(50 * gCurrent_Game.level);
		gCurrent_Game.bBoard->bSecond_Combo = true;
		gCurrent_Game.peCombo->explode(30, mx, my, 100, 100, 0.5, 0.28, 5.0, 0.08, 15);					
		GAME.audio.play_sfx(12);
		create_message("Combo!!!");
	}

	if(gCurrent_Game.bBoard->iConsecutive == THIRD_COMBO && gCurrent_Game.bBoard->bThird_Combo != true)
	{					
		gCurrent_Game.gScore->add(500 * gCurrent_Game.level);
		gCurrent_Game.bBoard->bThird_Combo = true;
		gCurrent_Game.peCombo->explode(100, mx, my, 100, 100, 0.5, 0.28, 5.0, 0.1, 15);					
		GAME.audio.play_sfx(13);
		create_message("Combo!!!");
	}

	if(gCurrent_Game.bBoard->iConsecutive == FOURTH_COMBO && gCurrent_Game.bBoard->bFourth_Combo != true)
	{					
		gCurrent_Game.gScore->add(1000 * gCurrent_Game.level);
		gCurrent_Game.bBoard->bFourth_Combo = true;
		gCurrent_Game.peCombo->explode(200, mx, my, 100, 100, 0.5, 0.28, 5.0, 0.15, 15);					
		GAME.audio.play_sfx(14);
		create_message("Combo!!!");
	}
}

int TOGGLE::iType()
{
	return type;
}

void TOGGLE::ripple_water(WATER *wToggles_Water)
{
	int wsize = 2000;
	float convert_x = float(GAME.wToggles_Water->iWidth) / 365.0;
	float convert_y = float(GAME.wToggles_Water->iHeight) / 365.0;
	
	wToggles_Water->Drop(int(x * convert_x), int((y + water_float) * convert_y), wsize);
	wToggles_Water->Drop(int((x + w) * convert_x), int((y + water_float) * convert_y), wsize);
	wToggles_Water->Drop(int(x * convert_x), int((y + water_float + h) * convert_y), wsize);
	wToggles_Water->Drop(int((x + w) * convert_x), int((y + water_float + h) * convert_y), wsize);
}

