#include "score.h"
SCORE::SCORE()
{
	init();
}

SCORE::~SCORE()
{
	destroy();
}

void SCORE::add(int iValue)
{
	if(points + iValue <= 9999999)	points += iValue;
}

void SCORE::subtract(int iValue)
{
	if(points - iValue >= 0) points -= iValue;
}

void SCORE::setup(int w, int h)
{
	W = w;
	bText = create_bitmap_check(w, h);
}

void SCORE::update()
{

}

void SCORE::draw()
{
	rectfill(bText, 0, 0, bText->w, bText->h, MASK);
	set_palette((RGB *) GAME.score_palette);
	textprintf_right_ex(bText, GAME.score_font, W - 10, 10, -1, -1, "%d", points);					
}

BITMAP *SCORE::image()
{
	return bText;
}

void SCORE::reset()
{
	points = 0;
}

void SCORE::init()
{
	bText = NULL;
	points = 0;
	W = 0;
}

void SCORE::destroy()
{
	if(bText != NULL) destroy_bitmap(bText);
}

