#include "penalty.h"
#include "data4.h"

int NO_PENALTY = 0;
int TIME_DECREASE = 1 ;
int ROW_INCREASE = 2;
int PERCENT_INCREASE = 3 ;
int TIME_DECREASE_2 = 4 ;
int TIME_DECREASE_4 = 5 ;
int PERCENT_INCREASE_2 = 6;
int PERCENT_INCREASE_3 = 7;
int ROW_INCREASE_2 = 8;
int TIME_INCREASE = 9;
int PERCENT_DECREASE = 10;
int BONUS_PACKAGE = 11;

PENALTY::PENALTY()
{
	init();
}

PENALTY::~PENALTY()
{
	destroy();
}

void PENALTY::setup()
{
	//bImage = load_bitmap_check("./data/images/slot_wheel.pcx", NULL);
	bImage = (BITMAP *) GAME.dat4[SLOT_WHEEL_PCX].dat;
	
	w = bImage->w;
	h = bImage->h;
	pTemp = NO_PENALTY;

	set_item(0, "./data/images/question.pcx", 109, 38, 0, 8);
	set_item(1, "./data/images/question.pcx", 243, 37, 0, 8);
	set_item(2, "./data/images/question.pcx", 347, 169, 0, 8);
	set_item(3, "./data/images/percent_inc.pcx", 250, 320, 0, 8);
	set_item(4, "./data/images/time_dec.pcx", 103, 318, 0, 8);
	set_item(5, "./data/images/row_inc.pcx", 19,  173, 0, 8);	
	
}

void PENALTY::set_item(int iIndex, char *cpath, int X, int Y, int Frames, int Max)
{
	if(bItems[iIndex] != NULL) destroy_bitmap(bItems[iIndex]);
	bItems[iIndex] = load_bitmap_check(cpath, NULL);
	bItems_X[iIndex] = X;
	bItems_Y[iIndex] = Y;
	iFrames_X[iIndex] = Frames;
	iMax_Frames[iIndex] = Max;
}

void PENALTY::set_item(int iIndex, char *cpath, int Frames, int Max)
{
	if(bItems[iIndex] != NULL) destroy_bitmap(bItems[iIndex]);
	bItems[iIndex] = load_bitmap_check(cpath, NULL);
	iFrames_X[iIndex] = Frames;
	iMax_Frames[iIndex] = Max;
}


void PENALTY::destroy()
{	
	if(bItems[0] != NULL) destroy_bitmap(bItems[0]);
	if(bItems[1] != NULL) destroy_bitmap(bItems[1]);
	if(bItems[2] != NULL) destroy_bitmap(bItems[2]);
	if(bItems[3] != NULL) destroy_bitmap(bItems[3]);
}

void PENALTY::update()
{
	poll_mouse();
	input(mouse_x, mouse_y);
	if(abs(ticks - update_timer) > 1)
	{
		update_timer = ticks;

		if(iAnimate != -1)
		{
			istretch_x +=3;
			istretch_y +=3;
			if(istretch_x > 150)
			{
				
				bItems_X[iChosen] = iTemp_X;
				bItems_Y[iChosen] = iTemp_Y;
				istretch_x = 32;
				istretch_y = 32;
				iAnimate = -1;
				//if(iChosen < 3)
				//{
					for(int j = 0; j < 3; j++)
						set_item(j, "./data/images/question.pcx", 0, 8);					
				//}
				iChosen = -1;
				
				
			}
		}
		else
		{
			if(x < dx) x += 20;
			if(x > dx) x -= 20;
			if(y < dy) y += 20;
			if(y > dy) y -= 20;		
		}
		
	}
	if(abs(ticks - animate_timer) > 10)
	{		
		update_animate(mouse_x, mouse_y);
		animate_timer = ticks;
	}
	
	
}

void PENALTY::input(int X, int Y)
{	
	if(lock == true) return;
	if(mouse_b & 1)
		choose(X, Y);	
	
}

void PENALTY::update_animate(int X, int Y)
{
	for(int i = 0; i < MAX_PENALTIES; i++)
	{
		if((X > bItems_X[i] + x && X < bItems_X[i] + 32 + x
			&& Y > bItems_Y[i] + y && Y < bItems_Y[i] + 32 + y) || i == iChosen)
		{
			
			iFrames_X[i]++;
			if(iFrames_X[i] >= iMax_Frames[i]) iFrames_X[i] = 0;	
		}
		else
			iFrames_X[i] = 0;
	}	
}

void PENALTY::draw(BITMAP *bDisplay)
{
	draw_sprite(bDisplay, bImage, x, y);
	for(int i = 0; i < MAX_PENALTIES; i++)
	{
		if(iAnimate == i)
			masked_stretch_blit(bItems[i], bDisplay, iFrames_X[i] * 32, 0, 32, 32, bItems_X[i] - istretch_x, bItems_Y[i] - istretch_y, istretch_x * 2, istretch_y * 2);
		else
			masked_blit(bItems[i], bDisplay, iFrames_X[i] * 32, 0, bItems_X[i] + x, bItems_Y[i] + y, 32, 32);
	}
	
}

void PENALTY::pic_slots()
{
	pItems[0] = pic_random();
	pItems[1] = pic_random();
	pItems[2] = pic_random();
	pItems[3] = PERCENT_INCREASE;
	pItems[4] = TIME_DECREASE;
	pItems[5] = ROW_INCREASE;
}

int PENALTY::pic_random()
{
	int pchance = rand() % 100;

	if(pchance > 90)
		return TIME_DECREASE;
	else if(pchance <= 90 && pchance > 80)
		return TIME_DECREASE_2;
	else if(pchance <= 80 && pchance > 75)
		return TIME_DECREASE_4;		
	else if(pchance <= 75 && pchance > 65)
		return PERCENT_INCREASE;
	else if(pchance <= 65 && pchance > 55)
		return PERCENT_INCREASE_2;
	else if(pchance <= 55 && pchance > 50)
		return PERCENT_INCREASE_3;
	else if(pchance <= 50 && pchance > 40)
		return ROW_INCREASE;
	else if(pchance <= 40 && pchance > 30)
		return ROW_INCREASE_2;
	else if(pchance <= 30 && pchance > 20)
		return BONUS_PACKAGE;
	else if(pchance <= 20 && pchance > 10)
		return TIME_INCREASE;
	else
		return PERCENT_DECREASE;
}

void PENALTY::unlock()
{
	lock = false;
}

void PENALTY::choose(int X, int Y)
{
	int iSlot = -1;
	for(int i = 0; i < MAX_PENALTIES; i++)
	{
		if(X > bItems_X[i] + x && X < bItems_X[i] + 32 + x
			&& Y > bItems_Y[i] + y && Y < bItems_Y[i] + 32 + y)
			iSlot = i;
		
	}
	if(iSlot != -1)
	{		
		pTemp = pItems[iSlot];
		iAnimate = iSlot;
		iTemp_X = bItems_X[iSlot];
		iTemp_Y = bItems_Y[iSlot];
		iChosen = iSlot;
		bItems_X[iSlot] = GAME.configuration->w / 2 - 16;
		bItems_Y[iSlot] = GAME.configuration->h / 2 - 16;		
		lock = true;		
		
		for(int j = 0; j < 3; j++)
		{
			switch(pItems[j])
			{
				case 9: set_item(j, "./data/images/time_inc.pcx", 0, 8); break;
				case 1: set_item(j, "./data/images/time_dec.pcx", 0, 8); break;
				case 4: set_item(j, "./data/images/time_dec_2.pcx", 0, 8); break;
				case 5: set_item(j, "./data/images/time_dec_4.pcx", 0, 8); break;
				case 10: set_item(j, "./data/images/percent_dec.pcx", 0, 8); break;
				case 3: set_item(j, "./data/images/percent_inc.pcx", 0, 8); break;
				case 6: set_item(j, "./data/images/percent_inc_2.pcx", 0, 8); break;
				case 7: set_item(j, "./data/images/percent_inc_3.pcx", 0, 8); break;
				case 2: set_item(j, "./data/images/row_inc.pcx", 0, 8); break;
				case 8: set_item(j, "./data/images/row_inc_2.pcx", 0, 8); break;
				case 11: set_item(j, "./data/images/bonus_package.pcx", 0, 8); break;
				default:  break;
			}			
		}
	}
}

void PENALTY::move(int DX, int DY)
{
	dx = DX;
	dy = DY;
}

void PENALTY::place(int X, int Y)
{
	pic_slots();
	pTemp = NO_PENALTY;
	x = X;
	y = Y;
}

int PENALTY::done()
{
	return pTemp;
}

int PENALTY::position()
{
	return x;
}



void PENALTY::init()
{
	bImage = NULL;
	for(int i = 0 ; i < MAX_PENALTIES; i++)
	{
		pItems[i] = NO_PENALTY;
		iFrames_X[i] = 0;
		iMax_Frames[i] = 0;
		bItems_X[i] = 0;
		bItems_Y[i] = 0;
        bItems[i] = NULL;
	}
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	dx = 0;
	dy = 0;
	update_timer = 0;
	animate_timer = 0;
	istretch_x = 32;
	istretch_y = 32;
	iAnimate = -1;

	iTemp_X = 0;
	iTemp_Y = 0;
	iChosen = -1;
	lock = false;
}

