#include "option.h"
#include <string.h>

OPTION::OPTION()
{
	init();
}

OPTION::~OPTION()
{
	destroy();
}
void OPTION::setup(char *cValue, int MENU, OTYPE oType, int X, int Y, int W, int H, int Value, int gO)
{
	bOption_Image = load_bitmap_check("./data/images/option.pcx", NULL);	

	menu = MENU;
	
	w = W;
	h = H;
	bImage = create_bitmap(w,h);
	bText = create_bitmap(w,h);
	x = X;
	y = Y;
	strcpy(cText, cValue);
	col = DARKGREEN;
	ivalue = Value;
	gravity_timer = 0;
	gdelay = 7;
	set_sky(gO);

	type = oType;
	oFont = GAME.score_font;
	oPalette = GAME.score_palette;	
	
}

void OPTION::set_bar(float X)
{
	if(type != SLIDE_BAR) return;
	if(X > 1.0) X = 1.0;
	if(X < 0.0) X = 0.0;	
	barx = int((w - 20) * X);	
	
}

float OPTION::get_bar()
{
	return float(barx) / float(w - 20);
}

void OPTION::setup(char *cValue, int MENU, int X, int Y, int W, int H, int Value, int gO)
{
	setup(cValue, MENU, NON_STABLE, X, Y, W, H, Value, gO);
}

bool OPTION::is_menu(int i)
{
	if(menu == -1 && i > 6) return true;
	return menu == i;
}

void OPTION::force_submerge()
{
	bAnimate = true;
	bAnimate_Direction = true;
	bAnimate_Lock = true;
}

void OPTION::destroy()
{
	if(bImage != NULL) {destroy_bitmap(bImage);bImage = NULL;}
	if(bPicture != NULL) {destroy_bitmap(bPicture);bPicture = NULL;}	
	if(bText != NULL) {destroy_bitmap(bText);bText = NULL;}
	if(bOption_Image != NULL) {destroy_bitmap(bOption_Image);bOption_Image = NULL;}
	if(bC1 != NULL) {destroy_bitmap(bC1);bC1 = NULL;}
	if(bC2 != NULL) {destroy_bitmap(bC2);bC2 = NULL;}
	if(bC3 != NULL) {destroy_bitmap(bC3);bC3 = NULL;}
	if(bC4 != NULL) {destroy_bitmap(bC4);bC4 = NULL;}
	if(bS1 != NULL) {destroy_bitmap(bS1);bS1 = NULL;}
	if(bS2 != NULL) {destroy_bitmap(bS2);bS2 = NULL;}
	if(bS3 != NULL) {destroy_bitmap(bS3);bS3 = NULL;}
	if(bS4 != NULL) {destroy_bitmap(bS4);bS4 = NULL;}
	if(bM != NULL) {destroy_bitmap(bM);bM = NULL;}
}

void OPTION::update()
{
	//toggle(mouse_x,mouse_y);
	poll_mouse();
	if(static_option)
		highlight();
	else
	{
		float_on_water();
		highlight();
		animate();
		gravity();
		slide_bar();
		slide_vbar();
		update_button();

		if(mouse_b & 2)
			falling = false;

		if(GAME.state == PAUSED)
		{
			if(cIndex == 0 && strcmp(cButton[0], "Main Menu") == 0) 
				change_text();
		}
		else
		{
			if(cIndex == 1  && strcmp(cButton[0], "Main Menu") == 0) 
			{				
				cIndex = 0;
			}
		}

	}
}

void OPTION::highlight_only()
{	
	static_option = true;
	falling = false;
	bAnimate_Lock = false;
	draw_border = false;
}

void OPTION::slide_vbar()
{
	if(type != MULTI_LINE) return;
	if(mouse_x > x + w - 30 && mouse_x < x + w - 20
		&& mouse_y > y + bary && mouse_y < y + bary + barh)
	{
		bar_mouse_hover = true;
		if(mouse_b & 1) bar_focus = true;
	}
	else
		if(!bar_focus) bar_mouse_hover = false;

	if(bar_focus && !(mouse_b & 1))	bar_focus = false;
	
	if(bar_focus)
	{
		bary = mouse_y - y;
		if(bary < 0) bary = 0;
		if(bary > h - barh) bary = h - barh;
	}

}

void OPTION::slide_bar()
{
	if(type != SLIDE_BAR) return;
	if(mouse_x > x + barx + 5 && mouse_x < x + barx + 15
		&& mouse_y > y + (h/2 - 5) && mouse_y < y + (h/2 + 5))
	{
		bar_mouse_hover = true;
		if(mouse_b & 1)	bar_focus = true;
	}
	else
		if(!bar_focus) bar_mouse_hover = false;


	if(bar_focus && !(mouse_b & 1))	bar_focus = false;
	
	if(bar_focus)
	{
		barx = mouse_x - x;
		if(barx < 0) barx = 0;
		if(barx > w - 20) barx = w - 20;
	}
}



void OPTION::gravity()
{
	if(!falling || static_option) return;
	if(abs(ticks - gravity_timer) > gdelay + gOffset)
	{
		tx += cx;
		ty = (m * tx) + tb;
		steps--;
		sp = (sm * steps) + 1.0;
		sw = w * sp;
		sh = h * sp;
		gOffset = 0;
		gvisible = true;
		if(gdelay > 2) gdelay--;

		if(steps == 0) falling = false;
		gravity_timer = ticks;
	}
}

void OPTION::set_sky(int gO)
{
	if(static_option) return;
	drop();
	sw = 640.0;
	sh = (sw / w) * h;
	sp = (sw / w);
	sm = (sp - 1.0) / float(MAX_GSTEPS);
	tx = 0.0;
	ty = 240.0 - float(sh / 2);
	tb = ty;
	m = (float(y) - ty) / float(x);
	//m = (float(y) - tb) / (float(x) + 100.0);
	steps = MAX_GSTEPS;
	gOffset = gO;
	gvisible = false;
	gravity_timer = ticks;
	visible = true;
	
	cx = float(x) / float(steps);
	bAnimate = true;
	bAnimate_Direction = false;
	iTransparency = 0;

	bAnimate_Lock = false;
}

void OPTION::float_on_water()
{
	if(falling || static_option) return;
	if(abs(ticks - water_time) > 15)
	{
			if(water_direction)
			{
				water_float--;
				if(water_float <= (1 * -1)) water_direction = false;
			}
			else
			{
				water_float++;
				if(water_float >= 2) 
				{
					water_direction = true;
					if(visible) ripple_water();
				}
			}
		water_time = ticks;
	}

}

void OPTION::ripple_water()
{
	int wsize = 50000;
	float convert_x = float(GAME.MainMenu->wWater->iWidth) / 540.0;
	float convert_y = float(GAME.MainMenu->wWater->iHeight) / 350.0;

	GAME.MainMenu->wWater->Drop(int(x * convert_x - 20), int(y * convert_y - 55), wsize);
	GAME.MainMenu->wWater->Drop(int((x+w) * convert_x - 20), int(y * convert_y - 55), wsize);
	GAME.MainMenu->wWater->Drop(int(x * convert_x - 20), int((y+h) * convert_y - 55), wsize);
	GAME.MainMenu->wWater->Drop(int((x+w) * convert_x - 20), int((y+h) * convert_y - 55), wsize);
}

void OPTION::set_color(int r, int g, int b)
{
	ir = r;
	ig = g;
	ib = b;
}


void OPTION::draw_back_color()
{
	int iSeg_Count = GAME.configuration->segments;
	int iR = ir, iG = ig, iB = ib;
	int shade = GAME.configuration->shade;
	if(strcmp(GAME.configuration->level, "MEDIUM") == 0) iSeg_Count = 50;
	if(strcmp(GAME.configuration->level, "LOW") == 0) iSeg_Count = 5;
	for(int i = 0; i < iSeg_Count; i++)
	{
		rectfill(bImage, 0, int(bImage->h * (float(i) / float(iSeg_Count))), bImage->w, int(bImage->h * (float(i + 1) / float(iSeg_Count))), rgb(iR, iG, iB));
		iR -= shade; if(iR < 0) iR = 0;		if(iR > 255) iR = 255;
		iG -= shade; if(iG < 0) iG = 0;		if(iG > 255) iG = 255;
		iB -= shade; if(iB < 0) iB = 0;		if(iB > 255) iB = 255;		
	}
}


void OPTION::draw(BITMAP *bDisplay, BITMAP *bTransfer)
{
	float convert_x = float(GAME.MainMenu->wWater->iWidth) / 540.0;
	float convert_y = float(GAME.MainMenu->wWater->iHeight) / 350.0;
	
	rectfill(bTransfer, 0, 0, bTransfer->w, bTransfer->h, MASK);	
	set_palette((RGB *) oPalette);	
	
	//rectfill(bImage, 0, 0, bImage->w, bImage->h, col);	
	if(col == DARKGREEN)
		set_color(GAME.configuration->R, GAME.configuration->G, GAME.configuration->B);
	else
		set_color(180, 0, 0);
	draw_back_color();
	if(type == MULTI_LINE)
	{		
		if(GAME.view_online)
			GAME.gHSC->draw_online(bImage, int((vlength * ( float(bary) /float(h))) * -1), 30);
		else
			GAME.gHSC->draw(bImage,int((vlength * ( float(bary) /float(h))) * -1), 30);

		//line(bImage, 10, h / 2 - 1, w - 10, h / 2 - 1, BLACK);
		//line(bImage, 8, h / 2, w - 8, h / 2, GREY);
		//line(bImage, 10, h / 2 + 1, w - 10, h / 2 + 1, DARKGREY);
		rectfill(bImage, w - 30, 5, w - 20, h - 5, DARKSLATEGREY);
		rect(bImage, w - 30, 5, w - 20, h - 5, GREY);

		if(bar_mouse_hover || bar_focus)
			rectfill(bImage, w - 30, bary, w - 20, bary + barh, rgb(0,100,255));
		else
			rectfill(bImage, w - 30, bary, w - 20, bary + barh, rgb(200,200,200));
		rect(bImage, w - 30, bary, w - 20, bary + barh, rgb(180,180,180));
		rect(bImage, w - 29, bary, w - 21, bary + barh, rgb(160,160,160));
		
	}

	if(bPicture != NULL)
		//draw_sprite(bImage, bPicture, (bImage->w / 2) - (bPicture->w / 2), (bImage->h / 2) - (bPicture->h / 2));
		stretch_sprite(bImage, bPicture, 10, 10, bImage->w - 20, bImage->h - 20);


	masked_blit(bOption_Image, bImage, 0, 0, 0, 0, 20, 20);
	masked_blit(bOption_Image, bImage, 40, 0, bImage->w - 20, 0, 20, 20);
	masked_blit(bOption_Image, bImage, 0, 40, 0, bImage->h - 20, 20, 20);
	masked_blit(bOption_Image, bImage, 40, 40, bImage->w - 20, bImage->h - 20, 20, 20);

	masked_stretch_blit(bOption_Image, bImage, 20, 0, 20, 20, 20, 0, bImage->w - 40, 20);
	masked_stretch_blit(bOption_Image, bImage, 0, 20, 20, 20, 0, 20, 20, bImage->h - 40);
	masked_stretch_blit(bOption_Image, bImage, 40, 20, 20, 20, bImage->w - 20, 20, 20, bImage->h - 40);
	masked_stretch_blit(bOption_Image, bImage, 20, 40, 20, 20, 20, bImage->h - 20, bImage->w - 40, 20);
	
	masked_stretch_blit(bOption_Image, bImage, 20, 20, 20, 20, 20, 20, bImage->w - 20, bImage->h - 20);


	rectfill(bText, 0, 0, bText->w, bText->h, MASK);
	if(type != BUTTON)
	{
		if(wrap)
			wrap_text();
		else
		{
			
			if(alignment == 0)
				textprintf_ex(bText, oFont, 10, 10, -1, -1, cText);						
			else
				textprintf_centre_ex(bText, oFont, bImage->w / 2, bImage->h / 2 - adjust, -1, -1, cText);						
		}
	}
	else
	{
		if(wrap == true)
			wrap_text();
		else
		{
			if(alignment == 0)
				textprintf_ex(bText, oFont, 10, 10, -1, -1, cButton[cIndex]);
			else
				textprintf_centre_ex(bText, oFont, bImage->w / 2, bImage->h / 2 - adjust, -1, -1, cButton[cIndex]);
		}
	}
	draw_sprite(bImage, bText, 0, 0);

	if(type == SLIDE_BAR)
	{
		line(bImage, 10, h / 2 - 1, w - 10, h / 2 - 1, BLACK);
		line(bImage, 8, h / 2, w - 8, h / 2, GREY);
		line(bImage, 10, h / 2 + 1, w - 10, h / 2 + 1, DARKGREY);

		if(bar_mouse_hover || bar_focus)
			rectfill(bImage, barx + 5, h / 2 - 5, barx + 15, h / 2 + 5, rgb(0,100,255));
		else
			rectfill(bImage, barx + 5, h / 2 - 5, barx + 15, h / 2 + 5, rgb(200,200,200));
		rect(bImage, barx + 5, h / 2 - 5, barx + 15, h / 2 + 5, rgb(180, 180, 180));
		rect(bImage, barx + 6, h / 2 - 4, barx + 14, h / 2 + 4, rgb(160, 160, 160));
	}

	
	if(falling)
	{
		if(gvisible)
		{			
			//if(menu == 30) allegro_message("%s", cText);
			stretch_sprite(bTransfer, bImage, int(tx),int(ty), int(sw), int(sh));
			set_trans_blender(0,0,0, iTransparency);
			draw_trans_sprite(bDisplay, bTransfer, 0, 0);			
		}
	}
	else
	{
		if(visible)
		{			
			stretch_sprite(bTransfer, bImage, x + water_float, y + water_float, bImage->w - water_float * 2, bImage->h - water_float * 2);
			set_trans_blender(0,0,0, iTransparency);
			draw_trans_sprite(bDisplay, bTransfer, 0, 0);			
		}
		else
			GAME.MainMenu->wWater->submerge(bImage, int((x + water_float) * convert_x - 20), int((y + water_float) * convert_y - 55), int(bImage->w * convert_x - water_float * 2), int(bImage->h * convert_y - water_float * 2));
	}
}


void OPTION::draw(BITMAP *bDisplay)
{	
	set_palette((RGB *) oPalette);	
	
	if(col == DARKGREEN)
		set_color(GAME.configuration->R, GAME.configuration->G, GAME.configuration->B);
	else
		set_color(180, 0, 0);
	draw_back_color();
	if(type == MULTI_LINE)
	{		
		if(GAME.view_online)
			GAME.gHSC->draw_online(bImage, int((vlength * ( float(bary) /float(h))) * -1), 30);
		else
			GAME.gHSC->draw(bImage,int((vlength * ( float(bary) /float(h))) * -1), 30);

		rectfill(bImage, w - 30, 5, w - 20, h - 5, DARKSLATEGREY);
		rect(bImage, w - 30, 5, w - 20, h - 5, GREY);

		if(bar_mouse_hover || bar_focus)
			rectfill(bImage, w - 30, bary, w - 20, bary + barh, rgb(0,100,255));
		else
			rectfill(bImage, w - 30, bary, w - 20, bary + barh, rgb(200,200,200));
		rect(bImage, w - 30, bary, w - 20, bary + barh, rgb(180,180,180));
		rect(bImage, w - 29, bary, w - 21, bary + barh, rgb(160,160,160));		
	}

	if(bPicture != NULL)
		stretch_sprite(bImage, bPicture, 10, 10, bImage->w - 20, bImage->h - 20);

	if(draw_border)
	{
		masked_blit(bOption_Image, bImage, 0, 0, 0, 0, 20, 20);
		masked_blit(bOption_Image, bImage, 40, 0, bImage->w - 20, 0, 20, 20);
		masked_blit(bOption_Image, bImage, 0, 40, 0, bImage->h - 20, 20, 20);
		masked_blit(bOption_Image, bImage, 40, 40, bImage->w - 20, bImage->h - 20, 20, 20);

		masked_stretch_blit(bOption_Image, bImage, 20, 0, 20, 20, 20, 0, bImage->w - 40, 20);
		masked_stretch_blit(bOption_Image, bImage, 0, 20, 20, 20, 0, 20, 20, bImage->h - 40);
		masked_stretch_blit(bOption_Image, bImage, 40, 20, 20, 20, bImage->w - 20, 20, 20, bImage->h - 40);
		masked_stretch_blit(bOption_Image, bImage, 20, 40, 20, 20, 20, bImage->h - 20, bImage->w - 40, 20);
		
		masked_stretch_blit(bOption_Image, bImage, 20, 20, 20, 20, 20, 20, bImage->w - 20, bImage->h - 20);
	}

	rectfill(bText, 0, 0, bText->w, bText->h, MASK);
	if(type != BUTTON)
	{
		if(wrap)
			wrap_text();
		else
		{
			
			if(alignment == 0)
				textprintf_ex(bText, oFont, 10, 10, -1, -1, cText);						
			else
				textprintf_centre_ex(bText, oFont, bImage->w / 2, bImage->h / 2 - adjust, -1, -1, cText);						
		}
	}
	else
	{
		if(wrap == true)
			wrap_text();
		else
		{
			if(alignment == 0)
				textprintf_ex(bText, oFont, 10, 10, -1, -1, cButton[cIndex]);
			else
				textprintf_centre_ex(bText, oFont, bImage->w / 2, bImage->h / 2 - adjust, -1, -1, cButton[cIndex]);
		}
	}
	draw_sprite(bImage, bText, 0, 0);

	if(type == SLIDE_BAR)
	{
		line(bImage, 10, h / 2 - 1, w - 10, h / 2 - 1, BLACK);
		line(bImage, 8, h / 2, w - 8, h / 2, GREY);
		line(bImage, 10, h / 2 + 1, w - 10, h / 2 + 1, DARKGREY);

		if(bar_mouse_hover || bar_focus)
			rectfill(bImage, barx + 5, h / 2 - 5, barx + 15, h / 2 + 5, rgb(0,100,255));
		else
			rectfill(bImage, barx + 5, h / 2 - 5, barx + 15, h / 2 + 5, rgb(200,200,200));
		rect(bImage, barx + 5, h / 2 - 5, barx + 15, h / 2 + 5, rgb(180, 180, 180));
		rect(bImage, barx + 6, h / 2 - 4, barx + 14, h / 2 + 4, rgb(160, 160, 160));
	}

	draw_sprite(bDisplay, bImage, x, y);				
}


void OPTION::wrap_text()
{
	int char_size = 9, line = 0, iIndex = 0, check = 0;
	char *cSave;
	char *cTransfer;
	char *cParse;
	bool break_at_check = false;
	int wrap_boundary = 0;
	cParse = cText;
	cTransfer = new char[strlen(cParse) + 1];
	//textprintf(bText, oFont, bImage->w + 10, bImage->h + 10, -1, cText);						
	while((strlen(cParse) - wrap_boundary) * char_size > unsigned(bImage->w))
	{
		iIndex = bImage->w / char_size - 1;
		// Find a space to break on
		while(iIndex > 0 && cParse[iIndex] != ' ')
			iIndex--;
		if(iIndex <= 0) break;
		//Now that we know where we are going to break, search for forced line breaks
		for(unsigned int iCheck = 0; iCheck < iIndex; iCheck++)
		{	
			if(iCheck < (strlen(cParse) - wrap_boundary) && iCheck + 1 < (strlen(cParse) - 1) && cParse[iCheck] == '\\' && cParse[iCheck+1] == 'n')
			{
				check = iCheck;
				break_at_check = true;
			}
		}

		if(!break_at_check)
		{
			cSave = cParse + iIndex + 1;
			cParse[iIndex] = '\0';
			strcpy(cTransfer, cParse);
			cParse[iIndex] = ' ';
			cParse = cSave;				
		}
		else
		{
			cSave = cParse + check + 2;
			cParse[check] = '\0';
			strcpy(cTransfer, cParse);
			cParse[check] = '\\';
			cParse = cSave;
		}
		check = 0;
		break_at_check = false;
		textprintf_ex(bText, oFont, 10, 10 + line, -1, -1, cTransfer);						
		line += char_size * 2;
	}
	strcpy(cTransfer, cParse);
	textprintf_ex(bText, oFont, 10, 10 + line, -1, -1, cTransfer);						
	delete cTransfer;
}

void OPTION::set_picture(char *cpath)
{
	bPicture = load_bitmap_check(cpath, NULL);
}

void OPTION::set_picture(BITMAP *bTmp)
{
	bPicture = bTmp;
}

void OPTION::set_align(int iValue)
{
	alignment = iValue;
}

void OPTION::set_wrap()
{
	wrap = true;
}

void OPTION::set_font(int iValue)
{
	if(iValue == 0)
	{
		oFont = GAME.score_font;
		oPalette = GAME.score_palette;
		adjust = 15;
	}
	else
	{
		oFont = GAME.help_font;
		oPalette = GAME.help_palette;
		adjust = 5;
	}

}

void OPTION::drop()
{
	falling = true;
}

void OPTION::animate()
{
	if(falling && !gvisible) return;
	if(static_option) return;

	if(bAnimate)
	{
		if(abs(ticks - animate_timer) > 5)
		{
			if(!bAnimate_Direction && !bAnimate_Lock)
			{
				iTransparency += 51;
				water_float--;
				if(water_float <= (3 * -1)) water_float++;
				if(iTransparency >= 255)
				{					
					iTransparency = 255;
					bAnimate = false;
					//GAME.MainMenu->wWater->clear_under_water();
				}
			}
			else
			{
				iTransparency -= 51;
				water_float++;
				if(iTransparency <= 0)
				{
					iTransparency = 0;
					bAnimate = false;
					visible = false;
					if(type == BUTTON && !bAnimate_Lock)
					{
						change_text();
						button_timer_delay = 20;
						button_timer = ticks;
					}
					//GAME.MainMenu->wWater->submerge(bImage, x * convert_x - 20, y * convert_y - 55, bImage->w * convert_x, bImage->h * convert_y);
					//GAME.MainMenu->wWater->submerge(bImage, (x + water_float) * convert_x - 20, (y + water_float) * convert_y - 55, bImage->w * convert_x - water_float * 2, bImage->h * convert_y - water_float * 2);
				}
			}
			animate_timer = ticks;
		}
	}
}

void OPTION::set_button_text(char *cValue, int iIndex)
{
	strcpy(cButton[iIndex], cValue);
}

void OPTION::change_text()
{
	cIndex++;
	while(cIndex < MAX_BUTTONS && strcmp(cButton[cIndex], "") == 0)
		cIndex++;
	if(cIndex >= MAX_BUTTONS) cIndex = 0;
}

void OPTION::set_index(int i)
{
	if(i < 0) i = 0;
	if(i >= MAX_BUTTONS)
		i = MAX_BUTTONS - 1;
	cIndex = i;
}



void OPTION::update_button()
{
	if(abs(ticks - button_timer) > button_timer_delay)
	{
		button_timer_delay = INT_MAX;
		button_timer = ticks;
		visible = true;
		bAnimate = true;
		bAnimate_Direction = false;
	}
}

void OPTION::set_vlength(int iMax)
{
	vlength = iMax;
	barh = int(h * (float(h) / float(vlength)));
}
		


void OPTION::toggle(int mx, int my)
{
	if(falling) return;
	if(type == STABLE) return;

	if(mx > x && mx < x + w
		&& my > y + water_float && my < y + water_float + h)
	{
		if(lock == false)
		{			
			if(visible) 
			{
				bAnimate = true;
				bAnimate_Direction = true;
				
			}
			else 
			{				
				visible = true;
				bAnimate = true;
				bAnimate_Direction = false;
			}
			lock = true;
		}
	}
	else
		lock = false;
}

bool OPTION::bar_has_focus()
{
	return bar_focus;
}


int OPTION::click()
{
	if(mouse_x > x && mouse_x < x+w && mouse_y > y && mouse_y < y+h && mouse_b & 1)
	{
		if(type == BUTTON)
		{
			bAnimate = true;
			bAnimate_Direction = true;
		}
	
		return ivalue;
	}
	
	return 0;
}

int OPTION::button_value()
{
	if(type != BUTTON) return 0;
	return cIndex;
}



void OPTION::highlight()
{
	if(falling || bAnimate_Lock || type == STABLE) return;
	if(mouse_x > x && mouse_x < x+w && mouse_y > y && mouse_y < y+h)
	{
		col = DARKRED;		
		if(!lock)
		{
			GAME.audio.play_sfx(7);
			lock = true;
		}
		if(!visible && type == NON_STABLE)
		{
			
			visible = true;
			bAnimate = true;
			bAnimate_Direction = false;
		}
	}
	else 
	{
		lock = false;
		col = DARKGREEN;
		if(visible && type == NON_STABLE)
		{
			bAnimate = true;
			bAnimate_Direction = true;
		}
	}
}

void OPTION::change_text(char *cValue)
{
	strcpy(cText, cValue);
}

void OPTION::init()
{
	visible = true;
	water_time = 0;
	water_float = 0;
	water_direction = true;
	x = 0;
    y = 0;
	w = 0;
	h = 0;
	update_timer = 0;
	delay_timer = 0;

	bImage = NULL;
	bOption_Image = NULL;
	bC1 = NULL;
	bC2 = NULL;
	bC3 = NULL;
	bC4 = NULL;
	bS1 = NULL;
	bS2 = NULL;
	bS3 = NULL;
	bS4 = NULL;
	bM = NULL;
	bText = NULL;

	bPicture = NULL;

	strcpy(cText, "");
	ivalue = 0;
	col = 0;

	bAnimate = false;
	bAnimate_Direction = true;
	animate_timer = 0;
	iTransparency = 255;
	lock = false;

	falling = false;

	sw = 0.0;
	sh = 0.0;
	sp = 0.0;
	sm = 0.0;
	tx = 0.0;
	ty = 0.0;
	tb = 0.0;
	m = 0.0;
	steps = 0;
	
	cx = 0.0;

	gdelay = 0;
	gOffset = 0;
	gvisible = false;	

	barx = 0;
	bar_focus = false;
	bar_mouse_hover = false;

	cIndex = 0;
	button_timer = 0;
	button_timer_delay = INT_MAX;
	for(int b = 0; b < MAX_BUTTONS; b++)
		strcpy(cButton[b], "");

	vlength = 0;
	bary = 0;
	barh = 0;

	bAnimate_Lock = false;

	wrap = false;
	alignment = 1;
	adjust = 15;

	static_option = false;
	draw_border = true;
}


