#include "configs.h"
#include<string.h>

CONFIG::CONFIG()
{
	init();
}

CONFIG::~CONFIG()
{
	destroy();
}

void CONFIG::load()
{
	push_config_state();
	set_config_file("config.ini");

	standard_load();
	customized_load();

	pop_config_state();
}

void CONFIG::standard_load()
{
	graphics();
	audio();
	timing();
}

void CONFIG::graphics()
{
	char **data;
	int count;
	//  Get screen mode
	if(strcmp_no_case(get_config_string("graphics", "windowed", "FALSE"), "FALSE") == 0)
		MODE = GFX_AUTODETECT_FULLSCREEN;
	else
		MODE = GFX_AUTODETECT_WINDOWED;

	//  Resolution
	data = get_config_argv("graphics", "mode", &count);
	if(count != 3)
	{
		/* We expect only 3 parameters */
		allegro_message("ERROR:  Incorrect amount of arguments in graphics.mode in config.ini");
		w = GFX_W;
		h = GFX_H;
		bpp = 32;
	}
	else
	{
		w = atoi(data[0]);
		h = atoi(data[1]);
		bpp = atoi(data[2]);
	}

	strcpy(level, get_config_string("graphics", "level", "LOW"));

}

void CONFIG::audio()
{
	//  Get the sound level 
	sfx_volume = get_config_int("audio", "sfx", 0);
	if(sfx_volume < 0) sfx_volume = 0;
	if(sfx_volume > 255) sfx_volume = 255;

	music_volume = get_config_int("audio", "music", 0);
	if(music_volume < 0) music_volume = 0;
	if(music_volume > 255) music_volume = 255;

	pan = get_config_int("audio", "pan", 0);
	if(pan < 0) pan = 0;
	if(pan > 255) pan = 255;
	
	mspeed = get_config_int("audio", "mspeed", 0);
	if(mspeed < 0) mspeed = 0;
	if(mspeed > 2000) mspeed = 2000;
}

void CONFIG::timing()
{
	framerate = get_config_int("time", "framerate", 0);
	clock_speed = get_config_int("time", "clock_speed", 60);
	if(clock_speed < 5) clock_speed = 5;
	if(clock_speed > 1000) clock_speed = 1000;
}


void CONFIG::customized_load()
{
	// Load the GUI effects variables
	R = get_config_int("gui", "r", 0);
	if(R < 0) R = 0; if(R > 255) R = 255;
	G = get_config_int("gui", "g", 0);
	if(G < 0) G = 0; if(G > 255) G = 255;
	B = get_config_int("gui", "b", 0);
	if(B < 0) B = 0; if(B > 255) B = 255;
	shade = get_config_int("gui", "shade", 2);
	segments = get_config_int("gui", "segments", 100);
	if(segments < 5) segments = 5;
	still_background = get_config_int("gui", "still_background", 1);
	if(still_background != 0 && still_background != 1) still_background = 1;
	mouse_icon = get_config_int("gui", "mouse_icon", 1);
	if(mouse_icon != 0 && mouse_icon != 1) mouse_icon = 1;


	// Load the water effects variables
	wwidth = get_config_int("water", "wwidth", 0);
	if(wwidth > POOL_MAXX) wwidth = POOL_MAXX;
	wheight = get_config_int("water", "wheight", 0);
	if(wheight > POOL_MAXY) wheight = POOL_MAXY;
	wdamper = get_config_int("water", "wdamper", 0);
	wsmooth = get_config_int("water", "wsmooth", 0);
	wclear_init = get_config_int("water", "wclear_init", 0);
	wunder_water = ustrdup(get_config_string("water", "wunder_water", "border.pcx"));
	wwater_surface = ustrdup(get_config_string("water", "wwater_surface", "vortec.pcx"));
	no_water_change = get_config_int("water", "no_water_change", 0);

	// Load the miscellaneous variables
	start_online = get_config_int("misc", "start_online", 0);
	if(start_online < 0 || start_online > 1) start_online = 1;
}

void CONFIG::write()
{
	push_config_state();
	set_config_file("config.ini");

	if(MODE == GFX_AUTODETECT_FULLSCREEN)
		set_config_string("graphics", "windowed", "FALSE");
	else
		set_config_string("graphics", "windowed", "TRUE");

	set_config_string("graphics", "level", level);

	set_config_int("audio", "sfx", GAME.audio.sfx_volume);
	set_config_int("audio", "music", GAME.audio.volume);


	pop_config_state();
	
}

void CONFIG::destroy()
{

}

/* NOTE:  The following function is code written by spellcaster (Lennart Steinke)
          in an attempt to provide a config file example. */
/* works lik strcmp, but ignores case */
int CONFIG::strcmp_no_case(const char*lhs, const char*rhs) 
{
    char v;
    while (*lhs && *rhs) 
    {
        v = utolower(*lhs) - utolower(*rhs);
        if (v) 
           return v;
        
        ++lhs;
        ++rhs;
    }
    if (*lhs) 
       return 1;
    
    if (*rhs) 
        return -1;        
    return 0;
}

void CONFIG::init()
{
	MODE = GFX_AUTODETECT_WINDOWED;
	sfx_volume = 0;
	music_volume = 0;
	pan = 0;
	mspeed = 0;
	strcpy(level, "");

	still_background = 0;
	mouse_icon = 1;

	framerate = 0;
	clock_speed = 0;

	no_water_change = 0;
	wwidth = 0;
	wheight = 0;
	wdamper = 0;
	wsmooth = 0;
	wclear_init = 0;
	wunder_water = NULL;
	wwater_surface = NULL;

	start_online = 0;

}

