#include "bonus.h"

BONUS::BONUS()
{
	init();
}

BONUS::~BONUS()
{
	destroy();
}

void BONUS::reset(BONUSES bType, char *cArray, int X, int Y, int iW, int iH, int Max_Frames, int iSize)
{
	x = X;
	y = Y;
	dx = x;
	dy = y;

	W = iW;
	H = iH;
	Size = iSize;
	iMax_Frames = Max_Frames;
	iFrame_X = 0;

	visible = true;
	type = bType;
	lock = true;
	deadlock = false;

	if(bImage != NULL) 
	{
		destroy_bitmap(bImage);
		bImage = NULL;
	}
	if(bArray != NULL) 
	{
		destroy_bitmap(bArray);
		bArray = NULL;
	}
	
	bImage = create_bitmap_check(W, H);
	bArray = load_bitmap_check(cArray, NULL);	

	if(bType == CLOCK)
		animate_delay = 15;
	else if(bType == BOMB)
		animate_delay = 5;
	else if(bType == BOLT)
		animate_delay = 5;
	else if(bType == BPERCENT)
		animate_delay = 5;
	else if(bType == ULTIMA)
		animate_delay = 5;

}



void BONUS::obtain(games gCurrent_Game, int mx, int my)
{
	int i = 0, ix = 0, y_offset = 0;

	if(mx > x && mx < x + Size
		&& my > y && my < y  + Size)
	{
		if(deadlock == false && lock == false)
		{
			//place in bonus set
			i = gCurrent_Game.bBoard->current_slot();
			if(i == -1) return;

			gCurrent_Game.audio.play_sfx(1);			
			ix = i;
			if(i > 2) 
			{
				ix -= 3;
				y_offset = 60;
			}
			place(gCurrent_Game.bBoard->bSlots_X[i], gCurrent_Game.bBoard->bSlots_Y[i]);
			gCurrent_Game.bBoard->set_slot(i, this);
			gCurrent_Game.gScore->add(25);
			
			lock = true;
			deadlock = true;

			//particle affect
			gCurrent_Game.peCombo->explode(50, x + (Size / 2), y + (Size / 2), W, H, 0.8, 0.01, 5.0, 0.03, 10, 0.6);					
		}
	}		
	else
		lock = false;
	
}


void BONUS::destroy()
{
	if(bImage != NULL) destroy_bitmap(bImage);
	if(bArray != NULL) destroy_bitmap(bArray);
}

void BONUS::update(games gCurrent_Game, int mx, int my)
{
	if(abs(ticks - animate_timer) > animate_delay)
	{
		iFrame_X++;
		if(iFrame_X >= iMax_Frames) iFrame_X = 0;
		animate_timer = ticks;
	}

	obtain(gCurrent_Game, mx, my);

	if(abs(ticks - move_timer) > 5)
	{
		move();
		move_timer = ticks;
	}
}

void BONUS::draw(BITMAP *bDisplay, int iW, int iH)
{	
	if(deadlock == false)
		masked_stretch_blit(bArray, bDisplay, iFrame_X * W, 0, W, H, x + 20, y + 20, iW, iH);
	else
		masked_stretch_blit(bArray, bDisplay, iFrame_X * W, 0, W, H, x + 20, y + 20, W, H);
}

void BONUS::move()
{
	int mx = 0, my = 0;
	if(x != dx)
		mx = (dx - x) / 5;
	if(y != dy)
		my = (dy - y) / 5;
	if(abs(dx - x) < 2) x = dx;
	if(abs(dy - y) < 2) y = dy;

	x += mx;
	y += my;
}

void BONUS::place(int X, int Y)
{
	dx = X;
	dy = Y;
}

bool BONUS::use(games gCurrent_Game)
{
	int iX = 0, iY = 0, iSize = 0;
	if(mouse_x < 20 || mouse_x > 420 || mouse_y < 20 || mouse_y > 420)
		return false;
	if(type == CLOCK)
	{			
		gCurrent_Game.peToggle_Stars->explode(150, 565, 142, 65, 25, 1.0, 0.01, 1.0, 0.05, 60);
		gCurrent_Game.bBoard->reset_clock();
	}
	else if(type == BOMB)
	{
		gCurrent_Game.audio.play_sfx(10);		
		iX = gCurrent_Game.bBoard->toggle_x(mouse_x - 20, mouse_y - 20);
		iY = gCurrent_Game.bBoard->toggle_y(mouse_x - 20, mouse_y - 20);
		gCurrent_Game.peFire->explode(100, mouse_x - 20, mouse_y - 20, 50, 50, 1.0, 0.01, 1.0, 0.05, 30, 0.45);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX, iY);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX - 1, iY);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX - 2, iY);		
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX + 1, iY);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX + 2, iY);		
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX - 1, iY + 1);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX, iY + 1);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX + 1, iY + 1);				
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX, iY + 2);				
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX - 1, iY - 1);		
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX, iY - 1);
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX + 1, iY - 1);				
		gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX, iY - 2);				
	}
	else if( type == BOLT)
	{
		gCurrent_Game.audio.play_sfx(5);		
		iX = gCurrent_Game.bBoard->toggle_x(mouse_x - 20, mouse_y - 20);
		iY = gCurrent_Game.bBoard->toggle_y(mouse_x - 20, mouse_y - 20);
		for(int j = 0; j < 30; j++)
			gCurrent_Game.bBoard->toggle_down(gCurrent_Game, iX, j);
		for(int k = 0; k < 30; k++)
			gCurrent_Game.bBoard->toggle_down(gCurrent_Game, k, iY);

		iX = mouse_x;
		iY = mouse_y;
		iSize = gCurrent_Game.bBoard->tile_size();
		
		gCurrent_Game.lLightning->setup(iX, iY, iX - iSize / 2, iX + iSize / 2, iY - iSize / 2, iY + iSize / 2);
	}
	else if(type == BPERCENT)
	{
		gCurrent_Game.bBoard->set_progress_max(gCurrent_Game.bBoard->progress_max() * 0.75);
	}
	else if(type == ULTIMA)
	{
		gCurrent_Game.audio.play_sfx(9);		
		gCurrent_Game.bBoard->ultima = true;
	}
	
	
	return true;
}

void BONUS::init()
{
	W = 0;
	H = 0;
	x = 0;
	y = 0; 	
	dx = 0;
	dy = 0;
	bImage = NULL;
	bArray = NULL;
	iFrame_X = 0;
	iMax_Frames = 0;
	animate_timer = 0;
	animate_delay = 0;
	move_timer = 0;
	Size = 0;
	
	type = NONE;
	visible = false;
	lock = false;
	deadlock = false;
}

