#include "bolt.h"
SINGLE_BOLT::SINGLE_BOLT()
{
	init();
}

SINGLE_BOLT::~SINGLE_BOLT()
{
	destroy();
}

void SINGLE_BOLT::setup(float X1, float Y1, int X2, int Y2, DIR dDir, int col, int speed)
{
	x1 = X1;
	x2 = X2;
	y1 = Y1;
	y2 = Y2;
	cx = float(x1);
	cy = float(y1);
	iColor = col;

    dDirection = dDir;
	if(dDirection == UPRIGHT)
		angle = 90 + 45;
	else if(dDirection == UPLEFT)
		angle = 180 + 45;
	else if(dDirection == DOWNRIGHT)
		angle = 45;
	else if(dDirection == DOWNLEFT)
		angle = 180 + 90 + 45;

	angle +=  + rand() % 15 - rand() % 15;
	alive = true;

	iSpeed = speed;
}

void SINGLE_BOLT::update()
{
	
	if(!complete() && abs(ticks - update_timer) > 1)
	{
		if(alive == false) return;
		cx += fixtof(fixsin(itofix(int(angle/1.40625)))) * iSpeed;
		cy += fixtof(fixcos(itofix(int(angle/1.40625)))) * iSpeed;			
		update_timer = ticks;
	}
}
		
void SINGLE_BOLT::destroy()
{
	//Note:  Nothing to destroy
}

void SINGLE_BOLT::draw(BITMAP *bDisplay)
{
	if(alive == false) return;
	line(bDisplay, int(x1), int(y1), int(cx), int(cy), WHITE);	
	
	line(bDisplay, int(x1 + 1), int(y1), int(cx + 1), int(cy), iColor);
	line(bDisplay, int(x1 - 1), int(y1), int(cx - 1), int(cy), iColor);	
	line(bDisplay, int(x1 + 2), int(y1), int(cx + 2), int(cy), iColor);
	line(bDisplay, int(x1 - 2), int(y1), int(cx - 2), int(cy), iColor);
	
}


bool SINGLE_BOLT::complete()
{
	if(dDirection == UPRIGHT && (cx > x2 || cy < y2))
	{
		alive = false;
		return true;
	}

	if(dDirection == UPLEFT && (cx < x2 || cy < y2))
	{
		alive = false;
		return true;
	}

	if(dDirection == DOWNRIGHT && (cx > x2 || cy > y2))
	{
		alive = false;
		return true;
	}

	if(dDirection == DOWNLEFT && (cx < x2 || cy > y2))
	{
		alive = false;
		return true;
	}

	return false;
}



void SINGLE_BOLT::init()
{
	x1 = 0;
	x2 = 0;
	cx = 0;
	y1 = 0;
	y2 = 0;
	cy = 0;
	update_timer = 0;
	iColor = 0;
	angle = 0;
	dDirection = NO_DIR;
	iSpeed = 0;
}


