#include "allegro_input.h"

int input_timer;

INPUT::INPUT()
{
	KEYBOARD = new myKEY;
	JOYSTICK = new JOY;
}

INPUT::~INPUT()
{
	delete KEYBOARD;
	delete JOYSTICK;
}

void INPUT::map(int iIndex, int iType, int iValue, int jType)
{
	if(iIndex < 0 || iIndex >= MAX_MAPPING) return;
	if(iType == 0)
		KEYBOARD->map(iIndex, iValue);
	else
		JOYSTICK->map(iIndex, jType, iValue);
}


bool INPUT::MAP(int mPID, int iValue, int iTimer_Delay)
{
	if((KEYBOARD->MAP(iValue) || JOYSTICK->MAP(mPID, iValue)) && abs(ticks - input_timer) >= iTimer_Delay)
	{
		input_timer = ticks;
		return true;
	}
	return false;
}

bool INPUT::MAP(int iValue)
{
	return MAP(0, iValue, 0);
}


bool INPUT::MAP(int iValue, int iTimer_Delay)
{
	return MAP(0, iValue, iTimer_Delay);
}

