#include "allegro_color.h"
#include<math.h>

int red(int color_value)
{
	return int(color_value / pow(256, 2)) % 256;
}
int green(int color_value)
{
    return int(color_value / pow(256, 1)) % 256;
}
int blue(int color_value)
{
	return color_value % 256;
}

COLOR getColor(int color_value)
{
	COLOR temp;

	temp.red = red(color_value);
	temp.green = green(color_value);
	temp.blue = blue(color_value);

	return temp;
}

int rgb(int red, int green, int blue)
{
	return int(blue * pow(256, 0)) + int(green * pow(256, 1)) + int(red * pow(256, 2));
}
int rgb(COLOR color_data)
{
	return int(color_data.blue * pow(256, 0)) + int(color_data.green * pow(256, 1)) + int(color_data.red * pow(256, 2));
}


const int SNOW = rgb(255, 250, 250);
const int GHOSTWHITE = rgb(248, 248, 255);
const int WHITESMOKE = rgb(245, 245, 245);
const int GAINSBORO = rgb(220, 220, 220);
const int FLORALWHITE = rgb(255, 250, 240);
const int OLDLACE = rgb(253, 245, 230);
const int LINEN = rgb(250, 240, 230);
const int ANTIQUEWHITE = rgb(250, 235, 215);
const int PAPAYAWHIP = rgb(255, 239, 213);
const int BLANCHEDALMOND = rgb(255, 235, 205);
const int BISQUE = rgb(255, 228, 196);
const int PEACHPUFF = rgb(255, 218, 185);
const int NAVAJOWHITE = rgb(255, 222, 173);
const int MOCCASIN = rgb(255, 228, 181);
const int CORNSILK = rgb(255, 248, 220);
const int IVORY = rgb(255, 255, 240);
const int LEMONCHIFFON = rgb(255, 250, 205);
const int SEASHELL = rgb(255, 245, 238);
const int HONEYDEW = rgb(240, 255, 240);
const int MINTCREAM = rgb(245, 255, 250);
const int AZURE = rgb(240, 255, 255);
const int ALICEBLUE = rgb(240, 248, 255);
const int LAVENDER = rgb(230, 230, 250);
const int LAVENDERBLUSH = rgb(255, 240, 245);
const int MISTYROSE = rgb(255, 228, 225);
const int WHITE = rgb(255, 255, 255);
const int BLACK = rgb(0, 0, 0);
const int DARKSLATEGRAY = rgb(47, 79, 79);
const int DARKSLATEGREY = rgb(47, 79, 79);
const int DIMGRAY = rgb(105, 105, 105);
const int DIMGREY = rgb(105, 105, 105);
const int SLATEGRAY = rgb(112, 128, 144);
const int SLATEGREY = rgb(112, 128, 144);
const int LIGHTSLATEGRAY = rgb(119, 136, 153);
const int LIGHTSLATEGREY = rgb(119, 136, 153);
const int GRAY = rgb(60, 60, 60);
const int GREY = rgb(190, 190, 190);
const int LIGHTGREY = rgb(211, 211, 211);
const int LIGHTGRAY = rgb(211, 211, 211);
const int MIDNIGHTBLUE = rgb(25, 25, 112);
const int NAVY = rgb(0, 0, 128);
const int NAVYBLUE = rgb(0, 0, 128);
const int CORNFLOWERBLUE = rgb(100, 149, 237);
const int DARKSLATEBLUE = rgb(72, 61, 139);
const int SLATEBLUE = rgb(106, 90, 205);
const int MEDIUMSLATEBLUE = rgb(123, 104, 238);
const int LIGHTSLATEBLUE = rgb(132, 112, 255);
const int MEDIUMBLUE = rgb(0, 0, 205);
const int ROYALBLUE = rgb(65, 105, 225);
const int BLUE = rgb(0, 0, 255);
const int DODGERBLUE = rgb(30, 144, 255);
const int DEEPSKYBLUE = rgb(0, 191, 255);
const int SKYBLUE = rgb(135, 206, 235);
const int LIGHTSKYBLUE = rgb(135, 206, 250);
const int STEELBLUE = rgb(70, 130, 180);
const int LIGHTSTEELBLUE = rgb(176, 196, 222);
const int LIGHTBLUE = rgb(173, 216, 230);
const int POWDERBLUE = rgb(176, 224, 230);
const int PALETURQUOISE = rgb(175, 238, 238);
const int DARKTURQUOISE = rgb(0, 206, 209);
const int MEDIUMTURQUOISE = rgb(72, 209, 204);
const int TURQUOISE = rgb(64, 224, 208);
const int CYAN = rgb(0, 255, 255);
const int LIGHTCYAN = rgb(224, 255, 255);
const int CADETBLUE = rgb(95, 158, 160);
const int MEDIUMAQUAMARINE = rgb(102, 205, 170);
const int AQUAMARINE = rgb(127, 255, 212);
const int DARKGREEN = rgb(0, 100, 0);
const int DARKOLIVEGREEN = rgb(85, 107, 47);
const int DARKSEAGREEN = rgb(143, 188, 143);
const int SEAGREEN = rgb(46, 139, 87);
const int MEDIUMSEAGREEN = rgb(60, 179, 113);
const int LIGHTSEAGREEN = rgb(32, 178, 170);
const int PALEGREEN = rgb(152, 251, 152);
const int SPRINGGREEN = rgb(0, 255, 127);
const int LAWNGREEN = rgb(124, 252, 0);
const int GREEN = rgb(0, 255, 0);
const int CHARTREUSE = rgb(127, 255, 0);
const int MEDIUMSPRINGGREEN = rgb(0, 250, 154);
const int GREENYELLOW = rgb(173, 255, 47);
const int LIMEGREEN = rgb(50, 205, 50);
const int YELLOWGREEN = rgb(154, 205, 50);
const int FORESTGREEN = rgb(34, 139, 34);
const int OLIVEDRAB = rgb(107, 142, 35);
const int DARKKHAKI = rgb(189, 183, 107);
const int KHAKI = rgb(240, 230, 140);
const int PALEGOLDENROD = rgb(238, 232, 170);
const int LIGHTGOLDENRODYELLOW = rgb(250, 250, 210);
const int LIGHTYELLOW = rgb(255, 255, 224);
const int YELLOW = rgb(255, 255, 0);
const int GOLD = rgb(255, 215, 0);
const int LIGHTGOLDENROD = rgb(238, 221, 130);
const int GOLDENROD = rgb(218, 165, 32);
const int DARKGOLDENROD = rgb(184, 134, 11);
const int ROSYBROWN = rgb(188, 143, 143);
const int INDIAN = rgb(205, 92, 92);
const int INDIANRED = rgb(205, 92, 92);
const int SADDLEBROWN = rgb(139, 69, 19);
const int SIENNA = rgb(160, 82, 45);
const int PERU = rgb(205, 133, 63);
const int BURLYWOOD = rgb(222, 184, 135);
const int BEIGE = rgb(245, 245, 220);
const int WHEAT = rgb(245, 222, 179);
const int SANDYBROWN = rgb(244, 164, 96);
const int TAN = rgb(210, 180, 140);
const int CHOCOLATE = rgb(210, 105, 30);
const int FIREBRICK = rgb(178, 34, 34);
const int BROWN = rgb(165, 42, 42);
const int DARKSALMON = rgb(233, 150, 122);
const int SALMON = rgb(250, 128, 114);
const int LIGHTSALMON = rgb(255, 160, 122);
const int ORANGE = rgb(255, 165, 0);
const int DARKORANGE = rgb(255, 140, 0);
const int CORAL = rgb(255, 127, 80);
const int LIGHTCORAL = rgb(240, 128, 128);
const int TOMATO = rgb(255, 99, 71);
const int ORANGERED = rgb(255, 69, 0);
const int RED = rgb(200, 0, 0);
const int HOTPINK = rgb(255, 105, 180);
const int DEEPPINK = rgb(255, 20, 147);
const int PINK = rgb(255, 192, 203);
const int LIGHTPINK = rgb(255, 182, 193);
const int PALEVIOLETRED = rgb(219, 112, 147);
const int MAROON = rgb(176, 48, 96);
const int MEDIUMVIOLETRED = rgb(199, 21, 133);
const int VIOLETRED = rgb(208, 32, 144);
const int MASK = rgb(255, 0, 255);
const int VIOLET = rgb(238, 130, 238);
const int PLUM = rgb(221, 160, 221);
const int ORCHID = rgb(218, 112, 214);
const int MEDIUMORCHID = rgb(186, 85, 211);
const int DARKORCHID = rgb(153, 50, 204);
const int DARKVIOLET = rgb(148, 0, 211);
const int BLUEVIOLET = rgb(138, 43, 226);
const int PURPLE = rgb(160, 32, 240);
const int MEDIUMPURPLE = rgb(147, 112, 219);
const int THISTLE = rgb(216, 191, 216);
const int DARKGREY = rgb(169, 169, 169);
const int DARKGRAY = rgb(169, 169, 169);
const int DARKBLUE = rgb(0, 0, 139);
const int DARKCYAN = rgb(0, 139, 139);
const int DARKMAGENTA = rgb(139, 0, 139);
const int DARKRED = rgb(139, 0, 0);
const int LIGHTGREEN = rgb(144, 238, 144);

