/**************************************************
*  FILE:  water.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/12/2006                               *
*                                                 *
*  Maintains the water structure that flows       *
*  inside a pool.                                 *
**************************************************/

#ifndef _WATER_H_
#define _WATER_H_

//#include "pool.h"
#include "game.h"
#include "pool.h"
//typedef class POOL pool;

#define MAX_DROPS 1000
#define POOL_MAXX 400
#define POOL_MAXY 400


typedef struct drop
{
	int size;
	int x;
	int y;
	int refresh_rate;
	float decay;

	bool vertical;
	bool horizontal;
	int length;

	int timer;
}DROP;

class WATER
{
public:
	BITMAP *bImage;						// Final Image to affect					
	BITMAP *bUnder_Water;
	int iWidth;
	int iHeight;

	WATER();
	WATER(char *cBackground);
	WATER(char *cBackground, char *cForeground);
	~WATER();

	void init();
	void load(char *cBackground, char *cForeground);
	void loadBG(char *cBackground);
	void loadFG(char *cForeground);
	void destroy();

	void mix();
	void mixture(int iAmount);
	int Get_Transparency();

	void Update();
	void submerge(BITMAP *bSubmerge, int x, int y, int w, int h);
	void clear_under_water();
	void draw();
	void draw(BITMAP *bDisplay);
	
	void Drop(int size);
	void Drop(int x, int y, int size);
	void Drop(int x, int y, int size, int refresh_rate, float decay);
	void Drop(int x, int y, int size, int refresh_rate, float decay, bool horizontal, bool vertical, int length);
		
	void Setup(int w, int h, int iDamper, int iSmooth, int cleary);
	

	
private:
	int update_timer;
	//  dispLut[512] is used to as a lookup table for the allegro trig functions.
	//  This array was taken from miran amon's rain demo program.
	int dispLut[512];		

	//  The following arrays are used to track the height of water on the pool
	short WaveMap1[POOL_MAXX][POOL_MAXY];	
	short WaveMap2[POOL_MAXX][POOL_MAXY];

	//  This array keeps track of drops/ripples in the water
	DROP *dWaves[MAX_DROPS];

	//  This array stores the image color data that is to be refracted
	int ImageMap[POOL_MAXX][POOL_MAXY];

	//  Determines which wavemap is the current mapping
	bool Current;
	int iTransparency;					// For mixing
	int iClear;

	BITMAP *bBack_Ground;				// Original bottom-of-water
	BITMAP *bWater_Mixture;				// Water mixture
	
	BITMAP *bTransfer;
	BITMAP *bTemp;

	bool rushing;
	int rushing_amount;
	int damper;
	int smooth;
	int cSaturation;

	void flip();
	void Update_Drops();
	void Update_Drop(int i);
	void Update_Image();
	
};

#endif /* End of _WATER_H_ */

