/**************************************************
*  FILE:  toggle.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/15/2006                               *
*                                                 *
*  Handles the toggle object, which moves up and  *
*  down when mouse is over it.                    *
**************************************************/

#ifndef _TOGGLE_H_
#define _TOGGLE_H_

#include "game.h"
//#include "water.h"
//#include "board.h"
#define WATER_SHIFT 2
#define TIMER_WATER_SHIFT 15
#define FIRST_COMBO 10
#define SECOND_COMBO 25
#define THIRD_COMBO 45
#define FOURTH_COMBO 70
typedef class WATER water;
typedef class games GAMES;
//typedef class BOARD board;
//typedef struct game GAMES;

class TOGGLE
{
public:
	TOGGLE();
	~TOGGLE();

	//void setup(games gCurrent_Game, char *cpath, char *cpath1, char *cpath2, int X, int Y, int W, int H, bool bVisible, int iDifficulty);
	//void setup(games gCurrent_Game);
	void setup(games gCurrent_Game, int X, int Y, int W, int H, bool bVisible, int iDifficulty);

	void destroy();
	void update(games gCurrent_Game, int mx, int my);
	void draw(BITMAP *bDisplay);

	bool is_visible();
	void toggle(games gCurrent_Game, int mx, int my);
	void ripple_water(WATER *wToggles_Water);
	int iType();

	void toggle_down(games gCurrent_Game);
	bool mouse_over(int mx, int my);


private:
	int x,y;
	int w,h;
	BITMAP *bImage;	
	BITMAP *bTransfer;
	int rType;
	int rUpdate;
	int rCount;

	int water_float;
	bool moving_up;
	int water_time;
	int toggle_timer;
	bool visible;
	bool lock;
	int type;
	int difficulty;

	bool up_or_down;  // 0 for down, 1 for up

	int iIntensity;
	bool bFlash_Dir;
	int flash_timer;

	bool bToggle_Animate;
	bool bToggle_Animate_Direction;
    int toggle_animate_timer;
	int iTransparency;
		
	

    void init();
	void combos(games gCurrent_Game, int mx, int my);
	void update_image();
	void choose_type(games gCurrent_Game);
	void random_type();
	void float_on_water(games gCurrent_Game);
	void flash_animate();
	void toggle_animate(games gCurrent_Game);
	void create_message(char *s);

};

#endif /* End of _TOGGLE_H_ */

