/**************************************************
*  FILE:  pump.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  8/23/2006                               *
*                                                 *
**************************************************/

#ifndef _PUMP_H_
#define _PUMP_H_

#include "game.h"

#define MAX_PDROPS 5000
#define MAX_DROP_LENGTH 20
#define MIN_DROP_LENGTH 3

typedef struct pumping_water
{
	int x, y;
	int dy;
	int length;
	int max_length;
	int col;
	int iTrans;
	int speed;
} PUMPING_WATER;

class PUMP
{
public:
	PUMP();
	~PUMP();

	void setup(int X, int Y, int x1, int y1, int x2, int y2, int l);
	void draw(BITMAP *bDisplay);
	void update();
	void create_drop();

	int drop_at_x();
	int drop_at_y();
	

private:
	PUMPING_WATER *pDrops[MAX_PDROPS];
	BITMAP *bImage;
	int x, y;
	int rx1, rx2, ry1, ry2;				//region varibles for where teh pDrops come from
	int z_length;
	int dx, dy;

	void destroy();
	void init();
};

#endif /* End of _PUMP_H_ */

