/**************************************************
*  FILE:  penalty.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/30/2006                               *
*                                                 *
**************************************************/

#ifndef _PENALTY_H_
#define  _PENALTY_H_

#include "game.h"

#define MAX_PENALTIES 6
extern int NO_PENALTY;
extern int TIME_DECREASE; 
extern int ROW_INCREASE; 
extern int PERCENT_INCREASE;
extern int TIMEE_DECREASE_2;
extern int TIME_DECREASE_4;
extern int PERCENT_INCREASE_2;
extern int PERCENT_INCREASE_3;
extern int ROW_INCREASE_2;
extern int TIME_INCREASE;
extern int PERCENT_DECREASE;
extern int BONUS_PACKAGE;

class PENALTY
{
public:
	PENALTY();
	~PENALTY();

	void setup();
	void set_item(int iIndex, char *cpath, int X, int Y, int Frames, int Max);
	void set_item(int iIndex, char *cpath, int Frames, int Max);
	void destroy();
	void update();
	void draw(BITMAP *bDisplay);
	int position();
	void unlock();
	void input(int X, int Y);

	void pic_slots();
	int pic_random();

	void choose(int x, int y);

	void move(int x, int y);
	void place(int x, int y);
	

	int done();

private:
	BITMAP *bImage;
	BITMAP *bItems[MAX_PENALTIES];
	int iFrames_X[MAX_PENALTIES];
	int iMax_Frames[MAX_PENALTIES];
	int bItems_X[MAX_PENALTIES];
	int bItems_Y[MAX_PENALTIES];
	int x,y;
	int dx, dy;
	int w,h;

	int istretch_x;
	int istretch_y;
	int iAnimate;

	int iTemp_X;
	int iTemp_Y;
	int iChosen;
	bool lock;

	int update_timer;
	int animate_timer;

	int pTemp;
	int pItems[MAX_PENALTIES];

	void init();
	void update_animate(int X, int Y);

};

#endif /* End of _PENALTY_H_ */

