/**************************************************
*  FILE:  particle_engine.h                       *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/17/2006                               *
*                                                 *
**************************************************/

#ifndef _PARTICLE_ENGINE_H_
#define _PARTICLE_ENGINE_H_

#include "game.h"
#include "particle.h"
typedef class PARTICLE particle;

#define MAX_PARTICLES 200

class PARTICLE_ENGINE
{
public:
	PARTICLE_ENGINE();
	~PARTICLE_ENGINE();

	void setup(char *cImages, int iItems, int W, int H, int delay);	
	void destroy();
	void draw(BITMAP *bDisplay);
	void update();

	void explode(int Count, int cx, int cy, int sx, int sy, float fCompact, float fGravity, float iSpeed, float iSpeed_Diff, int iLife);
	void explode(int Count, int cx, int cy, int sx, int sy, float fCompact, float fGravity, float iSpeed, float iSpeed_Diff, int iLife, float ftrans);


private:
	PARTICLE *pParticles[MAX_PARTICLES];
	int center_x;
	int center_y;
	int spread_x;
	int spread_y;
	float compact;
	float gravity;
	int speed;
	int update_delay;
	int update_timer;

	int pCount;

	BITMAP *bArray;
	int bItems;
	int w, h;

	void init();
};

#endif /* End of _PARTICLE_ENGINE_H_ */

