/**************************************************
*  FILE:  option.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  9/03/2006                               *
*                                                 *
**************************************************/

#ifndef _OPTION_H_
#define _OPTION_H_

#include "game.h"

#define MAX_GSTEPS 15
#define MAX_BUTTONS 4

enum OTYPE{NO_OTYPE=0, NON_STABLE, STABLE, SLIDE_BAR, BUTTON, MULTI_LINE};

class OPTION
{
public:
	OPTION();
	~OPTION();

	void setup(char *cText, int MENU, int X, int Y, int w, int h, int Value, int gO);
	void setup(char *cText, int MENU, OTYPE oType, int X, int Y, int w, int h, int Value, int gO);
	void destroy();
	void update();
	void draw(BITMAP *bDisplay, BITMAP *bTransfer);	
	void draw(BITMAP *bDisplay);

	void highlight_only();

	char cText[1024];

	int click();
	void drop();
	void set_sky(int gO);
	void set_bar(float X);
	float get_bar();
	void set_vlength(int);
	bool bar_has_focus();
	int button_value();

	void force_submerge();

	void set_picture(char *cpath);
	void set_picture(BITMAP *bTmp);
	void set_font(int iValue);
	void set_wrap();
	void set_align(int iValue);

	void set_button_text(char *cValue, int iIndex);

	bool is_menu(int i);

	void change_text(char *cValue);
	void set_index(int i);

private:
	int water_time;
	int water_float;
	int water_direction;
	int x,y,w,h;
	int update_timer, delay_timer, gravity_timer;
	bool visible;
	int col;
	int gdelay;
	int gOffset;
	bool gvisible;
	int barx;
	int ir, ig, ib;

	OTYPE type;
	FONT *oFont;
	PALETTE *oPalette;

	bool static_option;
	bool draw_border;

	bool wrap;
	int alignment;
	int adjust;


	BITMAP *bText;
	BITMAP *bImage;
	//BITMAP *bTransfer;
	BITMAP *bOption_Image;
	BITMAP *bC1, *bC2, *bC3, *bC4;
	BITMAP *bS1, *bS2, *bS3, *bS4;
	BITMAP *bM;

	BITMAP *bPicture;

	
	int ivalue;

	int menu;

	bool falling;
	bool bAnimate;
	bool bAnimate_Direction;
	int iTransparency;
	int animate_timer;
	bool lock;

	void set_color(int r, int g, int b);
	void draw_back_color();


	void highlight();
	void init();
	void animate();

	void float_on_water();
	void ripple_water();
	void toggle(int x, int y);

	void slide_bar();
	bool bar_focus;
	bool bar_mouse_hover;

	bool bAnimate_Lock;

	int cIndex;
	char cButton[MAX_BUTTONS][30];
	int button_timer, button_timer_delay;	
	void change_text();
	void update_button();


	int bary;
	int barh;
	int vlength;
	void slide_vbar();

	void wrap_text();
	
	
	void gravity();
	float sw, sh, sp, sm;
	float tx, ty, tb, m;
	int steps;
	float cx;

};

#endif /* End of _OPTION_H_*/

