/**************************************************
*  FILE:  lightning.h		                      *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/25/2006                               *
*                                                 *
**************************************************/

#ifndef _LIGHTNING_H_
#define _LIGHTNING_H_

#include "game.h"
#include "bolt.h"
typedef class SINGLE_BOLT single_bolt;

#define MAX_BOLTS 10

class LIGHTNING
{
public: 
	LIGHTNING();
	~LIGHTNING();

	void setup(int X, int Y, int B1, int B2, int B3, int B4);
	void destroy();
	void draw(BITMAP *bDisplay);
	void update();

private:
	int cx;
	int cy;
	int b1;
	int b2;
	int b3;
	int b4;

	bool alive;

	BITMAP *bFlash;
	int iTransparency;
	int flash_timer;

	int iLine_Trans;
	int life;

	int iCSize;

	void generate();
	void generate_up(int i);
	void generate_down(int i);
	void generate_left(int i);
	void generate_right(int i);

	SINGLE_BOLT *bBoltsUP[MAX_BOLTS];
	SINGLE_BOLT *bBoltsLEFT[MAX_BOLTS];
	SINGLE_BOLT *bBoltsRIGHT[MAX_BOLTS];
	SINGLE_BOLT *bBoltsDOWN[MAX_BOLTS];

	void init();

};

#endif /* End of _LIGHTNING_H_ */

