/**************************************************
*  FILE:  hsc.h			                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  8/1/2006                                *
*                                                 *
*  This object handles the High Score table, both *
*  local and online.                              *
**************************************************/

#ifndef _HSC_H_
#define _HSC_H_

#include "game.h"
#define CHAR_SIZE 20
#define MAX_STATS 40
#define MAX_ONLINE_STATS 100
typedef struct stats
{
	int level;
	int points;
	int version;
	char cversion[10];
	char cName[CHAR_SIZE];
} STATS;

class HSC
{
public:
	HSC();
	~HSC();

	bool local_update();
	void online_submit();
	bool online_check();
	void get_local();
	void get_online();
	void put_online();
	void destroy();
	void draw(BITMAP *bDisplay, int y, int S);
	void draw_online(BITMAP *bDisplay, int y, int S);
	void hsc_flip(STATS &s1, STATS &s2);
	void sort();

	int get_low();

private:
	
	STATS lStats[MAX_STATS];
	STATS oStats[MAX_ONLINE_STATS];

	BITMAP *bImage;

	void init();
	void clear();
	void clear_local();
	void clear_online();
	void online_sort();
	void set_online();
	long calculateCode(const char *name, int score);
	int get_online_version();
	//void get_hsc(char *in);


};

#endif /* End of _HSC_H_ */

