/**************************************************
*  FILE:  game.h                                  *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  4/29/2006                               *
*                                                 *
*  Used to initialize and oversee general game    *
*  functions.                                     *
**************************************************/

#ifndef _GAME_H_
#define _GAME_H_

//********** GAME VERSION ****************
#define VERSION "1.2.15"
#define fVERSION 1.0

#include "allegro.h"
#include "allegro_color.h"
#include "allegro_input.h"

#include "simple_gui.h"
#include "progress_bar.h"
#include "water.h"
#include "board.h"
#include "particle_engine.h"
#include "lightning.h"
#include "dj.h"
#include "score.h"
#include "penalty.h"
#include "hsc.h"
#include "data.h"
#include "configs.h"
#include "title.h"
#include "message.h"
typedef class HSC hsc;
typedef class BOARD board;
typedef class SIMPLE_GUI simple_gui;
typedef class PROGRESS_BAR progress_bar;
typedef class WATER water;
typedef class PARTICLE_ENGINE particle_engine;
typedef class LIGHTNING lightning;
typedef class SCORE score;
typedef class PENALTY penalty;
typedef class CONFIG configs;
typedef class TITLE titley;
typedef class MESSAGE message;
//typedef enum PENALTIES penalties;
//#include "world_map.h"
//#include "dj.h"

// ******* Screen Setup *******
//#define MODE GFX_AUTODETECT_WINDOWED
//#define MODE GFX_AUTODETECT_FULLSCREEN
#define GFX_W 640
#define GFX_H 480
extern BITMAP *buffer;

// ******* Timer Setup ********
extern volatile int draw_ticks;
extern volatile int ticks;
extern volatile int framerate;
extern volatile int system_time;
void timer1(void);
void timer2(void);

// ******* Music Setup ********
//extern DJ musics;


// ******* Translucent and Lighting Setup
extern PALETTE pal;
extern COLOR_MAP trans_table;
extern int gFade_Timer;
extern int gTransparency;
	

// ******* Functions *********
void init();
void logo_screen(bool status);
void play_game();
void game_init();
void game_setup();
void game_level();
void level_finish();
void game_update();
void game_draw();
void game_shutdown();
void shutdown();
BITMAP *create_bitmap_check(int width, int height);
BITMAP *create_sub_bitmap_check(BITMAP *bParent, int x, int y, int width, int height);
BITMAP *load_bitmap_check(char *cpath, RGB *pal);
char *convert_to_backslash(char *ctext);
bool screen_fade_in(int iTime);
bool screen_fade_out(int iTime);

// ******** GLOBALS ********
extern bool iFrameRate;


// ******** ENUMS ********
enum GAME_STATE{NO_STATE=0, TITLE_SCREEN, PLAY_GAME, PAUSED};

// ******** INPUT *********
extern INPUT gInput;

// ******* MAPPY ********


// ****** MISC ***********
extern int startpos;
#define CHAR_SIZE 20

#define MAX_MESSAGES 10

// ******** GAME STRUCTURE ***********
class games
{
public:
	SIMPLE_GUI *sToggles_Screen;
	WATER *wToggles_Water;
	BITMAP *bWater;
	BITMAP *bMouse;
	int iTemp;

	BOARD *bBoard;	
	PROGRESS_BAR *pTime_Progress;
	PARTICLE_ENGINE *peCombo;
	PARTICLE_ENGINE *peToggle_Stars;
	PARTICLE_ENGINE *peFire;	
	LIGHTNING *lLightning;

	BITMAP *bDim;
	PENALTY *pPenalty_Screen;
	int pCurrent_Penalty;

	DJ audio;

	CONFIG *configuration;
	TITLE *MainMenu;
	GAME_STATE state;

	DATAFILE *dat2;
	DATAFILE *dat3;
	DATAFILE *dat4;
	DATAFILE *mydat;
	FONT *score_font;
	PALETTE *score_palette;
	FONT *help_font;
	PALETTE *help_palette;
	SCORE *gScore;

	BITMAP *bLevel;

	MESSAGE *cMessages[MAX_MESSAGES];

	HSC *gHSC;
	
	char cName[CHAR_SIZE];

	int low_score;
	bool view_online;
	float version;

	int pause_ticks;
	int pause_system;

	int level;
	int iRows_Temp;
	int secs;
	float percent;
	int difficulty;
	bool next_level;

	bool over;
	bool quit;	

};

extern games GAME;



#endif /* End of _GAME_H_ */
