/**************************************************
*  FILE:  bonus.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/23/2006                               *
*                                                 *
**************************************************/

#ifndef _BONUS_H_
#define _BONUS_H_

#include "game.h"
typedef class games GAMES;
enum BONUSES {NONE = 0, CLOCK, BOMB, BOLT, BPERCENT, ULTIMA};

class BONUS
{
public:
	bool visible;

	BONUS();
	~BONUS();

	void reset(BONUSES bType, char *cArray, int X, int Y, int iW, int iH, int Max_Frames, int iSize);
	void destroy();
	void update(games gCurrent_Game, int mx, int my);
	void draw(BITMAP *bDisplay, int iW, int iH);
	void move();
	void place(int x, int y);
	void obtain(games gCurrent_Game, int mx, int my);
	bool use(games gCurrent_Game);
	

private:
	//Technically, this information would be stored in a sprite class, but meh
	int W;
	int H;
	int x;
	int y; 	
	int dx;
	int dy;
	BITMAP *bImage;
	BITMAP *bArray;
	int iFrame_X;
	int iMax_Frames;
	int animate_timer;
	int animate_delay;
	int move_timer;
	int Size;
	
	bool lock;
	bool deadlock;

	BONUSES type;

	void init();
};

#endif /* End of _BONUS_H_ */

