/**************************************************
*  FILE:  board.h		                          *
*  AUTHOR:  Steven Silvey                         *
*  DATE:  7/15/2006                               *
*                                                 *
*  Maintains the game board area where the toggles*
*  float above.                                   *
**************************************************/

#ifndef _BOARD_H_
#define _BOARD_H_

#include "game.h"
#include "toggle.h"
#include "water.h"
#include "bonus.h"
#include "progress_bar.h"
#include "option.h"
typedef class PROGRESS_BAR progress_bar;
typedef class TOGGLE toggle;
typedef class WATER water;
typedef class games GAMES;
typedef class BONUS bonus;
//typedef enum BONUSES bonuses;
typedef class OPTION option;

#define MAX_ROWS 40
#define MAX_COLUMNS 40
#define MAX_BONUSES 15
#define MAX_SLOTS 6



class BOARD
{
public:
	float fPercentage;
	float fTime;
	int iConsecutive;
	bool bFirst_Combo;
	bool bSecond_Combo;
	bool bThird_Combo;
	bool bFourth_Combo;
	int Combo_Timer;
	bool ultima;

	int bSlots_X[MAX_SLOTS];
	int bSlots_Y[MAX_SLOTS];


	BOARD();
	~BOARD();

	//void setup(games gCurrent_Game, int Row_Count, int W, int H, int Padding, float fNeeded, int iTime);
	void setup(int W, int H, int Padding, char *cpath, char *cpath1, char *cpath2);
	void resetup(games gCurrent_Game, int Row_Count, float fPercent, int iTime);

	void destroy();
	void destroy_bonuses();
	void reset_bonuses();
	void update(games &gCurrent_Game);
	void draw(games gCurrent_Game);
	void draw_bonuses(BITMAP *bDisplay);
	void draw_type(BITMAP *bDisplay, int index);
	void draw_buttons(BITMAP *bDisplay);
	void set_progress_max(float fNeeded);
	float progress_max();
	BITMAP *image();
	void generate_bonus(int iDifficulty, int x, int y);
	void clear_bonuses();
	void slide_bonuses();

	bool complete();

	void input(games gCurrent_Game);
	void use_bonus(games gCurrent_Game);

	void set_difficulty(int iValue);


	int  tile_size();
	void set_timer(int iTime);
	void reset_clock();
	void set_slot(int i, BONUS *bTemp);
	int current_slot();

	void toggle_down(games gCurrent_Game, int i, int j);
	int toggle_x(int mx, int my);
	int toggle_y(int mx, int my);




private:
	bool alive;
	BITMAP *bType[3];

	TOGGLE *tToggles[MAX_ROWS][MAX_COLUMNS];
	int iRow_Count;	

	bool ultima_complete;
	int ultima_size;
	int ultima_timer;
	int ultima_trans;

	OPTION *oHelp_Button;
	


	int iDifficulty;
	
	
	int iCurrent_Time;
	int iTimer;
	int iTimer_Offset;
	int input_timer;

	int iSize;
	int iSpace;

	int iWidth, iHeight;
	int iPadding;

	float fPCurrent_Max;
	float fPMax;

	PROGRESS_BAR *pToggle_Progress;
	bool bParticle_Effect;

	BONUS *bGift[MAX_BONUSES];
	BONUS *bSlots[MAX_SLOTS];
	
	void arrange_tiles(int Board_Size, int Padding, int Row_Count);
	void init();
	void board_game_over(games &gCurrent_Game);

	bool input_lock;
	BITMAP *bImage;	

};

#endif /* End of _BOARD_H_ */

