/**************************************************************
*  Name:     allegro_color.h                                  *
*  Date:     4/10/2005                                        *
*  Author:   Steven Silvey                                    *
*  Purpose:  Eases the use of color functionality in the      *
*           allegro gaming library.                           *
**************************************************************/

#ifndef _ALLEGRO_COLOR_H
#define _ALLEGRO_COLOR_H

// This structure is nice in that in packages the 3 different 
// colors that mix to form a single color
typedef struct color
{
	int red;			// The intensity of REDness
	int green;			// The intensity of GREENness
    int blue;			// The intensity of BLUEness
} COLOR;

// The next three functions return the respected color based 
// on a value from the mixed rgb value
int red(int color_value);
int green(int color_value);
int blue(int color_value);

// This function takes the mixed rgb value and splits up the
// main three colors into a COLOR struct
COLOR getColor(int color_value);

// The next two functions return a mixed rgb value based on
// given information.  rgb is the same thing as make_col in
// allegro.
int rgb(int red, int green, int blue);
int rgb(COLOR color_data);

// The following is a list of predefined colors taken from
// the CMUgraphics library.  They can be used in place of
// writing the rgb function.  Disclaimer for rights can 
// be found at the bottom.
//******************* WHITES **************************
extern const int WHITE;
extern const int SNOW;
extern const int GHOSTWHITE;
extern const int WHITESMOKE;
extern const int GAINSBORO;
extern const int FLORALWHITE;
extern const int OLDLACE;
extern const int LINEN;
extern const int ANTIQUEWHITE;
extern const int PAPAYAWHIP;
extern const int BLANCHEDALMOND;
extern const int BISQUE;
extern const int PEACHPUFF;
extern const int NAVAJOWHITE;
extern const int MOCCASIN;
extern const int CORNSILK;
extern const int IVORY;
extern const int LEMONCHIFFON;
extern const int SEASHELL;
extern const int HONEYDEW;
extern const int MINTCREAM;

//******************* BLACKS **************************
extern const int BLACK;
extern const int DARKSLATEGRAY;
extern const int DARKSLATEGREY;
extern const int DIMGRAY;
extern const int DIMGREY;
extern const int SLATEGRAY;
extern const int SLATEGREY;
extern const int LIGHTSLATEGRAY;
extern const int LIGHTSLATEGREY;
extern const int GRAY;
extern const int GREY;
extern const int LIGHTGREY;
extern const int LIGHTGRAY;

//******************* BLUES ***************************
extern const int MIDNIGHTBLUE;
extern const int NAVY;
extern const int NAVYBLUE;
extern const int CORNFLOWERBLUE;
extern const int DARKSLATEBLUE;
extern const int SLATEBLUE;
extern const int MEDIUMSLATEBLUE;
extern const int LIGHTSLATEBLUE;
extern const int MEDIUMBLUE;
extern const int ROYALBLUE;
extern const int BLUE;
extern const int DODGERBLUE;
extern const int DEEPSKYBLUE;
extern const int SKYBLUE;
extern const int LIGHTSKYBLUE;
extern const int STEELBLUE;
extern const int LIGHTSTEELBLUE;
extern const int LIGHTBLUE;
extern const int POWDERBLUE;
extern const int PALETURQUOISE;
extern const int DARKTURQUOISE;
extern const int MEDIUMTURQUOISE;
extern const int TURQUOISE;
extern const int CYAN;
extern const int LIGHTCYAN;
extern const int CADETBLUE;
extern const int MEDIUMAQUAMARINE;
extern const int AQUAMARINE;

//******************* GREENS **************************
extern const int DARKGREEN;
extern const int DARKOLIVEGREEN;
extern const int DARKSEAGREEN;
extern const int SEAGREEN;
extern const int MEDIUMSEAGREEN;
extern const int LIGHTSEAGREEN;
extern const int PALEGREEN;
extern const int SPRINGGREEN;
extern const int LAWNGREEN; 
extern const int GREEN; 
extern const int CHARTREUSE; 
extern const int MEDIUMSPRINGGREEN;
extern const int GREENYELLOW; 
extern const int LIMEGREEN; 
extern const int YELLOWGREEN;
extern const int FORESTGREEN;
extern const int OLIVEDRAB;

//******************* YELLOWS *************************
extern const int DARKKHAKI; 
extern const int KHAKI; 
extern const int PALEGOLDENROD; 
extern const int LIGHTGOLDENRODYELLOW; 
extern const int LIGHTYELLOW; 
extern const int YELLOW; 
extern const int GOLD; 
extern const int LIGHTGOLDENROD; 
extern const int GOLDENROD; 
extern const int DARKGOLDENROD;
extern const int ROSYBROWN; 
extern const int INDIAN; 
extern const int INDIANRED; 
extern const int SADDLEBROWN;
extern const int SIENNA; 
extern const int PERU; 

//******************* BROWNS **************************
extern const int BURLYWOOD; 
extern const int BEIGE; 
extern const int WHEAT; 
extern const int SANDYBROWN; 
extern const int TAN; 
extern const int CHOCOLATE; 
extern const int FIREBRICK; 
extern const int BROWN; 
extern const int DARKSALMON; 
extern const int SALMON; 
extern const int LIGHTSALMON;

//******************* ORANGES *************************
extern const int ORANGE; 
extern const int DARKORANGE;
extern const int CORAL; 
extern const int LIGHTCORAL; 

//******************* REDS ****************************
extern const int TOMATO; 
extern const int ORANGERED; 
extern const int RED; 
extern const int HOTPINK; 
extern const int DEEPPINK; 
extern const int PINK; 
extern const int LIGHTPINK; 
extern const int PALEVIOLETRED; 
extern const int MAROON; 
extern const int MEDIUMVIOLETRED; 
extern const int VIOLETRED; 
extern const int MASK; 

//******************* PURPLES *************************
extern const int VIOLET; 
extern const int PLUM; 
extern const int ORCHID;
extern const int MEDIUMORCHID; 
extern const int DARKORCHID; 
extern const int DARKVIOLET; 
extern const int BLUEVIOLET; 
extern const int PURPLE; 
extern const int MEDIUMPURPLE; 
extern const int THISTLE; 

//******************* OTHER ***************************
extern const int DARKGREY; 
extern const int DARKGRAY; 
extern const int DARKBLUE; 
extern const int DARKCYAN; 
extern const int DARKMAGENTA; 
extern const int DARKRED; 
extern const int LIGHTGREEN;

extern const int AZURE;
extern const int ALICEBLUE;
extern const int LAVENDER;
extern const int LAVENDERBLUSH;
extern const int MISTYROSE;


/* DISCLAIMER

CMUgraphics Library 1.2 
Copyright (c) 1998 and 1999 by Geoff Washburn.  All rights reserved.

  1. Redistribution of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistribution in binary form must reproduce the above 
     copyright notice, this list of conditions and the following 
     disclaimer in the documentation and/or other materials 
     provided with the distribution.
  3. When redistributing a modified version of this library it must 
     carry prominent notices stating the name of individual(s) that 
     altered the files, the nature of the modifications, and the 
     date they were performed.
  4. No fee is charged for redistribution or use without prior 
     written permission from the author.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;  OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

// MODIFICATIONS - Steven Silvey
// The list was changed to ints instead of the defined color
// class in the CMUgraphics library to better suit its purpose
// here.

#endif /* End of _ALLEGRO_COLOR_H */

