varying vec2 t_coord;
uniform sampler2D sky;
uniform sampler2D rtex;
uniform sampler2D bump;
uniform vec2 coef;

void main()
{
	vec3 R = 2.0*texture2D(bump, t_coord)-vec3(1.0,1.0,1.0);
	vec2 scr_pos_r = t_coord+0.005*R.xz;
	if (scr_pos_r.x<0.0)	scr_pos_r.x=0.0;
	else if (scr_pos_r.x>1.0)	scr_pos_r.x=1.0;
	if (scr_pos_r.y<0.0)	scr_pos_r.y=0.0;
	else if (scr_pos_r.y>1.0) scr_pos_r.y=1.0;
	vec4 ref = texture2D(sky, scr_pos_r);
	float trans = 0.33;//clamp(dot(vec3(0.0,-1.0,0.0),R),0.0,1.0);
	vec2 scr_pos = t_coord*coef-0.005*R.xz;//+0.01*N.xy;
	if (scr_pos.x<0.0)	scr_pos.x=0.0;
	else if (scr_pos.x>1.0)	scr_pos.x=1.0;
	if (scr_pos.y<0.0)	scr_pos.y=0.0;
	else if (scr_pos.y>1.0) scr_pos.y=1.0;
	vec4 scr_col = vec4(0.5,0.7,1.0,1.0)*texture2D(rtex,scr_pos);
	gl_FragColor = vec4(mix(ref,scr_col,trans).rgb,0.8);
	float lava = texture2D(bump,t_coord).w;
	if (lava == 0.0)
		gl_FragColor = vec4(0.0,0.0,0.0,1.0);
	else {
		vec4 lava_col = vec4(1.0,0.2,0.2,1.0)*texture2D(rtex,scr_pos);
		gl_FragColor = mix(gl_FragColor,lava_col,lava * 2.0 - 1.0);
		}
}
