varying vec2 t_coord;
uniform vec2 coef;
uniform sampler2D sky;
uniform sampler2D rtex;
uniform sampler2D bump;

void main()
{
	vec3 R = 2.0*texture2D(bump,t_coord).xyz-vec3(1.0,1.0,1.0);
	vec4 ref = texture2D(sky, R.xz*0.5+vec2(0.5,0.5));
	float trans = 0.33;
	vec2 scr_pos = t_coord*coef-0.005*R.xz;
	if (scr_pos.x<0.0)	scr_pos.x=0.0;
	else if (scr_pos.x>1.0)	scr_pos.x=1.0;
	if (scr_pos.y<0.0)	scr_pos.y=0.0;
	else if (scr_pos.y>1.0) scr_pos.y=1.0;
	vec4 scr_col = vec4(0.7,0.8,1.0,1.0)*texture2D(rtex,scr_pos);
	gl_FragColor = vec4(mix(ref,scr_col,trans).rgb,0.8);
	float lava = texture2D(bump,t_coord).w;
	if (lava == 0.0)
		gl_FragColor = vec4(0.0,0.0,0.0,1.0);
	else {
		vec4 lava_col = vec4(1.0,0.2,0.2,1.0)*texture2D(rtex,scr_pos);
		gl_FragColor = mix(gl_FragColor,lava_col,lava * 2.0 - 1.0);
		}
}
