/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                       music.cpp                                    |
|  ce fichier contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers musicaux (mp3/ogg) pendant le jeu en fonction de l'état de la partie. |
| La liste de lecture est créée automatiquement s'il n'y en a pas et est modifiable. |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#include "../config.h"			// Configuration de TA3D à la compilation
#include <allegro.h>
#include "music.h"
#include "console.h"

#if USE_MP3 || USE_OGG

void MUSIC_STREAM::poll()
{
	switch(type)
	{
	case MUSIC_NONE:
		break;
	case MUSIC_MP3:
#if USE_MP3
		if(mp3) {
			if(almp3_poll_mp3stream(mp3)==ALMP3_POLL_PLAYJUSTFINISHED || voice_get_volume(voice)==0)		// Si le fichier est entièrement lu ou que le volume tombe à 0
				destroy();
			else {																							// Sinon lit un bout du fichier
				byte *buf=(byte*) almp3_get_mp3stream_buffer(mp3);
				if(buf) {
					int len=pack_fread(buf,32768,file);
					almp3_free_mp3stream_buffer(mp3,len<32768 ? len : -1);
					}
				}
			}
#endif
		break;
	case MUSIC_OGG:
#if USE_OGG
		if(voice_get_volume(voice)==0)			// Si le volume tombe à 0 on arrête
			destroy();
		else
			if(alogg_update_streaming(ogg)==0)		// Sinon on lit le fichier jusqu'au bout
				destroy();
#endif
		break;
	};
}

void MUSIC_STREAM::play(char *filename)
{
	destroy();

	if(strstr(filename,".mp3")!=NULL || strstr(filename,".MP3")!=NULL || strstr(filename,".Mp3")!=NULL || strstr(filename,".mP3")!=NULL) {
		type=MUSIC_MP3;
		}
	else
		type=MUSIC_OGG;

	switch(type)
	{
	case MUSIC_MP3:
#if USE_MP3
		file=pack_fopen(filename,F_READ);			// Ouvre le fichier

		data=new byte[32768];
		{
			int len=pack_fread(data,32768,file);

			mp3=almp3_create_mp3stream(data,len,len<32768);
			if(mp3) {
				almp3_play_ex_mp3stream(mp3,65536,100,50,1000);
				voice=almp3_get_audiostream_mp3stream(mp3)->voice;
				}
		}
#endif
		break;
	case MUSIC_OGG:
#if USE_OGG
		ogg=alogg_start_streaming(filename,32768);
		voice=alogg_get_audio_stream(ogg)->voice;
#endif
		break;
	};
	voice_set_volume(voice, 1);
	voice_ramp_volume(voice, 2000, 100);
}

void MUSIC_MANAGER::load_play_list()
{
	destroy();
	if(file_exists("music/playlist.txt",FA_RDONLY | FA_ARCH,NULL)) {		// Si la liste de lecture existe on la récupère
		FILE *file=fopen("music/playlist.txt","rb");
		char buf[100];
		fgets(buf,100,file);
		if(strstr(buf,"nb_files=")==NULL) {
			fclose(file);		return;
			}
		nb_files=atoi(strstr(buf,"nb_files=")+9);
		list=new char*[nb_files];
		type=new byte[nb_files];
		for(int i=0;i<nb_files;i++) {			// Charge la liste de lecture
			fgets(buf,100,file);
			for(int e=0;e<100;e++)
				if(buf[e]==10 || buf[e]==13)	buf[e]=0;
			type[i]=MUSIC_TYPE_NONE;
			if(strstr(buf,"BATTLE="))	type[i]=MUSIC_TYPE_BATTLE;
			list[i]=strdup(strstr(buf,"=")+1);
			}
		fclose(file);
		}
	else {																	// Sinon on en crée une nouvelle
		nb_files=0;
		list=NULL;
		al_ffblk search;
#if USE_MP3
		if(al_findfirst("music/*.mp3",&search,FA_RDONLY | FA_ARCH)==0) {	// Compte le nombre de fichiers jouables
			nb_files++;
			while(al_findnext(&search)==0) nb_files++;
			}
		al_findclose(&search);
#endif
#if USE_OGG
		if(al_findfirst("music/*.ogg",&search,FA_RDONLY | FA_ARCH)==0) {	// Compte le nombre de fichiers jouables
			nb_files++;
			while(al_findnext(&search)==0) nb_files++;
			}
		al_findclose(&search);
#endif
		if(nb_files>0) {
			list=new char*[nb_files];
			type=new byte[nb_files];
			for(int i=0;i<nb_files;i++) {
				list[i]=NULL;
				type[i]=MUSIC_TYPE_NONE;
				}
			}
		int i=0;
#if USE_MP3
		if(al_findfirst("music/*.mp3",&search,FA_RDONLY | FA_ARCH)==0) {
			char name[1000];
			name[0]=0;
			strcat(name,"music/");
			strcat(name,search.name);
			list[i++]=strdup(name);
			while(al_findnext(&search)==0) {
				name[0]=0;
				strcat(name,"music/");
				strcat(name,search.name);
				list[i++]=strdup(name);
				}
			}
		al_findclose(&search);
#endif
#if USE_OGG
		if(al_findfirst("music/*.ogg",&search,FA_RDONLY | FA_ARCH)==0) {
			char name[1000];
			name[0]=0;
			strcat(name,"music/");
			strcat(name,search.name);
			list[i++]=strdup(name);
			while(al_findnext(&search)==0) {
				name[0]=0;
				strcat(name,"music/");
				strcat(name,search.name);
				list[i++]=strdup(name);
				}
			}
		al_findclose(&search);
#endif
		}
}

void MUSIC_MANAGER::save_play_list()
{
	if(nb_files<=0)	return;		// La liste est vide
	FILE *file=fopen("music/playlist.txt","wb");
	char buf[100];
	uszprintf(buf,100,"nb_files=%d\n",nb_files);
	fputs(buf,file);
	for(int i=0;i<nb_files;i++) {
		if(type[i])
			uszprintf(buf,100,"BATTLE=%s\n",list[i]);
		else
			uszprintf(buf,100,"=%s\n",list[i]);
		fputs(buf,file);
		}
	fclose(file);
}

void MUSIC_MANAGER::poll()
{
	if(nb_files<=0)	return;
	cur.poll();			// Joue la musique qui doit être jouée
	old.poll();

	if(cur.type==MUSIC_NONE) {		// La musique s'est arrêtée
		int	next=(rand()%nb_files)+1;
		int	idx=0;
		int	tries=0;
		while(next>0 && tries<=nb_files*nb_files) {
			tries++;
			if(type[idx]==game_state) {
				next--;
				if(next==0)
					break;
				}
			idx=++idx%nb_files;
			}
		char tmp[200];
		uszprintf(tmp,200,"playing %s",list[idx]);
		Console->AddEntry(tmp);
		cur.play(list[idx]);		// Lance la musique
		}
}

void MUSIC_MANAGER::change_state(byte new_state)
{
	if(new_state==game_state)	return;		// On n'a rien à changer

	old.destroy();		// Fait le ménage
	old=cur;
	old.stop();			// programme l'arrêt de la musique

	cur.init();			// Le fait de transférer cur dans old va déclencher le chargement d'une nouvelle piste au prochain poll
	game_state=new_state;
}

MUSIC_MANAGER	music_manager;

#endif
