/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------\
|                                     ia.cpp                                   |
|       Ce module est responsable de l'intelligence artificielle               |
|                                                                              |
\-----------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "3do.h"					// Pour la lecture des fichiers 3D
#include "cob.h"					// Pour la lecture et l'éxecution des scripts
#include "tdf.h"					// Pour la gestion des éléments du jeu
#include "EngineClass.h"			// Inclus le moteur
//#include "ia.h"

void BRAIN::save(FILE *file)		// Enregistre le réseau de neurones
{
	fwrite("BRAIN",5,1,file);			// Identifiant du format du fichier
	fwrite(&n,sizeof(int),1,file);		// Nombre d'entrées
	fwrite(&p,sizeof(int),1,file);		// Nombre de sorties
	fwrite(&q,sizeof(int),1,file);		// Taille de la couche intermédiaire

	for(int i=n;i<nb_neuron;i++)		// Enregistre les poids
		if(i<n+q)
			fwrite(neuron[i].weight,sizeof(float)*n,1,file);
		else
			fwrite(neuron[i].weight,sizeof(float)*q,1,file);
}

int BRAIN::load(FILE *file)		// Charge le réseau de neurones
{
	char tmp[6];

	fread(tmp,5,1,file);				// Identifiant du format du fichier
	tmp[5]=0;
	if(strcmp(tmp,"BRAIN")!=0)	{		// Vérifie si le fichier est bien du type attendu
		return 1;
		}

	destroy();		// Au cas où

	fread(&n,sizeof(int),1,file);		// Nombre d'entrées
	fread(&p,sizeof(int),1,file);		// Nombre de sorties
	fread(&q,sizeof(int),1,file);		// Taille de la couche intermédiaire
	nb_neuron=p+q+n;

	neuron=(NEURON*) malloc(sizeof(NEURON)*nb_neuron);
	n_out=(float*) malloc(sizeof(float)*p);

	for(int i=0;i<p;i++)
		n_out[i]=0.0f;

	for(int i=0;i<n;i++)
		neuron[i].weight=NULL;

	for(int i=n;i<nb_neuron;i++)		// Lit les poids
		if(i<n+q) {
			neuron[i].weight=(float*) malloc(sizeof(float)*n);
			fread(neuron[i].weight,sizeof(float)*n,1,file);
			}
		else {
			neuron[i].weight=(float*) malloc(sizeof(float)*q);
			fread(neuron[i].weight,sizeof(float)*q,1,file);
			}

	return 0;
}

BRAIN *copy_brain(BRAIN *brain,BRAIN *dst)			// Copie un réseau de neurones
{
	BRAIN *copy=dst;
	if(copy==NULL)
		copy=(BRAIN*) malloc(sizeof(BRAIN));
	copy->init();
	copy->nb_neuron=brain->nb_neuron;
	copy->n=brain->n;
	copy->p=brain->p;
	copy->q=brain->q;
	copy->neuron=(NEURON*) malloc(sizeof(NEURON)*copy->nb_neuron);
	copy->n_out=(float*) malloc(sizeof(float)*copy->p);
	for(int i=0;i<brain->nb_neuron;i++) {
		if(i<brain->p)
			copy->n_out[i]=0.0f;
		if(brain->neuron[i].weight==NULL)
			copy->neuron[i].weight=NULL;
		else {
			if(i>=copy->n && i<copy->nb_neuron-copy->p) {
				copy->neuron[i].weight=(float*) malloc(sizeof(float)*brain->q);
				for(int e=0;e<brain->q;e++)
					copy->neuron[i].weight[e]=brain->neuron[i].weight[e];
				}
			else if(i>=copy->n) {
				copy->neuron[i].weight=(float*) malloc(sizeof(float)*brain->n);
				for(int e=0;e<brain->n;e++)
					copy->neuron[i].weight[e]=brain->neuron[i].weight[e];
				}
			else
				copy->neuron[i].weight=NULL;
			}
		}
	return copy;
}

inline byte int2brain_value(int a)			// Evaluateur de quantité pour réseau de neurones
{
	if(a==0)	return BRAIN_VALUE_NULL;
	if(a<=5)	return BRAIN_VALUE_LOW;
	if(a<=15)	return BRAIN_VALUE_MEDIUM;
	if(a<=50)	return BRAIN_VALUE_HIGH;
	return BRAIN_VALUE_MAX;
}

inline int get_bits(float bits[],byte v,int pos)	// Remplit le tableau de bits (entrée des réseaux de neurones)
{
	for(int i=0;i<BRAIN_VALUE_BITS;i++)
		bits[pos++]=((v>>i)&1) ? 1.0f : 0.0f;
	return pos;
}

void AI_PLAYER::think(MAP *map)				// La vrai fonction qui simule l'Intelligence Artificielle
{
	return;							// Shortcut to prevent execution of this function because AI will be finished later

	bool change=false;
	int limit=min(units.last_index,player_id*MAX_UNIT_PER_PLAYER+players.nb_unit[player_id]-1);

	/*--------------Analyse du champ de vision des unités------------------------------------------*/

	if(unit_id<=limit) {
		if(units.unit[unit_id].flags!=0 && units.unit[unit_id].owner_id==player_id) {
			int r=unit_manager.unit_type[units.unit[unit_id].type_id].SightDistance+(int)(units.unit[unit_id].h+0.5f)>>4;
			int px=(int)(units.unit[unit_id].Pos.x+0.5f*map->map_w+0.5f)>>4;
			int py=(int)(units.unit[unit_id].Pos.z+0.5f*map->map_h+0.5f)>>4;
			int r2=r*r;
			int enemy_mx=0, enemy_my=0;
			int metal_mx=0, metal_my=0;
			int energy_mx=0, energy_my=0;
			int enemy_nb=0;
			int metal_nb=0;
			int energy_nb=0;
			byte enemy_type=0;
			for(int y=0;y<=r;y++) {
				int x=(int)(sqrt(r2-y*y)+0.5f);
				int ry=py-y;
				if(ry>=0 && ry<map->bloc_h)
					for(int rx=px-x;rx<=px+x;rx++)
						if(rx>=0 && rx<map->bloc_w) {
							if(map->map_data[ry<<1][rx<<1].unit_idx>=0) {	// Unité??
								if(units.unit[map->map_data[ry<<1][rx<<1].unit_idx].owner_id!=player_id) {		// Ennemi ??
									enemy_mx+=rx;
									enemy_my+=ry;
									enemy_nb++;
									switch(unit_manager.unit_type[units.unit[map->map_data[ry<<1][rx<<1].unit_idx].type_id].TEDclass)
									{
									case CLASS_UNDEF:
									case CLASS_ENERGY:
									case CLASS_SPECIAL:
									case CLASS_FORT:
									case CLASS_METAL:
									case CLASS_COMMANDER:
									case CLASS_CNSTR:
										enemy_type|=UNIT_TYPE_UNKN;
										break;
									case CLASS_WATER:
									case CLASS_SHIP:
										enemy_type|=UNIT_TYPE_SHIP;
										break;
									case CLASS_VTOL:
										enemy_type|=UNIT_TYPE_VTOL;
										break;
									case CLASS_KBOT:
										enemy_type|=UNIT_TYPE_KBOT;
										break;
									case CLASS_PLANT:
										enemy_type|=UNIT_TYPE_PLANT;
										break;
									case CLASS_TANK:
										enemy_type|=UNIT_TYPE_TANK;
										break;
									};
									}
								}
							if(map->map_data[ry][rx].stuff>=0) {		// Un élément de décors??
								if(feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].energy>0) {		// Energie
									energy_mx+=px*feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].energy;
									energy_my+=py*feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].energy;
									energy_nb+=feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].energy;
									}
								if(feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].metal>0) {		// Metal
									metal_mx+=px*feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].metal;
									metal_my+=py*feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].metal;
									metal_nb+=feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].metal;
									}
								}
							}
				}
			if(enemy_nb>0) {			// Ennemis repérés
				ZONE enemy_zone;
				enemy_zone.type=ZONE_ENEMY;
//				enemy_zone.Pos=units.unit[unit_id].Pos;
				enemy_zone.Pos.y=units.unit[unit_id].Pos.y;
				enemy_zone.Pos.x=enemy_mx*16.0f/enemy_nb-0.5f*map->map_w;
				enemy_zone.Pos.z=enemy_my*16.0f/enemy_nb-0.5f*map->map_h;
				enemy_zone.size=r<<4;
//				enemy_zone.brain_value=int2brain_value(enemy_nb);
				enemy_zone.brain_value=enemy_nb;
				change|=strategic_data.fusion_zone(enemy_zone);
				}
			else {
				ZONE enemy_zone;
				enemy_zone.type=ZONE_ENEMY;
				enemy_zone.Pos=units.unit[unit_id].Pos;
				enemy_zone.size=r<<4;
				change|=strategic_data.remove_data(enemy_zone);
				}
			if(energy_nb>0) {			// Energie repérée
				ZONE energy_zone;
				energy_zone.type=ZONE_ENERGY;
//				energy_zone.Pos=units.unit[unit_id].Pos;
				energy_zone.Pos.y=units.unit[unit_id].Pos.y;
				energy_zone.Pos.x=energy_mx*16.0f/energy_nb-0.5f*map->map_w;
				energy_zone.Pos.z=energy_my*16.0f/energy_nb-0.5f*map->map_h;
//				energy_zone.brain_value=int2brain_value(energy_nb);
				energy_zone.brain_value=energy_nb;
				energy_zone.size=r<<4;
				change|=strategic_data.fusion_zone(energy_zone);
				}
			else {
/*				ZONE energy_zone;
				energy_zone.type=ZONE_ENERGY;
				energy_zone.Pos=units.unit[unit_id].Pos;
				energy_zone.size=r<<4;
				change|=strategic_data.remove_data(energy_zone);*/
				}
			if(metal_nb>0) {			// Metal repéré
				ZONE metal_zone;
				metal_zone.type=ZONE_METAL;
//				metal_zone.Pos=units.unit[unit_id].Pos;
				metal_zone.Pos.y=units.unit[unit_id].Pos.y;
				metal_zone.Pos.x=metal_mx*16.0f/metal_nb-0.5f*map->map_w;
				metal_zone.Pos.z=metal_my*16.0f/metal_nb-0.5f*map->map_h;
//				metal_zone.brain_value=int2brain_value(metal_nb);
				metal_zone.brain_value=metal_nb;
				metal_zone.size=r<<4;
				change|=strategic_data.fusion_zone(metal_zone);
				}
			else {
/*				ZONE metal_zone;
				metal_zone.type=ZONE_METAL;
				metal_zone.Pos=units.unit[unit_id].Pos;
				metal_zone.size=r<<4;
				change|=strategic_data.remove_data(metal_zone);*/
				}
			}
		}
	else
		unit_id=MAX_UNIT_PER_PLAYER*player_id-1;

	unit_id++;

	/*---------------------------------------------------------------------------------------------*/

	/*------------Conception d'une stratégie-------------------------------------------------------*/

	if(change || strategy.orders==NULL) {			// S'il faut changer de stratégie

		if(change)
			strategy.destroy();		// Oublie ce qui a été pensé avant

			/* évalue la situation */
		byte min_nb_zone=int2brain_value(strategic_data.min_zone_number());
		byte metal_stock=int2brain_value((int)(players.metal[player_id]*100/players.metal_s[player_id]));
		byte energy_stock=int2brain_value((int)(players.energy[player_id]*100/players.energy_s[player_id]));
		byte enemy_nb=int2brain_value(strategic_data.enemy_zone_number());
		byte energy_av=int2brain_value(strategic_data.energy_zone_number());
		byte metal_av=int2brain_value(strategic_data.metal_zone_number());
		int nb_builders=0, nb_units=0, nb_army=0;
		for(int i=player_id*MAX_UNIT_PER_PLAYER;i<=limit;i++)
			if(units.unit[i].flags && units.unit[i].owner_id==player_id) {
				nb_units++;
				if(unit_manager.unit_type[units.unit[i].type_id].Builder)
					nb_builders++;
				if(unit_manager.unit_type[units.unit[i].type_id].canattack)
					nb_army++;
				}
		byte builders=int2brain_value(nb_builders);
		byte army=int2brain_value(nb_army);
		byte nbunits=int2brain_value(nb_units);
		int	bits_needed=9*BRAIN_VALUE_BITS;
		float bits[bits_needed];

		if(decider.n!=bits_needed || decider.p!=NB_ORDERS) {		// Crée un réseau de neurones si besoin
			decider.destroy();
			decider.build(bits_needed,NB_ORDERS,bits_needed<<1);
			}

		int pos=0;
		pos=get_bits(bits,min_nb_zone,pos);
		pos=get_bits(bits,metal_stock,pos);
		pos=get_bits(bits,energy_stock,pos);
		pos=get_bits(bits,enemy_nb,pos);
		pos=get_bits(bits,energy_av,pos);
		pos=get_bits(bits,metal_av,pos);
		pos=get_bits(bits,builders,pos);
		pos=get_bits(bits,army,pos);
		pos=get_bits(bits,nbunits,pos);

//		printf("%s réfléchis!!\n",name);

		float *result=decider.work(bits);			// Le réseau de neurones analyse les données

		float m=-1.0f;
		int best=0;
		while(true) {
			m=-1.0f;
			best=0;
			for(int i=0;i<NB_ORDERS;i++)		// Détermine le meilleur ordre à donner d'après le réseau de neurones
				if(result[i]>m) {
					m=result[i];
					best=i;
					}

			if(m<0.0f)	break;
			result[best]=-1.0f;

			S_ORDER *n_order = new S_ORDER;		// Nouvel ordre

			n_order->type=best;		// Enregistre l'ordre

			switch(best)		// Prétraitement
			{
			case ORDER_ATTACK:
				{
					int zone_idx=-1;
					for(int i=0;i<strategic_data.nb_zone;i++)
						if(strategic_data.zone[i].type==ZONE_ENEMY)
							if(zone_idx==-1 || strategic_data.zone[zone_idx].brain_value<strategic_data.zone[i].brain_value)
								zone_idx=i;
					if(zone_idx>=0) {
						n_order->pos=strategic_data.zone[zone_idx].Pos;
						for(int i=player_id*MAX_UNIT_PER_PLAYER;i<=limit;i++)	// Dresse la liste des unités inactives capables d'attaquer
							if(units.unit[i].flags && units.unit[i].owner_id==player_id && unit_manager.unit_type[units.unit[i].type_id].canmove && unit_manager.unit_type[units.unit[i].type_id].canattack
							&& (unit_manager.unit_type[units.unit[i].type_id].Category & _WEAPON) && (unit_manager.unit_type[units.unit[i].type_id].Category & COMMANDER)!=COMMANDER)
								if(units.unit[i].do_nothing())	{
									LIST *l=new LIST;
									l->next=n_order->list;
									l->data=i;
									n_order->list=l;		// Ajoute l'unité à la liste
									}
						}
				}
				break;
			case ORDER_MOVE:
				break;
			case ORDER_RECLAIM:
				break;
			case ORDER_BUILD:
				break;
			case ORDER_PATROL:
				break;
			case ORDER_SPY:
				break;
			case ORDER_BUILD_ARMY:
				break;
			case ORDER_RESSOURCE:
				break;
			case ORDER_EXPLORE:
				break;
			};

			strategy.add_order(n_order);		// Ajoute l'ordre à la liste
			
			}
		}

	/*---------------------------------------------------------------------------------------------*/

	/*------------Applique la stratégie créée------------------------------------------------------*/

	if(strategy.orders!=NULL) {						// S'il y a une stratégie
		bool next_order=false;
		LIST *l=strategy.orders->list;
		switch(strategy.orders->type)
		{
		case ORDER_ATTACK:								// Ordre d'attaquer
#ifdef PRINT_ORDER
			printf("ordre d'attaquer\n");
#endif
			for(int i=player_id*MAX_UNIT_PER_PLAYER;i<=limit;i++)
				if(units.unit[i].flags && units.unit[i].owner_id==player_id)
					units.unit[i].sel=false;
			while(l) {
				if(units.unit[l->data].flags && units.unit[l->data].owner_id==player_id)
					units.unit[l->data].sel=true;
				l=l->next;
				}
			units.give_order_move(player_id,strategy.orders->pos,true,1);
			next_order=true;
			break;
		case ORDER_MOVE:								// Ordre de déplacer des troupes
#ifdef PRINT_ORDER
			printf("ordre de déplacer des troupes\n");
#endif
			for(int i=player_id*MAX_UNIT_PER_PLAYER;i<=limit;i++)
				if(units.unit[i].flags && units.unit[i].owner_id==player_id)
					units.unit[i].sel=false;
			while(l) {
				if(units.unit[l->data].flags && units.unit[l->data].owner_id==player_id)
					units.unit[l->data].sel=true;
				l=l->next;
				}
			units.give_order_move(player_id,strategy.orders->pos,true,1);
			next_order=true;
			break;
		case ORDER_RECLAIM:								// Ordre de récupérer des ressources sur le terrain
#ifdef PRINT_ORDER
			printf("ordre de récupérer des ressources\n");
#endif
			next_order=true;
			break;
		case ORDER_BUILD:								// Ordre de construire des bâtiments
#ifdef PRINT_ORDER
			printf("ordre de construire des bâtiments\n");
#endif
			if(l) {
				for(int i=player_id*MAX_UNIT_PER_PLAYER;i<=limit;i++)
					if(units.unit[i].flags && units.unit[i].owner_id==player_id && unit_manager.unit_type[units.unit[i].type_id].Builder)
						if(units.unit[i].mission==NULL || units.unit[i].mission->mission==MISSION_STOP
						|| units.unit[i].mission->mission==MISSION_STANDBY || units.unit[i].mission->mission==MISSION_VTOL_STANDBY)
							if(unit_manager.unit_type[units.unit[i].type_id].canbuild(l->data)) {
								break;
								}
				strategy.orders->list=l->next;
				delete l;
				}
			if(l==NULL)
				next_order=true;
			break;
		case ORDER_PATROL:								// Ordre de patrouiller dans un secteur de la carte
#ifdef PRINT_ORDER
			printf("ordre de patrouiller\n");
#endif
			next_order=true;
			break;
		case ORDER_SPY:									// Ordre d'espionner une zone
#ifdef PRINT_ORDER
			printf("ordre d'espionner\n");
#endif
			next_order=true;
			break;
		case ORDER_BUILD_ARMY:							// Ordre de construire une armée
#ifdef PRINT_ORDER
			printf("ordre de construire une armée\n");
#endif
			if(l) {
				for(int i=player_id*MAX_UNIT_PER_PLAYER;i<=limit;i++)
					if(units.unit[i].flags && units.unit[i].owner_id==player_id
					&& unit_manager.unit_type[units.unit[i].type_id].Builder && unit_manager.unit_type[units.unit[i].type_id].TEDclass==CLASS_PLANT)
						if(units.unit[i].mission==NULL || units.unit[i].mission->mission==MISSION_STOP
						|| units.unit[i].mission->mission==MISSION_STANDBY || units.unit[i].mission->mission==MISSION_VTOL_STANDBY)
							if(unit_manager.unit_type[units.unit[i].type_id].canbuild(l->data)) {
								units.give_order_build(player_id,l->data,units.unit[i].Pos,false);
								break;
								}
				strategy.orders->list=l->next;
				delete l;
				}
			if(l==NULL)
				next_order=true;
			break;
		case ORDER_RESSOURCE:							// Ordre d'extraire des ressources
#ifdef PRINT_ORDER
			printf("ordre d'extraire des ressources\n");
#endif
			next_order=true;
			break;
		case ORDER_EXPLORE:								// Ordre d'explorer la carte
#ifdef PRINT_ORDER
			printf("ordre d'explorer\n");
#endif
			next_order=true;
			break;
		};

		if(next_order)
			strategy.next_order();				// Ordre suivant
		}

	/*---------------------------------------------------------------------------------------------*/
}
