/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

#include "ta3dbase.h"

int expected_players;

int LANG=LANG_FRENCH;

int CURSOR_MOVE;
int CURSOR_GREEN;
int CURSOR_CROSS;
int CURSOR_RED;
int CURSOR_LOAD;
int CURSOR_GUARD;
int CURSOR_PATROL;
int CURSOR_REPAIR;
int CURSOR_ATTACK;
int CURSOR_BLUE;
int CURSOR_AIR_LOAD;
int CURSOR_BOMB_ATTACK;
int CURSOR_BALANCE;
int CURSOR_RECLAIM;
int CURSOR_WAIT;
int CURSOR_CANT_ATTACK;
int CURSOR_CROSS_LINK;
CAMERA *game_cam=NULL;

ANIMS cursor;

int fire;
int build_part;

int start=0;
int cursor_type=CURSOR_DEFAULT;

#define precision	MSEC_TO_TIMER(1)

volatile int Atimer;

void Timer()            // procédure Timer
{
	Atimer+=precision;
}

END_OF_FUNCTION(Timer);

/*---------------------------------------------------------------------------------\
|                              BITMAP *load_memory_pcx(...)                        |
|        Charge le fichier pcx dont data pointe les données                        |
\---------------------------------------------------------------------------------*/
BITMAP *load_memory_pcx(byte *data,RGB *cpal)
{
	if(cpal==NULL) return NULL;		// On ne peut pas charger de fichier 8bits sans palette graphique
	short width,height;
	width=*((short*)(data+8));		// Dimensions
	height=*((short*)(data+10));
	width-=*((short*)(data+4));		// Dimensions
	height-=*((short*)(data+6));

	width++;
	height++;

	BITMAP *pcx=create_bitmap(width,height);
	clear(pcx);

	int pos=128;
	for(int y=0;y<pcx->h;y++) {
		int x=0;
		do
		{
			int c=data[pos++];
			if(c>191) {
				int l=c-192;
				c=data[pos++];
				int col=makecol(cpal[c].r<<2,cpal[c].g<<2,cpal[c].b<<2);
				for(;l>0 && x<pcx->w;l--)
					((int*)(pcx->line[y]))[x++]=col;
				}
			else
				((int*)(pcx->line[y]))[x++]=makecol(cpal[c].r<<2,cpal[c].g<<2,cpal[c].b<<2);
		}while(x<pcx->w);
		}
	return pcx;
}

/*---------------------------------------------------------------------------------\
|                                  int min(int a,int b)                            |
|        Renvoie l'entier le plus petit entre a et b                               |
\---------------------------------------------------------------------------------*/

#ifndef ALLEGRO_WINDOWS

int min(int a,int b)
{
	return (a<b ? a : b);
}

float min(float a,float b)
{
	return (a<b ? a : b);
}

int max(int a,int b)
{
	return (a<b ? b : a);
}

float max(float a,float b)
{
	return (a<b ? b : a);
}

#endif

/*---------------------------------------------------------------------------------\
|                                   RGB *LoadPal(..)                               |
|        Procédure qui charge la palette graphique d'un fichier pal                |
\---------------------------------------------------------------------------------*/
RGB *LoadPal(char *filename)
{
	RGB *pal=new RGB[256];		// Génère une nouvelle palette

	byte *palette=load_file(filename);

	if(palette) {
		for(int i=0;i<256;i++) {
			pal[i].r=palette[i<<2]>>2;
			pal[i].g=palette[(i<<2)+1]>>2;
			pal[i].b=palette[(i<<2)+2]>>2;
			}
		free(palette);
		}

	return pal;
}

/*---------------------------------------------------------------------------------\
|                                   void PutTex(...)                               |
|        Procédure qui affiche la texture Tex dans le rectangle (x1,y1)-(x2,y2)    |
\---------------------------------------------------------------------------------*/

void PutTex(GLuint Tex,float x1,float y1,float x2,float y2)
{
	glBindTexture(GL_TEXTURE_2D,Tex);
	glBegin(GL_QUADS);

		glTexCoord2f(0.0f,0.0f);
		glVertex2f(x1,y1);

		glTexCoord2f(1.0f,0.0f);
		glVertex2f(x2,y1);
					
		glTexCoord2f(1.0f,1.0f);
		glVertex2f(x2,y2);
			
		glTexCoord2f(0.0f,1.0f);
		glVertex2f(x1,y2);

	glEnd();
}

GLuint LoadTex(char *file)
{
	set_color_depth(32);
	allegro_gl_use_alpha_channel(true);
	BITMAP *bmp=load_bitmap(file,NULL);
	GLuint gl_bmp;
	if(g_useTextureCompression)
		allegro_gl_set_texture_format(GL_COMPRESSED_RGBA_ARB);
	else
		allegro_gl_set_texture_format(GL_RGBA8);
	gl_bmp=allegro_gl_make_texture(bmp);
	allegro_gl_use_alpha_channel(false);
	glBindTexture(GL_TEXTURE_2D, gl_bmp);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
	allegro_gl_set_texture_format(-1);
	destroy_bitmap(bmp);
	return gl_bmp;
}

GLuint LoadMaskedTex(char *file,char *filealpha)
{
	set_color_depth(32);
	BITMAP *bmp=load_bitmap(file,NULL);
	BITMAP *alpha;
	set_color_depth(8);
	alpha=load_bitmap(filealpha,NULL);
	set_color_depth(32);
	for(int y=0;y<bmp->h;y++)
		for(int x=0;x<bmp->w;x++)
			bmp->line[y][(x<<2)+3]=alpha->line[y][x];
	GLuint gl_bmp;
	allegro_gl_use_alpha_channel(true);
	if(g_useTextureCompression)
		allegro_gl_set_texture_format(GL_COMPRESSED_RGBA_ARB);
	else
		allegro_gl_set_texture_format(GL_RGBA8);
	gl_bmp=allegro_gl_make_texture(bmp);
	allegro_gl_use_alpha_channel(false);
	glBindTexture(GL_TEXTURE_2D, gl_bmp);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
	destroy_bitmap(bmp);
	destroy_bitmap(alpha);
	return gl_bmp;
}

BITMAP *LoadMaskedTexBmp(char *file,char *filealpha)
{
	set_color_depth(32);
	BITMAP *bmp=load_bitmap(file,NULL);
	set_color_depth(8);
	BITMAP *alpha=load_bitmap(filealpha,NULL);
	set_color_depth(32);
	for(int y=0;y<bmp->h;y++)
		for(int x=0;x<bmp->w;x++)
			bmp->line[y][(x<<2)+3]=alpha->line[y][x];
	destroy_bitmap(alpha);
	return bmp;
}

#include "3do.h"					// Pour la lecture des fichiers 3D
#include "cob.h"					// Pour la lecture et l'éxecution des scripts
#include "tdf.h"					// Pour la gestion des éléments du jeu
#include "EngineClass.h"			// Inclus le moteur
#include "tnt.h"					// Inclus le chargeur de cartes
#include "script.h"					// Inclus le gestionnaire de scripts
#include "ia.h"						// Inclus le moteur d'I.A.

/*-----------------------------------------------------------------\
|                    void SetDefOpenGlState (void)                 |
|    Configure OpenGl avec les valeurs courantes pour le programme |
\-----------------------------------------------------------------*/

void ReInitTexSys()
{
	glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glMatrixMode(GL_TEXTURE);
		glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
}

void SetDefOpenGlState()
{
	glClearColor (0, 0, 0, 0);
	glShadeModel (GL_SMOOTH);
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
	glPolygonMode (GL_BACK, GL_POINTS);
	glDepthFunc( GL_LESS);
	glEnable (GL_DEPTH_TEST);
	glCullFace (GL_BACK);
	glEnable (GL_CULL_FACE);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
	ReInitTexSys();
}
