/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                      taconfig.h                                    |
|  ce fichier contient les structures, classes et fonctions nécessaires à la gestion |
| de la configuration de TA3D: sauvegarde, chargement, modification des options du   |
| jeu.                                                                               |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#include <string.h>

struct CONFIG_OPTION		// Structure utilisée pour faire le lien avec les options du programme
{
	void	*data;
	bool	boolean;
	bool	floatting;
	char	*name;
	int		d;
	float	f;
};

class TA3D_CONFIG
{
public:
	char			*config_file;		// Fichier de configuration
	int				nb_options;
	CONFIG_OPTION	*options;			// Données de configuration

	void init()
	{
		config_file=NULL;
		nb_options=0;
		options=NULL;
	}

	void destroy()
	{
		if(config_file)	free(config_file);
		if(nb_options>0 && options!=NULL) {
			for(int i=0;i<nb_options;i++)
				if(options[i].name)	free(options[i].name);
			delete options;
			}
		init();
	}

	TA3D_CONFIG()
	{
		init();
	}

	~TA3D_CONFIG()
	{
		destroy();
	}

	void set_config_file(char *name);

	void add_option(char *name,bool b,bool f,void *p);

	float get_option(char *name);

	float get_option(int idx);

	void set_option(char *name,float v);

	int read_config_file(char *name=NULL);

	void write_config_file(char *name=NULL);
};
