/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*--------------------------------------------------------------\
|                          glfunc.h                             |
|      contient les fonctions et les variables permettant d'    |
|  utiliser des extensions d'OpenGl. utilise AllegroGl          |
\--------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include <stdio.h>
#include <string.h>
#include "glfunc.h"

bool	MultiTexturing;
bool	g_useTextureCompression = false;
bool	g_useStencilTwoSide = false;
bool	g_useCopyDepthToColor = false;
bool	g_useProgram = false;

void install_ext()
{
	MultiTexturing=false;
			// Extension pour le multitexturing
	if(glActiveTextureARB!=NULL && glMultiTexCoord2fARB!=NULL && glClientActiveTextureARB!=NULL) MultiTexturing=true;

	g_useTextureCompression = allegro_gl_is_extension_supported("GL_ARB_texture_compression");
	g_useStencilTwoSide = allegro_gl_is_extension_supported("GL_EXT_stencil_two_side");
	g_useCopyDepthToColor = allegro_gl_is_extension_supported("GL_NV_copy_depth_to_color");
	g_useProgram = allegro_gl_is_extension_supported("GL_ARB_shader_objects") && allegro_gl_is_extension_supported("GL_ARB_shading_language_100") && allegro_gl_is_extension_supported("GL_ARB_vertex_shader") && allegro_gl_is_extension_supported("GL_ARB_fragment_shader");
}

GLhandleARB load_fragment_shader(char *filename)
{
	FILE *file=fopen(filename,"rt");
	GLhandleARB	shader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);
	if(file==NULL)	{
		printf("fichier inexistant\n");
		return shader;
		}
	int filesize=file_size(filename);

	char *buf=(char*) malloc(filesize+1);
	fread(buf,filesize,1,file);
	buf[filesize]=0;
	fclose(file);

	GLint length = (GLint) strlen(buf);
	int compiled = 0;

	glShaderSourceARB(shader, 1, (const GLcharARB **)&buf, &filesize);
	glCompileShaderARB(shader); 
	glGetObjectParameterivARB(shader, GL_OBJECT_COMPILE_STATUS_ARB, &compiled);

	if (compiled) 
	{ // compilation successful!
		printf("%s correctement chargé\n",filename);
	}
	else 
	{ // compilation error! Check compiler log! 
		printf("%s : la compilation a échoué\n",filename);
		char log[10000];
		GLsizei len=0;
		glGetInfoLogARB(shader, 10000, &len, log);
		printf("%s\n",log);
	}

	free(buf);
	return shader;
}

GLhandleARB load_vertex_shader(char *filename)
{
	FILE *file=fopen(filename,"rt");
	GLhandleARB	shader = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);
	if(file==NULL)	{
		printf("fichier inexistant\n");
		return shader;
		}
	int filesize=file_size(filename);

	char *buf=(char*) malloc(filesize+1);
	fread(buf,filesize,1,file);
	buf[filesize]=0;
	fclose(file);

	GLint length = (GLint) strlen(buf);
	int compiled = 0;

	glShaderSourceARB(shader, 1, (const GLcharARB **)&buf, &filesize);
	glCompileShaderARB(shader);
	glGetObjectParameterivARB(shader, GL_OBJECT_COMPILE_STATUS_ARB, &compiled);

	if (compiled) 
	{ // compilation successful!
		printf("%s correctement chargé\n",filename);
	}
	else 
	{ // compilation error! Check compiler log! 
		printf("%s : la compilation a échoué\n",filename);
		char log[10000];
		GLsizei len=0;
		glGetInfoLogARB(shader, 10000, &len, log);
		printf("%s\n",log);
	}

	free(buf);
	return shader;
}
